/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.retriever.DocumentParserFactory;
import org.netbeans.modules.xml.retriever.DocumentTypeParser;
import org.netbeans.modules.xml.retriever.catalog.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoCollector {
    Map<File, List<InfoEntry>> allFiles2Info = new HashMap<File, List<InfoEntry>>();
    Map<File, List<InfoEntry>> errorFiles2Info = new HashMap<File, List<InfoEntry>>();
    Map<File, List<InfoEntry>> warningFiles2Info = new HashMap<File, List<InfoEntry>>();
    private Map<File, List<InfoEntry>> absURL2Info = new HashMap<File, List<InfoEntry>>();
    List<File> goodFileList = new ArrayList<File>();
    File root = null;

    public InfoCollector(File root) {
        this.root = root;
        this.goCollect();
    }

    public void goCollect() {
        List<File> xsdFiles = Utilities.getFilesWithExtension(this.root, Utilities.DocumentTypesEnum.schema.toString(), null);
        Map<File, List<String>> xsdFile2Refs = this.getAllExternalRefs(xsdFiles, Utilities.DocumentTypesEnum.schema);
        List<File> wsdlFiles = Utilities.getFilesWithExtension(this.root, Utilities.DocumentTypesEnum.wsdl.toString(), null);
        Map<File, List<String>> wsdlFile2Refs = this.getAllExternalRefs(wsdlFiles, Utilities.DocumentTypesEnum.wsdl);
        HashMap<File, List<String>> file2Refs = new HashMap<File, List<String>>();
        file2Refs.putAll(xsdFile2Refs);
        file2Refs.putAll(wsdlFile2Refs);
        this.analyzeResult(file2Refs);
        this.makeGoodFileList();
    }

    private Map<File, List<String>> getAllExternalRefs(List<File> files, Utilities.DocumentTypesEnum docType) {
        HashMap<File, List<String>> file2Refs = new HashMap<File, List<String>>();
        for (File file : files) {
            DocumentTypeParser schParser = DocumentParserFactory.getParser(docType);
            List<String> externalRefList = null;
            try {
                externalRefList = schParser.getAllLocationOfReferencedEntities(file);
            }
            catch (Exception ex) {
                externalRefList = Collections.emptyList();
            }
            file2Refs.put(file, externalRefList);
        }
        return file2Refs;
    }

    private void analyzeResult(Map<File, List<String>> file2Refs) {
        for (File file : file2Refs.keySet()) {
            List<String> extRefList = file2Refs.get(file);
            if (extRefList.size() <= 0) {
                this.placeInProperBucket(file, new InfoEntry(null, InfoType.relative_ok));
                continue;
            }
            for (String refStr : extRefList) {
                InfoEntry infEnt = this.analyze(file, refStr);
                this.placeInProperBucket(file, infEnt);
            }
        }
    }

    private void placeInProperBucket(File file, InfoEntry infEnt) {
        InfoType infoType = infEnt.getInfoType();
        this.placeIn(this.allFiles2Info, file, infEnt);
        switch (infoType) {
            case url: {
                this.placeIn(this.absURL2Info, file, infEnt);
                break;
            }
            case absolute_ok: 
            case absolute_bad: 
            case bad_uri: 
            case relative_notfound: {
                this.placeIn(this.warningFiles2Info, file, infEnt);
                break;
            }
            case relative_bad_found: 
            case relative_bad_not_found: {
                this.placeIn(this.errorFiles2Info, file, infEnt);
                break;
            }
        }
    }

    private void placeIn(Map<File, List<InfoEntry>> files2Info, File file, InfoEntry infEnt) {
        List<InfoEntry> infEntList = files2Info.get(file);
        if (infEntList == null) {
            ArrayList<InfoEntry> newEntList = new ArrayList<InfoEntry>();
            newEntList.add(infEnt);
            files2Info.put(file, newEntList);
        } else {
            infEntList.add(infEnt);
        }
    }

    private void makeGoodFileList() {
        for (File file : this.allFiles2Info.keySet()) {
            if (this.errorFiles2Info.containsKey(file)) continue;
            this.goodFileList.add(file);
        }
    }

    private InfoEntry analyze(File file, String refStr) {
        String rootURIStr = this.root.toURI().toString();
        URI fileURI = file.toURI();
        URI refURI = null;
        try {
            refURI = new URI(refStr);
        }
        catch (URISyntaxException ex) {
            return new InfoEntry(refStr, InfoType.bad_uri);
        }
        catch (NullPointerException npe) {
            return new InfoEntry(refStr, InfoType.bad_uri);
        }
        if (refURI.isAbsolute()) {
            if (refURI.getScheme().equalsIgnoreCase("http")) {
                return new InfoEntry(refStr, InfoType.url);
            }
            return new InfoEntry(refStr, InfoType.absolute_ok);
        }
        URI finalRes = fileURI.resolve(refURI);
        if (finalRes.toString().startsWith(rootURIStr)) {
            File childFile = new File(finalRes);
            if (childFile.isFile()) {
                return new InfoEntry(refStr, InfoType.relative_ok);
            }
            return new InfoEntry(refStr, InfoType.relative_notfound);
        }
        File childfile = new File(finalRes);
        if (childfile.isFile()) {
            return new InfoEntry(refStr, InfoType.relative_bad_found);
        }
        return new InfoEntry(refStr, InfoType.relative_bad_not_found);
    }

    public List<File> getCopyableFileList() {
        return this.goodFileList;
    }

    public Map<File, List<InfoEntry>> getWarnings() {
        return this.warningFiles2Info;
    }

    public Map<File, List<InfoEntry>> getErrors() {
        return this.errorFiles2Info;
    }

    Map<File, List<InfoEntry>> getAllEntries() {
        return this.allFiles2Info;
    }

    public boolean hasErrors() {
        return this.errorFiles2Info.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warningFiles2Info.size() > 0;
    }

    public boolean hasReports() {
        return this.hasErrors() || this.hasWarnings();
    }

    public Map<File, List<InfoEntry>> getAbsURL2Info() {
        return this.absURL2Info;
    }

    static class InfoEntry {
        String childStr;
        InfoType infoType;

        public InfoEntry(String childStr, InfoType infoType) {
            this.childStr = childStr;
            this.infoType = infoType;
        }

        public String getChildStr() {
            return this.childStr;
        }

        public InfoType getInfoType() {
            return this.infoType;
        }

        public String toString() {
            return "[Ref:" + this.childStr + ", InfoType:" + this.infoType.toString() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InfoType {
        url,
        relative_ok,
        relative_bad_found,
        relative_bad_not_found,
        relative_notfound,
        absolute_ok,
        absolute_bad,
        bad_uri;

    }
}

