/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.netbeans.nbbuild.ModuleTracking;
import org.netbeans.nbbuild.UpdateTracking;

public class MakeNBM
extends Task {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private File productDir = null;
    private File file = null;
    private File manifest = null;
    private String moduleName = null;
    private String homepage = null;
    private String distribution = "";
    private String needsrestart = null;
    private String moduleauthor = null;
    private String releasedate = null;
    private String global = null;
    private String jarSignerMaxMemory = "96m";
    private Blurb license = null;
    private Blurb description = null;
    private Blurb notification = null;
    private Signature signature = null;
    private long mostRecentInput = 0L;
    private boolean isStandardInclude = true;
    private Vector externalPackages = null;
    private ZipFileSet main = null;

    private static String xmlEscape(String s) {
        int max = s.length();
        StringBuffer s2 = new StringBuffer((int)((double)max * 1.1 + 1.0));
        block6: for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    s2.append("&lt;");
                    continue block6;
                }
                case '>': {
                    s2.append("&gt;");
                    continue block6;
                }
                case '&': {
                    s2.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    s2.append("&quot;");
                    continue block6;
                }
                default: {
                    s2.append(c);
                }
            }
        }
        return s2.toString();
    }

    public void setIsStandardInclude(boolean isStandardInclude) {
        this.isStandardInclude = isStandardInclude;
    }

    public void setProductDir(File dir) {
        this.productDir = dir;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
        long lmod = manifest.lastModified();
        if (lmod > this.mostRecentInput) {
            this.mostRecentInput = lmod;
        }
        this.log(this.getLocation() + "The 'manifest' attr on <makenbm> is deprecated, please use 'module' instead", 1);
    }

    public void setModule(String module) {
        this.moduleName = module;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setNeedsrestart(String needsrestart) {
        this.needsrestart = needsrestart;
    }

    public void setModuleauthor(String author) {
        this.moduleauthor = author;
    }

    public void setGlobal(String isGlobal) {
        this.global = isGlobal;
    }

    public void setJarSignerMaxMemory(String jsmm) {
        this.jarSignerMaxMemory = jsmm;
    }

    public void setReleasedate(String date) {
        this.releasedate = date;
    }

    public void setDistribution(String distribution) throws BuildException {
        this.distribution = distribution;
        if (!this.distribution.equals("")) {
            try {
                URI uri = URI.create(this.distribution);
            }
            catch (IllegalArgumentException ile) {
                throw new BuildException("Distribution URL \"" + this.distribution + "\" is not a valid URI", (Throwable)ile, this.getLocation());
            }
        }
    }

    public Blurb createLicense() {
        this.license = new Blurb();
        return this.license;
    }

    public Blurb createNotification() {
        this.notification = new Blurb();
        return this.notification;
    }

    public Blurb createDescription() {
        this.log(this.getLocation() + "The <description> subelement in <makenbm> is deprecated except for emergency patches, please ensure your module has an OpenIDE-Module-Long-Description instead", 1);
        this.description = new Blurb();
        return this.description;
    }

    public Signature createSignature() {
        this.signature = new Signature();
        return this.signature;
    }

    public ExternalPackage createExternalPackage() {
        ExternalPackage externalPackage = new ExternalPackage();
        if (this.externalPackages == null) {
            this.externalPackages = new Vector();
        }
        this.externalPackages.add(externalPackage);
        return externalPackage;
    }

    public ZipFileSet createMain() {
        this.main = new ZipFileSet();
        return this.main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Attributes attr;
        File infofile;
        File file;
        block75: {
            if (this.productDir == null) {
                throw new BuildException("must set directory of compiled product", this.getLocation());
            }
            if (this.file == null) {
                throw new BuildException("must set file for makenbm", this.getLocation());
            }
            if (this.manifest == null && this.moduleName == null) {
                throw new BuildException("must set module for makenbm", this.getLocation());
            }
            if (this.manifest != null && this.moduleName != null) {
                throw new BuildException("cannot set both manifest and module for makenbm", this.getLocation());
            }
            String rootDir = this.getProject().getProperty("nbm.target.dir");
            file = rootDir != null && !rootDir.equals("") ? new File(rootDir, this.file.getName()) : this.file;
            this.overrideURLIfNeeded();
            this.overrideLicenseIfNeeded();
            File module = new File(this.productDir, this.moduleName);
            infofile = null;
            attr = null;
            if (module != null) {
                long mMod = module.lastModified();
                if (this.mostRecentInput < mMod) {
                    this.mostRecentInput = mMod;
                }
                try {
                    JarFile modulejar = new JarFile(module);
                    try {
                        attr = modulejar.getManifest().getMainAttributes();
                        String bundlename = attr.getValue("OpenIDE-Module-Localizing-Bundle");
                        if (bundlename == null) break block75;
                        Properties p = new Properties();
                        ZipEntry bundleentry = modulejar.getEntry(bundlename);
                        if (bundleentry != null) {
                            InputStream is = modulejar.getInputStream(bundleentry);
                            try {
                                p.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        File variant = new File(new File(module.getParentFile(), "locale"), module.getName());
                        if (!variant.isFile()) {
                            throw new BuildException(bundlename + " not found in " + module, this.getLocation());
                        }
                        long vmMod = variant.lastModified();
                        if (this.mostRecentInput < vmMod) {
                            this.mostRecentInput = vmMod;
                        }
                        ZipFile variantjar = new ZipFile(variant);
                        try {
                            bundleentry = variantjar.getEntry(bundlename);
                            if (bundleentry == null) {
                                throw new BuildException(bundlename + " not found in " + module + " nor in " + variant, this.getLocation());
                            }
                            InputStream is = variantjar.getInputStream(bundleentry);
                            try {
                                p.load(is);
                            }
                            finally {
                                is.close();
                            }
                        }
                        finally {
                            variantjar.close();
                        }
                        for (Map.Entry<Object, Object> entry : p.entrySet()) {
                            String name = (String)entry.getKey();
                            if (!name.startsWith("OpenIDE-Module-")) continue;
                            attr.putValue(name, (String)entry.getValue());
                        }
                    }
                    finally {
                        modulejar.close();
                    }
                }
                catch (IOException ioe) {
                    throw new BuildException("exception while reading " + module, (Throwable)ioe, this.getLocation());
                }
            }
        }
        if (this.mostRecentInput < file.lastModified()) {
            this.log("Skipping NBM creation as most recent input is younger: " + this.mostRecentInput + " than the target file: " + file.lastModified(), 3);
            return;
        }
        this.log("Most recent input: " + this.mostRecentInput + " file: " + file.lastModified(), 4);
        try {
            infofile = File.createTempFile("info", ".xml");
            FileOutputStream infoStream = new FileOutputStream(infofile);
            try {
                PrintWriter ps = new PrintWriter(new OutputStreamWriter((OutputStream)infoStream, "UTF-8"));
                ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                ps.println("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Autoupdate Module Info 2.3//EN\" \"http://www.netbeans.org/dtds/autoupdate-info-2_3.dtd\">");
                String codenamebase = attr.getValue("OpenIDE-Module");
                if (codenamebase == null) {
                    throw new BuildException("invalid manifest, does not contain OpenIDE-Module", this.getLocation());
                }
                int idx = codenamebase.lastIndexOf(47);
                if (idx != -1) {
                    codenamebase = codenamebase.substring(0, idx);
                }
                ps.println("<module codenamebase=\"" + MakeNBM.xmlEscape(codenamebase) + "\"");
                if (this.homepage != null) {
                    ps.println("        homepage=\"" + MakeNBM.xmlEscape(this.homepage) + "\"");
                }
                if (this.distribution == null) {
                    throw new BuildException("NBM distribution URL is not set", this.getLocation());
                }
                ps.println("        distribution=\"" + MakeNBM.xmlEscape(this.distribution) + "\"");
                if (this.license != null) {
                    String name = this.license.getName();
                    if (name == null) {
                        throw new BuildException("Every license must have a name or file attribute", this.getLocation());
                    }
                    ps.println("        license=\"" + MakeNBM.xmlEscape(name) + "\"");
                }
                ps.println("        downloadsize=\"0\"");
                if (this.needsrestart != null) {
                    ps.println("        needsrestart=\"" + MakeNBM.xmlEscape(this.needsrestart) + "\"");
                }
                if (this.global != null && !"".equals(this.global)) {
                    ps.println("        global=\"" + MakeNBM.xmlEscape(this.global) + "\"");
                }
                if (this.moduleauthor != null) {
                    ps.println("        moduleauthor=\"" + MakeNBM.xmlEscape(this.moduleauthor) + "\"");
                }
                if (this.releasedate == null || "".equals(this.releasedate)) {
                    this.releasedate = DATE_FORMAT.format(new Date(System.currentTimeMillis()));
                }
                ps.println("        releasedate=\"" + MakeNBM.xmlEscape(this.releasedate) + "\"");
                ps.println(">");
                if (this.description != null) {
                    ps.print("  <description>");
                    ps.print(this.description.getText());
                    ps.println("</description>");
                }
                if (this.notification != null) {
                    ps.print("  <module_notification>");
                    ps.print(this.notification.getText());
                    ps.println("</module_notification>");
                }
                if (this.externalPackages != null) {
                    Enumeration exp = this.externalPackages.elements();
                    while (exp.hasMoreElements()) {
                        ExternalPackage externalPackage = (ExternalPackage)exp.nextElement();
                        if (externalPackage.name == null || externalPackage.targetName == null || externalPackage.startUrl == null) {
                            throw new BuildException("Must define name, targetname, starturl for external package");
                        }
                        ps.print("  <external_package ");
                        ps.print("name=\"" + MakeNBM.xmlEscape(externalPackage.name) + "\" ");
                        ps.print("target_name=\"" + MakeNBM.xmlEscape(externalPackage.targetName) + "\" ");
                        ps.print("start_url=\"" + MakeNBM.xmlEscape(externalPackage.startUrl) + "\"");
                        if (externalPackage.description != null) {
                            ps.print(" description=\"" + MakeNBM.xmlEscape(externalPackage.description) + "\"");
                        }
                        ps.println("/>");
                    }
                }
                ps.print("  <manifest ");
                boolean firstline = true;
                ArrayList<String> attrNames = new ArrayList<String>(attr.size());
                Iterator<Object> it = attr.keySet().iterator();
                while (it.hasNext()) {
                    attrNames.add(((Attributes.Name)it.next()).toString());
                }
                Collections.sort(attrNames);
                for (String name : attrNames) {
                    if (!name.startsWith("OpenIDE-Module") || name.equals("OpenIDE-Module-Localizing-Bundle") || name.equals("OpenIDE-Module-Install") || name.equals("OpenIDE-Module-Layer") || name.equals("OpenIDE-Module-Description") || name.equals("OpenIDE-Module-Package-Dependency-Message") || name.equals("OpenIDE-Module-Public-Packages")) continue;
                    if (firstline) {
                        firstline = false;
                    } else {
                        ps.print("            ");
                    }
                    ps.println(name + "=\"" + MakeNBM.xmlEscape(attr.getValue(name)) + "\"");
                }
                ps.println("  />");
                if (this.license != null) {
                    ps.print("  <license name=\"" + MakeNBM.xmlEscape(this.license.getName()) + "\">");
                    ps.print(this.license.getText());
                    ps.println("</license>");
                }
                ps.println("</module>");
                ps.flush();
            }
            finally {
                ((OutputStream)infoStream).close();
            }
        }
        catch (IOException e) {
            throw new BuildException("exception when creating Info/info.xml", (Throwable)e, this.getLocation());
        }
        infofile.deleteOnExit();
        ZipFileSet infoXML = new ZipFileSet();
        infoXML.setFile(infofile);
        infoXML.setFullpath("Info/info.xml");
        String codename = attr.getValue("OpenIDE-Module");
        if (codename == null) {
            new BuildException("Can't get codenamebase");
        }
        UpdateTracking tracking = new UpdateTracking(this.productDir.getAbsolutePath());
        String[] files = tracking.getListOfNBM(codename);
        this.log("Going to update module_tracking.xml record for " + codename + " in file " + file.getName(), 4);
        String mtdir = new File(this.productDir.getAbsolutePath()).getParent();
        this.log("  attempting to use module_tracking.xml file in directory " + mtdir, 4);
        ModuleTracking mt = new ModuleTracking(mtdir);
        ModuleTracking.Module mtm = (ModuleTracking.Module)mt.getModulesByCodeName().get(codename);
        if (mtm != null) {
            this.log("  file: \"" + mtm.getNbmFileName() + "\" => \"" + file.getName() + "\"", 4);
            mtm.setNbmFileName(file.getName());
            this.log("  homepage: \"" + mtm.getNbmHomePage() + "\" => \"" + this.homepage + "\"", 4);
            mtm.setNbmHomePage(this.homepage);
            this.log("  moduleauthor: \"" + mtm.getNbmModuleAuthor() + "\" => \"" + this.moduleauthor + "\"", 4);
            mtm.setNbmModuleAuthor(this.moduleauthor);
            this.log("  needsrestart: \"" + mtm.getNbmNeedsRestart() + "\" => \"" + this.needsrestart + "\"", 4);
            mtm.setNbmNeedsRestart(this.needsrestart);
            this.log("  global: \"" + mtm.getNbmIsGlobal() + "\" => \"" + this.global + "\"", 4);
            mtm.setNbmIsGlobal(this.global);
            this.log("  releasedate: \"" + mtm.getNbmReleaseDate() + "\" => \"" + this.releasedate + "\"", 4);
            mtm.setNbmReleaseDate(this.releasedate);
            mt.write();
        } else {
            this.log("ModuleTracking.Module record doesn't exist for " + codename + " and file " + file.getName(), 4);
        }
        ZipFileSet fs = new ZipFileSet();
        fs.setDir(this.productDir);
        for (int i = 0; i < files.length; ++i) {
            fs.createInclude().setName(files[i]);
        }
        fs.setPrefix("netbeans/");
        long jarModified = file.lastModified();
        Jar jar = (Jar)this.getProject().createTask("jar");
        jar.setDestFile(file);
        jar.addZipfileset(fs);
        jar.addFileset((FileSet)infoXML);
        if (this.main != null) {
            this.main.setPrefix("main");
            jar.addZipfileset(this.main);
        }
        jar.setCompress(true);
        jar.setLocation(this.getLocation());
        jar.init();
        jar.execute();
        if (file.lastModified() != jarModified) {
            if (this.overrideLicense()) {
                this.log("Overriding license with: " + this.getLicenseOverride());
            }
            if (this.overrideURL()) {
                this.log("Overriding homepage URL with: " + this.getURLOverride());
            }
        }
        if (this.signature != null && file.lastModified() != jarModified) {
            if (this.signature.keystore == null) {
                throw new BuildException("must define keystore attribute on <signature/>");
            }
            if (this.signature.storepass == null) {
                throw new BuildException("must define storepass attribute on <signature/>");
            }
            if (this.signature.alias == null) {
                throw new BuildException("must define alias attribute on <signature/>");
            }
            if (this.signature.storepass.equals("?") || !this.signature.keystore.exists()) {
                this.log("Not signing NBM file " + file + "; no stored-key password provided or keystore (" + this.signature.keystore.toString() + ") doesn't exist", 1);
            } else {
                this.log("Signing NBM file " + file);
                SignJar signjar = (SignJar)this.getProject().createTask("signjar");
                try {
                    try {
                        Class[] paramsT = new Class[]{String.class};
                        Object[] paramsV1 = new Object[]{this.signature.keystore.getAbsolutePath()};
                        Object[] paramsV2 = new Object[]{file.getAbsolutePath()};
                        signjar.getClass().getDeclaredMethod("setKeystore", paramsT).invoke((Object)signjar, paramsV1);
                        signjar.getClass().getDeclaredMethod("setJar", paramsT).invoke((Object)signjar, paramsV2);
                    }
                    catch (NoSuchMethodException ex1) {
                        try {
                            Class[] paramsT = new Class[]{File.class};
                            Object[] paramsV1 = new Object[]{this.signature.keystore};
                            Object[] paramsV2 = new Object[]{file};
                            signjar.getClass().getDeclaredMethod("setKeystore", paramsT).invoke((Object)signjar, paramsV1);
                            signjar.getClass().getDeclaredMethod("setJar", paramsT).invoke((Object)signjar, paramsV2);
                        }
                        catch (NoSuchMethodException ex2) {
                            try {
                                Class[] paramsT1 = new Class[]{File.class};
                                Class[] paramsT2 = new Class[]{String.class};
                                Object[] paramsV1 = new Object[]{this.signature.keystore.getAbsolutePath()};
                                Object[] paramsV2 = new Object[]{file};
                                signjar.getClass().getDeclaredMethod("setKeystore", paramsT2).invoke((Object)signjar, paramsV1);
                                signjar.getClass().getDeclaredMethod("setJar", paramsT1).invoke((Object)signjar, paramsV2);
                            }
                            catch (NoSuchMethodException ex3) {
                                throw new BuildException("Unknown Ant version, only Ant 1.6.5 is currently supported.");
                            }
                        }
                    }
                }
                catch (IllegalAccessException ex3) {
                    throw new BuildException((Throwable)ex3);
                }
                catch (InvocationTargetException ex4) {
                    throw new BuildException((Throwable)ex4);
                }
                signjar.setStorepass(this.signature.storepass);
                signjar.setAlias(this.signature.alias);
                signjar.setLocation(this.getLocation());
                signjar.setMaxmemory(this.jarSignerMaxMemory);
                signjar.init();
                signjar.execute();
            }
        }
    }

    protected boolean overrideLicense() {
        return this.getLicenseOverride() != null;
    }

    protected String getLicenseOverride() {
        String s = this.getProject().getProperty("makenbm.override.license");
        if (s != null && s.equals("")) {
            s = null;
        }
        return s;
    }

    protected boolean overrideURL() {
        return this.getURLOverride() != null;
    }

    protected String getURLOverride() {
        String s = this.getProject().getProperty("makenbm.override.url");
        if (s != null && s.equals("")) {
            s = null;
        }
        return s;
    }

    protected void overrideLicenseIfNeeded() {
        if (this.overrideLicense()) {
            this.license = new Blurb();
            this.license.setFile(new File(this.getLicenseOverride()));
        }
    }

    protected void overrideURLIfNeeded() {
        if (this.overrideURL()) {
            this.homepage = this.getURLOverride();
        }
    }

    public class Signature {
        public File keystore;
        public String storepass;
        public String alias;

        public void setKeystore(File f) {
            this.keystore = f;
        }

        public void setStorepass(String s) {
            this.storepass = s;
        }

        public void setAlias(String s) {
            this.alias = s;
        }
    }

    public class ExternalPackage {
        String name = null;
        String targetName = null;
        String startUrl = null;
        String description = null;

        public void setName(String n) {
            this.name = n;
        }

        public void setTargetName(String t) {
            this.targetName = t;
        }

        public void setStartURL(String u) {
            this.startUrl = u;
        }

        public void setDescription(String d) {
            this.description = d;
        }
    }

    public class Blurb {
        private StringBuffer text = new StringBuffer();
        private String name = null;

        public void addText(String t) {
            String line;
            this.addSeparator();
            t = MakeNBM.this.getProject().replaceProperties(t.trim());
            int min = Integer.MAX_VALUE;
            StringTokenizer tok = new StringTokenizer(t, "\n");
            boolean first = true;
            while (tok.hasMoreTokens()) {
                int i;
                line = tok.nextToken();
                if (first) {
                    first = false;
                    continue;
                }
                for (i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
                }
                if (i >= min) continue;
                min = i;
            }
            if (min == 0) {
                this.text.append(t);
            } else {
                tok = new StringTokenizer(t, "\n");
                first = true;
                while (tok.hasMoreTokens()) {
                    line = tok.nextToken();
                    if (first) {
                        first = false;
                    } else {
                        this.text.append('\n');
                        line = line.substring(min);
                    }
                    this.text.append(line);
                }
            }
        }

        public FileInsert createFile() {
            return new FileInsert();
        }

        public Text createText() {
            return new Text();
        }

        private void addSeparator() {
            if (this.text.length() > 0) {
                if (this.text.charAt(this.text.length() - 1) != '\n') {
                    this.text.append('\n');
                }
                this.text.append("-----------------------------------------------------\n");
            }
        }

        public String getText() {
            String nocdata = MakeNBM.this.getProject().getProperty("makenbm.nocdata");
            if (nocdata != null && Project.toBoolean((String)nocdata)) {
                return MakeNBM.xmlEscape(this.text.toString());
            }
            return "<![CDATA[" + this.text.toString() + "]]>";
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setFile(File file) {
            new FileInsert().setLocation(file);
            if (this.name == null) {
                this.name = file.getName();
            }
        }

        public class Text {
            public void addText(String t) {
                Blurb.this.addText(t);
            }
        }

        public class FileInsert {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setLocation(File file) throws BuildException {
                boolean html = file.getName().endsWith(".html") || file.getName().endsWith(".htm");
                MakeNBM.this.log("Including contents of " + file + " (HTML mode: " + html + ")", 3);
                long lmod = file.lastModified();
                if (lmod > MakeNBM.this.mostRecentInput) {
                    MakeNBM.this.mostRecentInput = lmod;
                }
                Blurb.this.addSeparator();
                try {
                    FileInputStream is = new FileInputStream(file);
                    try {
                        String line;
                        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                        while ((line = r.readLine()) != null) {
                            if (html) {
                                line = line.replaceAll("</?[a-zA-Z0-9_.:-]+( +[a-zA-Z0-9_.:-]+( *= *([^ \"]+|\"[^\"]*\"))?)*/?>", "");
                                line = line.replaceAll("<![a-zA-Z]+[^>]*>", "");
                                line = line.replaceAll("<!--([^-]|-[^-])*-->", "");
                                line = line.replaceAll("&quot;", "\"");
                                line = line.replaceAll("&nbsp;", " ");
                                line = line.replaceAll("&copy;", "\u00a9");
                                line = line.replaceAll("&apos;", "'");
                                line = line.replaceAll("&lt;", "<");
                                line = line.replaceAll("&gt;", ">");
                                line = line.replaceAll("&amp;", "&");
                            }
                            Blurb.this.text.append(line);
                            Blurb.this.text.append('\n');
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ioe) {
                    throw new BuildException("Exception reading blurb from " + file, (Throwable)ioe, MakeNBM.this.getLocation());
                }
            }
        }
    }
}

