/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class CloseProject
extends ProjectAction
implements PropertyChangeListener,
Presenter.Popup {
    private static final String namePattern = NbBundle.getMessage((Class)CloseProject.class, (String)"LBL_CloseProjectAction_Name");
    private static final String namePatternPopup = NbBundle.getMessage((Class)CloseProject.class, (String)"LBL_CloseProjectAction_Popup_Name");
    private String popupName;
    private PropertyChangeListener wpcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault());

    public CloseProject() {
        this((Lookup)null);
    }

    public CloseProject(Lookup context) {
        super((String)null, namePattern, null, context);
        OpenProjectList.getDefault().addPropertyChangeListener(this.wpcl);
        this.refresh(this.getLookup());
    }

    protected void actionPerformed(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (ProjectUtilities.closeAllDocuments(projects)) {
            OpenProjectList.getDefault().close(projects);
        }
    }

    public void refresh(Lookup context) {
        super.refresh(context);
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length == 0 || !OpenProjectList.getDefault().isOpen(projects[0])) {
            this.setEnabled(false);
            this.popupName = ActionsUtil.formatProjectSensitiveName(namePatternPopup, new Project[0]);
        } else {
            this.setEnabled(true);
            this.popupName = ActionsUtil.formatProjectSensitiveName(namePatternPopup, projects);
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new CloseProject(actionContext);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh(this.getLookup());
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem popupPresenter = new JMenuItem(this);
        popupPresenter.setIcon(null);
        popupPresenter.setText(this.popupName);
        return popupPresenter;
    }
}

