/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ProjectChooserAccessory
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private RequestProcessor.Task updateSubprojectsTask;
    private ModelUpdater modelUpdater;
    private Boolean tempSetAsMain;
    private Map subprojectsCache = new HashMap();
    private JCheckBox jCheckBoxMain;
    private JCheckBox jCheckBoxSubprojects;
    private JLabel jLabelProjectName;
    private JList jListSubprojects;
    private JScrollPane jScrollPaneSubprojects;
    private JTextField jTextFieldProjectName;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$modules$project$ui$ProjectChooserAccessory$ProjectDirFilter;

    public ProjectChooserAccessory(JFileChooser chooser, boolean isOpenSubprojects, boolean isOpenAsMain) {
        this.initComponents();
        this.modelUpdater = new ModelUpdater();
        this.updateSubprojectsTask = new RequestProcessor("ProjectChooserAccesoryModelUpdater").create((Runnable)this.modelUpdater);
        this.updateSubprojectsTask.setPriority(1);
        this.jCheckBoxSubprojects.setSelected(isOpenSubprojects);
        this.jCheckBoxSubprojects.addActionListener(this);
        this.jCheckBoxMain.setSelected(isOpenAsMain);
        this.jCheckBoxMain.addActionListener(this);
        chooser.addPropertyChangeListener(this);
        this.jListSubprojects.setModel(new DefaultListModel());
        this.setAccessoryEnablement(false, 0);
    }

    private void initComponents() {
        this.jLabelProjectName = new JLabel();
        this.jTextFieldProjectName = new JTextField();
        this.jCheckBoxMain = new JCheckBox();
        this.jCheckBoxSubprojects = new JCheckBox();
        this.jScrollPaneSubprojects = new JScrollPane();
        this.jListSubprojects = new JList();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(0, 12, 0, 0)));
        this.jLabelProjectName.setLabelFor(this.jTextFieldProjectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProjectName, (String)NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"LBL_PrjChooser_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabelProjectName, gridBagConstraints);
        this.jLabelProjectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"AN_ProjectName"));
        this.jLabelProjectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"AD_ProjectName"));
        this.jTextFieldProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jTextFieldProjectName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxMain, (String)NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Main_CheckBox"));
        this.jCheckBoxMain.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jCheckBoxMain, gridBagConstraints);
        this.jCheckBoxMain.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jCheckBoxMain"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxSubprojects, (String)NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Subprojects_CheckBox"));
        this.jCheckBoxSubprojects.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jCheckBoxSubprojects, gridBagConstraints);
        this.jCheckBoxSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jCheckBoxSubprojects"));
        this.jListSubprojects.setSelectionMode(0);
        this.jListSubprojects.setEnabled(false);
        this.jScrollPaneSubprojects.setViewportView(this.jListSubprojects);
        this.jListSubprojects.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"ACSN_ProjectChooserAccessory_jListSubprojects"));
        this.jListSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jListSubprojects"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPaneSubprojects, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jCheckBoxSubprojects) {
            OpenProjectListSettings.getInstance().setOpenSubprojects(this.jCheckBoxSubprojects.isSelected());
        } else if (e.getSource() == this.jCheckBoxMain) {
            OpenProjectListSettings.getInstance().setOpenAsMain(this.jCheckBoxMain.isSelected());
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("SelectedFileChangedProperty".equals(e.getPropertyName()) || "SelectedFilesChangedProperty".equals(e.getPropertyName())) {
            JFileChooser chooser = (JFileChooser)e.getSource();
            ListModel spListModel = this.jListSubprojects.getModel();
            File[] projectDirs = chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
            ArrayList<Project> projects = new ArrayList<Project>(projectDirs.length);
            for (int i = 0; i < projectDirs.length; ++i) {
                File dir;
                Project project;
                if (projectDirs[i] == null || (project = ProjectChooserAccessory.getProject(dir = FileUtil.normalizeFile((File)projectDirs[i]))) == null) continue;
                projects.add(project);
            }
            if (!projects.isEmpty()) {
                this.setAccessoryEnablement(true, projects.size());
                if (projects.size() == 1) {
                    String projectName = ProjectUtils.getInformation((Project)((Project)projects.get(0))).getDisplayName();
                    this.jTextFieldProjectName.setText(projectName);
                    this.jTextFieldProjectName.setToolTipText(projectName);
                } else {
                    String pattern = NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Multiselection");
                    this.jTextFieldProjectName.setText(MessageFormat.format(pattern, new Integer(projects.size())));
                    StringBuffer toolTipText = new StringBuffer("<html>");
                    Iterator it = projects.iterator();
                    while (it.hasNext()) {
                        Project p = (Project)it.next();
                        toolTipText.append(ProjectUtils.getInformation((Project)p).getDisplayName());
                        if (!it.hasNext()) continue;
                        toolTipText.append("<br>");
                    }
                    toolTipText.append("</html>");
                    this.jTextFieldProjectName.setToolTipText(toolTipText.toString());
                }
                if (spListModel instanceof DefaultListModel) {
                    ((DefaultListModel)spListModel).clear();
                } else {
                    this.jListSubprojects.setListData(new String[0]);
                }
                if (this.modelUpdater != null) {
                    this.modelUpdater.projects = projects;
                    this.updateSubprojectsTask.schedule(100);
                }
            } else {
                File dir;
                FileObject fo;
                this.jTextFieldProjectName.setText("");
                if (this.modelUpdater != null) {
                    this.modelUpdater.projects = null;
                }
                if (spListModel instanceof DefaultListModel) {
                    ((DefaultListModel)spListModel).clear();
                } else {
                    this.jListSubprojects.setListData(new String[0]);
                }
                this.setAccessoryEnablement(false, 0);
                if (projectDirs.length == 1 && projectDirs[0] != null && (fo = FileUtil.toFileObject((File)(dir = FileUtil.normalizeFile((File)projectDirs[0])))) != null && fo.isFolder()) {
                    try {
                        ProjectManager.getDefault().findProject(fo);
                    }
                    catch (IOException x) {
                        String msg = x.toString();
                        ErrorManager.Annotation[] anns = ErrorManager.getDefault().findAnnotations((Throwable)x);
                        for (int i = 0; i < anns.length; ++i) {
                            if (anns[i].getLocalizedMessage() == null) continue;
                            msg = anns[i].getLocalizedMessage();
                            break;
                        }
                        this.jTextFieldProjectName.setText(msg);
                        this.jTextFieldProjectName.setCaretPosition(0);
                        Color error = UIManager.getColor("nb.errorForeground");
                        if (error != null) {
                            this.jTextFieldProjectName.setForeground(error);
                        }
                        this.jLabelProjectName.setEnabled(true);
                        this.jTextFieldProjectName.setEnabled(true);
                    }
                }
            }
        } else if ("directoryChanged".equals(e.getPropertyName())) {
            this.setAccessoryEnablement(false, 0);
        }
    }

    private static boolean isProjectDir(File dir) {
        FileObject fo;
        boolean retVal = false;
        if (dir != null && (fo = ProjectChooserAccessory.convertToValidDir(dir)) != null) {
            retVal = Utilities.isUnix() && fo.getParent() != null && fo.getParent().getParent() == null ? false : ProjectManager.getDefault().isProject(fo);
        }
        return retVal;
    }

    private static FileObject convertToValidDir(File f) {
        File testFile = new File(f.getPath());
        if (testFile == null || testFile.getParent() == null) {
            return null;
        }
        if (!testFile.isDirectory()) {
            return null;
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        return fo;
    }

    private static Project getProject(File dir) {
        return OpenProjectList.fileToProject(dir);
    }

    private void setAccessoryEnablement(boolean enable, int numberOfProjects) {
        this.jLabelProjectName.setEnabled(enable);
        this.jTextFieldProjectName.setEnabled(enable);
        this.jTextFieldProjectName.setForeground(null);
        this.jCheckBoxSubprojects.setEnabled(enable);
        this.jScrollPaneSubprojects.setEnabled(enable);
        if (numberOfProjects <= 1) {
            if (this.tempSetAsMain != null) {
                this.jCheckBoxMain.setSelected(this.tempSetAsMain);
                this.tempSetAsMain = null;
            }
            this.jCheckBoxMain.setEnabled(enable);
        } else if (this.tempSetAsMain == null) {
            this.tempSetAsMain = new Boolean(this.jCheckBoxMain.isSelected());
            this.jCheckBoxMain.setSelected(false);
            this.jCheckBoxMain.setEnabled(false);
        }
    }

    static void addSubprojects(Project p, List result, Map cache) {
        Set subprojects = (Set)cache.get(p);
        if (subprojects == null) {
            SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
            subprojects = spp != null ? spp.getSubprojects() : Collections.EMPTY_SET;
            cache.put(p, subprojects);
        }
        Iterator it = subprojects.iterator();
        while (it.hasNext()) {
            Project sp = (Project)it.next();
            if (result.contains(sp)) continue;
            result.add(sp);
            ProjectChooserAccessory.addSubprojects(sp, result, cache);
        }
    }

    private static String relativizePath(File f1, File f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        if (!CollocationQuery.areCollocated((File)f1, (File)f2)) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        File base = f1;
        String filepath = f2.getAbsolutePath();
        while (!filepath.startsWith(ProjectChooserAccessory.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            b.append("../");
        }
        URI u = base.toURI().relativize(f2.toURI());
        if (!$assertionsDisabled && u.isAbsolute()) {
            throw new AssertionError((Object)(u + " from " + f1 + " and " + f2 + " with common root " + base));
        }
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }

    public static JFileChooser createProjectChooser(boolean defaultAccessory) {
        File d;
        ProjectManager.getDefault().clearNonProjectCache();
        OpenProjectListSettings opls = OpenProjectListSettings.getInstance();
        ProjectFileChooser chooser = new ProjectFileChooser();
        chooser.setFileSelectionMode(1);
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            chooser.putClientProperty("GTKFileChooser.showDirectoryIcons", Boolean.TRUE);
        }
        chooser.setApproveButtonText(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonText"));
        chooser.setApproveButtonMnemonic(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"MNM_PrjChooser_ApproveButtonText").charAt(0));
        chooser.setApproveButtonToolTipText(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonTooltipText"));
        chooser.setDialogTitle(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Title"));
        chooser.setFileFilter(ProjectDirFilter.INSTANCE);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"AN_ProjectChooserAccessory"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectChooserAccessory.class, (String)"AD_ProjectChooserAccessory"));
        if (defaultAccessory) {
            chooser.setAccessory(new ProjectChooserAccessory(chooser, opls.isOpenSubprojects(), opls.isOpenAsMain()));
        }
        File currDir = null;
        String dir = opls.getLastOpenProjectDir();
        if (dir != null && (d = new File(dir)).exists() && d.isDirectory()) {
            currDir = d;
        }
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, currDir);
        chooser.setFileView(new ProjectFileView(chooser.getFileSystemView()));
        return chooser;
    }

    public void removeNotify() {
        super.removeNotify();
        this.modelUpdater = null;
        this.subprojectsCache = null;
        this.updateSubprojectsTask = null;
    }

    static {
        $assertionsDisabled = !ProjectChooserAccessory.class.desiredAssertionStatus();
    }

    private class ModelUpdater
    implements Runnable {
        volatile List projects;
        private DefaultListModel subprojectsToSet;

        private ModelUpdater() {
        }

        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                List currentProjects = this.projects;
                if (currentProjects == null) {
                    return;
                }
                if (ProjectChooserAccessory.this.subprojectsCache == null) {
                    return;
                }
                ProjectChooserAccessory.this.jListSubprojects.setListData(new String[]{NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$ProjectChooserAccessory == null ? (class$org$netbeans$modules$project$ui$ProjectChooserAccessory = ProjectChooserAccessory.class$("org.netbeans.modules.project.ui.ProjectChooserAccessory")) : class$org$netbeans$modules$project$ui$ProjectChooserAccessory), (String)"MSG_PrjChooser_WaitMessage")});
                ArrayList<String> subprojects = new ArrayList<String>(currentProjects.size() * 5);
                Iterator it = currentProjects.iterator();
                while (it.hasNext()) {
                    ProjectChooserAccessory.addSubprojects((Project)it.next(), subprojects, ProjectChooserAccessory.this.subprojectsCache);
                }
                if (!subprojects.isEmpty()) {
                    String pattern = NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$ProjectChooserAccessory == null ? (class$org$netbeans$modules$project$ui$ProjectChooserAccessory = ProjectChooserAccessory.class$("org.netbeans.modules.project.ui.ProjectChooserAccessory")) : class$org$netbeans$modules$project$ui$ProjectChooserAccessory), (String)"LBL_PrjChooser_SubprojectName_Format");
                    File pDir = currentProjects.size() == 1 ? FileUtil.toFile((FileObject)((Project)currentProjects.get(0)).getProjectDirectory()) : null;
                    for (int i = 0; i < subprojects.size(); ++i) {
                        Project p = (Project)subprojects.get(i);
                        FileObject spDir = p.getProjectDirectory();
                        String relPath = null;
                        if (pDir != null) {
                            relPath = ProjectChooserAccessory.relativizePath(pDir, FileUtil.toFile((FileObject)spDir));
                        }
                        if (relPath == null) {
                            relPath = FileUtil.getFileDisplayName((FileObject)spDir);
                        }
                        String displayName = MessageFormat.format(pattern, ProjectUtils.getInformation((Project)p).getDisplayName(), relPath);
                        subprojects.set(i, displayName);
                    }
                    Collections.sort(subprojects, Collator.getInstance());
                }
                if (currentProjects != this.projects) {
                    return;
                }
                DefaultListModel listModel = new DefaultListModel();
                Iterator it2 = subprojects.iterator();
                while (it2.hasNext()) {
                    listModel.addElement(it2.next());
                }
                this.subprojectsToSet = listModel;
                SwingUtilities.invokeLater(this);
                return;
            }
            if (this.projects == null) {
                ListModel spListModel = ProjectChooserAccessory.this.jListSubprojects.getModel();
                if (spListModel instanceof DefaultListModel) {
                    ((DefaultListModel)spListModel).clear();
                } else {
                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                }
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(false);
            } else {
                ProjectChooserAccessory.this.jListSubprojects.setModel(this.subprojectsToSet);
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(!this.subprojectsToSet.isEmpty());
                this.projects = null;
            }
        }
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon1, Icon icon2, int xMerge, int yMerge) {
            this.icon1 = icon1;
            this.icon2 = icon2;
            if (xMerge == -1) {
                xMerge = icon1.getIconWidth() - icon2.getIconWidth();
            }
            if (yMerge == -1) {
                yMerge = icon1.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = xMerge;
            this.yMerge = yMerge;
        }

        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon1.paintIcon(c, g, x, y);
            this.icon2.paintIcon(c, g, x + this.xMerge, y + this.yMerge);
        }
    }

    private static class ProjectFileView
    extends FileView {
        private static final Icon BADGE = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectBadge.gif"));
        private static final Icon EMPTY = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/empty.gif"));
        private FileSystemView fsv;
        private Icon lastOriginal;
        private Icon lastMerged;

        public ProjectFileView(FileSystemView fsv) {
            this.fsv = fsv;
        }

        public Icon getIcon(File _f) {
            if (!_f.exists()) {
                return null;
            }
            File f = FileUtil.normalizeFile((File)_f);
            Icon original = this.fsv.getSystemIcon(f);
            if (original == null) {
                original = EMPTY;
            }
            if (ProjectChooserAccessory.isProjectDir(f)) {
                if (original.equals(this.lastOriginal)) {
                    return this.lastMerged;
                }
                this.lastOriginal = original;
                this.lastMerged = new MergedIcon(original, BADGE, -1, -1);
                return this.lastMerged;
            }
            return original;
        }
    }

    private static class ProjectDirFilter
    extends FileFilter {
        private static final FileFilter INSTANCE = new ProjectDirFilter();

        private ProjectDirFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$ProjectChooserAccessory$ProjectDirFilter == null ? (class$org$netbeans$modules$project$ui$ProjectChooserAccessory$ProjectDirFilter = ProjectChooserAccessory.class$("org.netbeans.modules.project.ui.ProjectChooserAccessory$ProjectDirFilter")) : class$org$netbeans$modules$project$ui$ProjectChooserAccessory$ProjectDirFilter), (String)"LBL_PrjChooser_ProjectDirectoryFilter_Name");
        }
    }

    private static class ProjectFileChooser
    extends JFileChooser {
        private ProjectFileChooser() {
        }

        public void approveSelection() {
            File dir = FileUtil.normalizeFile((File)this.getSelectedFile());
            if (ProjectChooserAccessory.isProjectDir(dir) && ProjectChooserAccessory.getProject(dir) != null) {
                super.approveSelection();
            } else {
                this.setCurrentDirectory(dir);
            }
        }
    }
}

