/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.ui.ClasspathPanel;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class OutputPanel
extends JPanel
implements HelpCtx.Provider {
    private DefaultListModel listModel;
    private File lastChosenFile = null;
    private boolean isSeparateClasspath = true;
    private List compUnitsKeys;
    private boolean ignoreEvent;
    private ProjectModel model;
    private JButton addOutput;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField javadoc;
    private JButton javadocBrowse;
    private JLabel javadocLabel;
    private JList output;
    private JButton removeOutput;
    private JComboBox sourceFolder;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$modules$java$freeform$ui$ClasspathPanel;

    public OutputPanel() {
        this.initComponents();
        this.jTextArea1.setBackground(this.getBackground());
        this.listModel = new DefaultListModel();
        this.output.setModel(this.listModel);
        this.output.setSelectionMode(0);
        this.javadoc.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                OutputPanel.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                OutputPanel.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                OutputPanel.this.update();
            }
        });
        this.jTextArea1.setDisabledTextColor(this.jLabel2.getForeground());
    }

    private void update() {
        int index = this.sourceFolder.getSelectedIndex();
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        ProjectModel.CompilationUnitKey key = (ProjectModel.CompilationUnitKey)this.compUnitsKeys.get(index);
        JavaProjectGenerator.JavaCompilationUnit cu = this.model.getCompilationUnit(key, this.model.isTestSourceFolder(index));
        this.updateCompilationUnitJavadoc(cu);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OutputPanel.class);
    }

    private void updateControls() {
        this.sourceFolder.removeAllItems();
        this.compUnitsKeys = this.model.createCompilationUnitKeys();
        this.isSeparateClasspath = !ProjectModel.isSingleCompilationUnit(this.compUnitsKeys);
        List names = ClasspathPanel.createComboContent(this.compUnitsKeys, this.model.getEvaluator(), this.model.getNBProjectFolder());
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String nm = (String)it.next();
            this.sourceFolder.addItem(nm);
        }
        if (names.size() > 0) {
            this.ignoreEvent = true;
            this.sourceFolder.setSelectedIndex(0);
            this.ignoreEvent = false;
        }
        this.loadOutput();
        boolean sepClasspath = this.model.canHaveSeparateClasspath();
        this.jLabel2.setEnabled(sepClasspath && this.isSeparateClasspath);
        this.sourceFolder.setEnabled(sepClasspath && this.isSeparateClasspath);
        this.addOutput.setEnabled(this.compUnitsKeys.size() > 0);
        this.output.setEnabled(this.compUnitsKeys.size() > 0);
        this.javadoc.setEnabled(this.compUnitsKeys.size() > 0);
        this.javadocBrowse.setEnabled(this.compUnitsKeys.size() > 0);
        this.updateButtons();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.addOutput = new JButton();
        this.removeOutput = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.output = new JList();
        this.jPanel1 = new JPanel();
        this.sourceFolder = new JComboBox();
        this.jTextArea1 = new JTextArea();
        this.jPanel2 = new JPanel();
        this.javadoc = new JTextField();
        this.javadocBrowse = new JButton();
        this.javadocLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(275, 202));
        this.jLabel2.setLabelFor(this.sourceFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)OutputPanel.class, (String)"LBL_OutputPanel_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setLabelFor(this.output);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)OutputPanel.class, (String)"LBL_OutputPanel_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)OutputPanel.class, (String)"ACSD_OutputPanel_jLabel3"));
        Mnemonics.setLocalizedText((AbstractButton)this.addOutput, (String)NbBundle.getMessage((Class)OutputPanel.class, (String)"BTN_OutputPanel_addOutput"));
        this.addOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OutputPanel.this.addOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.addOutput, gridBagConstraints);
        this.addOutput.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)OutputPanel.class, (String)"ACSD_OutputPanel_addOutput"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeOutput, (String)NbBundle.getMessage((Class)OutputPanel.class, (String)"BTN_OutputPanel_removeOutput"));
        this.removeOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OutputPanel.this.removeOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.removeOutput, gridBagConstraints);
        this.removeOutput.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)OutputPanel.class, (String)"ACSD_OutputPanel_removeOutput"));
        this.output.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                OutputPanel.this.outputValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.output);
        this.output.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)OutputPanel.class, (String)"ACSD_OutputPanel_output"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)OutputPanel.class, (String)"ACSD_OutputPanel_jScrollPanel1"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.sourceFolder.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OutputPanel.this.sourceFolderItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.sourceFolder, gridBagConstraints);
        this.sourceFolder.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_OutputPanel_sourceFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage((Class)OutputPanel.class, (String)"MSG_OutputPanel_jTextArea1"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)OutputPanel.class, (String)"ACSN_OutputPanel_jTextArea1"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)OutputPanel.class, (String)"ACSD_OutputPanel_jTextArea1"));
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel2.add((Component)this.javadoc, gridBagConstraints);
        this.javadoc.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_OutputPanel_javadoc"));
        Mnemonics.setLocalizedText((AbstractButton)this.javadocBrowse, (String)NbBundle.getMessage((Class)OutputPanel.class, (String)"BTN_OutputPanel_browseJavadoc"));
        this.javadocBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OutputPanel.this.javadocBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.javadocBrowse, gridBagConstraints);
        this.javadocBrowse.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_OutputPanel_javadocBrowse"));
        this.javadocLabel.setLabelFor(this.javadoc);
        Mnemonics.setLocalizedText((JLabel)this.javadocLabel, (String)NbBundle.getMessage((Class)OutputPanel.class, (String)"LBL_OutputPanel_JavadocLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel2.add((Component)this.javadocLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void javadocBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(false);
        if (this.lastChosenFile != null) {
            chooser.setSelectedFile(this.lastChosenFile);
        } else if (this.javadoc.getText().length() > 0) {
            chooser.setSelectedFile(new File(this.javadoc.getText()));
        } else {
            File[] files = this.model.getBaseFolder().listFiles();
            if (files != null && files.length > 0) {
                chooser.setSelectedFile(files[0]);
            } else {
                chooser.setSelectedFile(this.model.getBaseFolder());
            }
        }
        chooser.setDialogTitle(NbBundle.getMessage((Class)OutputPanel.class, (String)"LBL_Browse_Javadoc"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = chooser.getSelectedFile();
            file = FileUtil.normalizeFile((File)file);
            this.javadoc.setText(file.getAbsolutePath());
            this.lastChosenFile = file;
        }
    }

    private void outputValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void sourceFolderItemStateChanged(ItemEvent evt) {
        if (this.ignoreEvent) {
            return;
        }
        if (evt.getStateChange() == 2) {
            int index = this.findIndex(evt.getItem());
            if (index != -1) {
                this.saveOutput(index);
            }
        } else {
            this.loadOutput();
        }
    }

    private int findIndex(Object o) {
        for (int i = 0; i < this.sourceFolder.getModel().getSize(); ++i) {
            if (!this.sourceFolder.getModel().getElementAt(i).equals(o)) continue;
            return i;
        }
        return -1;
    }

    private void saveOutput(int index) {
        ProjectModel.CompilationUnitKey key = (ProjectModel.CompilationUnitKey)this.compUnitsKeys.get(index);
        JavaProjectGenerator.JavaCompilationUnit cu = this.model.getCompilationUnit(key, this.model.isTestSourceFolder(index));
        this.updateCompilationUnitOutput(cu);
        this.updateCompilationUnitJavadoc(cu);
    }

    private void loadOutput() {
        int index;
        if (this.isSeparateClasspath) {
            index = this.sourceFolder.getSelectedIndex();
            if (index == -1) {
                return;
            }
        } else {
            index = 0;
        }
        ProjectModel.CompilationUnitKey key = (ProjectModel.CompilationUnitKey)this.compUnitsKeys.get(index);
        JavaProjectGenerator.JavaCompilationUnit cu = this.model.getCompilationUnit(key, this.model.isTestSourceFolder(index));
        this.updateJListOutput(cu.output);
        this.updateJavadocField(cu.javadoc);
    }

    private void updateJavadocField(List jd) {
        String value = "";
        boolean enabled = true;
        if (jd != null) {
            File f;
            if (jd.size() > 1) {
                value = this.getListAsString(jd);
                enabled = false;
            } else if (jd.size() == 1 && (f = Util.resolveFile((PropertyEvaluator)this.model.getEvaluator(), (File)this.model.getNBProjectFolder(), (String)((String)jd.get(0)))) != null) {
                value = f.getAbsolutePath();
            }
        }
        this.javadoc.setEnabled(enabled);
        this.javadocBrowse.setEnabled(enabled);
        this.javadoc.setText(value);
    }

    private String getListAsString(List list) {
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            File f = Util.resolveFile((PropertyEvaluator)this.model.getEvaluator(), (File)this.model.getNBProjectFolder(), (String)((String)it.next()));
            if (f == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(f.getAbsolutePath());
        }
        return sb.toString();
    }

    private void updateCompilationUnitJavadoc(JavaProjectGenerator.JavaCompilationUnit cu) {
        if (this.javadoc.isEnabled()) {
            if (this.javadoc.getText().length() > 0) {
                cu.javadoc = new ArrayList();
                String[] parts = this.javadoc.getText().split(",");
                for (int i = 0; i < parts.length; ++i) {
                    File f = FileUtil.normalizeFile((File)new File(parts[i].trim()));
                    String path = Util.relativizeLocation((File)this.model.getBaseFolder(), (File)this.model.getNBProjectFolder(), (File)f);
                    cu.javadoc.add(path);
                }
            } else {
                cu.javadoc = null;
            }
        }
    }

    private void updateCompilationUnitOutput(JavaProjectGenerator.JavaCompilationUnit cu) {
        if (this.output.getModel().getSize() == 0) {
            cu.output = null;
            return;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this.output.getModel().getSize(); ++i) {
            File f = new File((String)this.output.getModel().getElementAt(i));
            String path = Util.relativizeLocation((File)this.model.getBaseFolder(), (File)this.model.getNBProjectFolder(), (File)f);
            l.add(path);
        }
        cu.output = l;
    }

    private void updateJListOutput(List l) {
        this.listModel.removeAllElements();
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                String out = (String)it.next();
                File f = Util.resolveFile((PropertyEvaluator)this.model.getEvaluator(), (File)this.model.getNBProjectFolder(), (String)out);
                if (f == null) continue;
                this.listModel.addElement(f.getAbsolutePath());
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.removeOutput.setEnabled(this.output.isEnabled() && this.listModel.getSize() > 0 && this.output.getSelectedIndex() != -1);
    }

    private void removeOutputActionPerformed(ActionEvent evt) {
        int i = this.output.getSelectedIndex();
        if (i != -1) {
            this.listModel.remove(i);
        }
        this.applyChanges();
        this.updateButtons();
    }

    private void addOutputActionPerformed(ActionEvent evt) {
        File[] files;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        if (this.lastChosenFile != null) {
            chooser.setSelectedFile(this.lastChosenFile);
        } else {
            files = this.model.getBaseFolder().listFiles();
            if (files != null && files.length > 0) {
                chooser.setSelectedFile(files[0]);
            } else {
                chooser.setSelectedFile(this.model.getBaseFolder());
            }
        }
        chooser.setDialogTitle(NbBundle.getMessage((Class)OutputPanel.class, (String)"LBL_Browse_Output"));
        if (0 == chooser.showOpenDialog(this)) {
            files = chooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = FileUtil.normalizeFile((File)files[i]);
                this.listModel.addElement(file.getAbsolutePath());
                this.lastChosenFile = file;
            }
            this.applyChanges();
            this.updateButtons();
        }
    }

    private void applyChanges() {
        if (this.isSeparateClasspath) {
            if (this.sourceFolder.getSelectedIndex() != -1) {
                this.saveOutput(this.sourceFolder.getSelectedIndex());
            }
        } else {
            this.saveOutput(0);
        }
    }

    private void setModel(ProjectModel model) {
        this.model = model;
        this.updateControls();
    }

    static {
        $assertionsDisabled = !OutputPanel.class.desiredAssertionStatus();
    }

    public static class Panel
    implements ProjectPropertiesPanel,
    ChangeListener {
        private OutputPanel panel;
        private ProjectModel model;

        public Panel(ProjectModel model) {
            this.model = model;
        }

        public void storeValues() {
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$ClasspathPanel == null ? (class$org$netbeans$modules$java$freeform$ui$ClasspathPanel = OutputPanel.class$("org.netbeans.modules.java.freeform.ui.ClasspathPanel")) : class$org$netbeans$modules$java$freeform$ui$ClasspathPanel), (String)"LBL_ProjectCustomizer_Category_Output");
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = new OutputPanel();
                this.panel.setModel(this.model);
                this.model.addChangeListener(this);
            }
            return this.panel;
        }

        public void stateChanged(ChangeEvent e) {
            this.panel.updateControls();
        }

        public int getPreferredPosition() {
            return 300;
        }
    }
}

