/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.w3c.dom.Element;

final class SourceLevelQueryImpl
implements SourceLevelQueryImplementation,
AntProjectListener {
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private AuxiliaryConfiguration aux;
    private final Map sourceLevels = new WeakHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public SourceLevelQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
        this.helper.addAntProjectListener((AntProjectListener)this);
    }

    public String getSourceLevel(final FileObject file) {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                return SourceLevelQueryImpl.this.getSourceLevelImpl(file);
            }
        });
    }

    private synchronized String getSourceLevelImpl(FileObject file) {
        Iterator it = this.sourceLevels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FileObject root = (FileObject)entry.getKey();
            if (root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return (String)entry.getValue();
        }
        Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (java == null) {
            return null;
        }
        List compilationUnits = Util.findSubElements((Element)java);
        it = compilationUnits.iterator();
        while (it.hasNext()) {
            Element compilationUnitEl = (Element)((Object)it.next());
            if (!$assertionsDisabled && !compilationUnitEl.getLocalName().equals("compilation-unit")) {
                throw new AssertionError(compilationUnitEl);
            }
            List packageRoots = Classpaths.findPackageRoots(this.helper, this.evaluator, compilationUnitEl);
            Iterator it2 = packageRoots.iterator();
            while (it2.hasNext()) {
                FileObject root = (FileObject)it2.next();
                if (root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                String lvl = this.getLevel(compilationUnitEl);
                it2 = packageRoots.iterator();
                while (it2.hasNext()) {
                    FileObject root2 = (FileObject)it2.next();
                    this.sourceLevels.put(root2, lvl);
                }
                return lvl;
            }
        }
        return null;
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationXmlChanged(AntProjectEvent ev) {
        SourceLevelQueryImpl sourceLevelQueryImpl = this;
        synchronized (sourceLevelQueryImpl) {
            this.sourceLevels.clear();
        }
    }

    private String getLevel(Element compilationUnitEl) {
        Element sourceLevelEl = Util.findElement((Element)compilationUnitEl, (String)"source-level", (String)"http://www.netbeans.org/ns/freeform-project-java/2");
        if (sourceLevelEl != null) {
            return Util.findText((Element)sourceLevelEl);
        }
        return null;
    }

    static {
        $assertionsDisabled = !SourceLevelQueryImpl.class.desiredAssertionStatus();
    }
}

