/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.method;

import java.util.Arrays;
import java.util.Collections;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.predicates.clazz.AnnotatedAsIdClassPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsIdPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.method.GetterPred;

public class CorrespondingGetterMappedAsIdInEntity
extends AbstractRule {
    public CorrespondingGetterMappedAsIdInEntity() {
        super(null, Arrays.asList(new GetterPred()));
    }

    public String getId() {
        return "CorrespondingGetterMappedAsIdInEntity";
    }

    protected String getMessageKey() {
        return "MSG_GetterNotMappedAsId";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) && ctx.getBeanAccessType() == BeanAccessType.PROPERTY && new AnnotatedAsIdClassPred().evaluate((Object)ctx.getMainJavaClass()) && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            Method method = (Method)Method.class.cast(subject);
            JavaClass javaClass = ctx.getMainJavaClass();
            JavaClass idClass = PersistenceAPIHelper.getIdClass(javaClass);
            if (idClass == null) {
                return null;
            }
            Method idMethod = idClass.getMethod(method.getName(), Collections.emptyList(), false);
            if (idMethod != null && !new AnnotatedAsIdPred().evaluate(method)) {
                return this.createProblem(ctx, subject);
            }
        }
        return null;
    }
}

