/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassExpression;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.IdClass;
import org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.filesystems.FileObject;

public class PersistenceAPIHelper {
    private static final Set fieldOrPropertyJSR220Annotations = new TreeSet<String>(Arrays.asList("javax.persistence.JoinColumn", "javax.persistence.JoinColumns", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", "javax.persistence.EmbeddedId", "javax.persistence.Transient", "javax.persistence.Version", "javax.persistence.Basic", "javax.persistence.Lob", "javax.persistence.ManyToOne", "javax.persistence.OneToOne", "javax.persistence.OneToMany", "javax.persistence.JoinTable", "javax.persistence.ManyToMany", "javax.persistence.MapKey", "javax.persistence.OrderBy", "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.Embedded", "javax.persistence.SequenceGenerator", "javax.persistence.TableGenerator", "javax.persistence.Column", "javax.persistence.Id", "javax.persistence.Temporal", "javax.persistence.Enumerated", "javax.persistence.GeneratedValue"));
    private static Collection<String> integralTypes = new TreeSet<String>(Arrays.asList("java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "byte", "char", "short", "int", "long"));
    private static Collection<String> fixedBasicTypes = new TreeSet<String>(Arrays.asList("java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "byte", "char", "short", "int", "long", "float", "double", "java.lang.Float", "java.lang.Double", "java.util.Date", "java.util.Calendar", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "byte[]", "java.lang.Byte[]", "char[]", "java.lang.Character[]"));
    public static final Set entityClassAnnotations = new TreeSet<String>(Arrays.asList("javax.persistence.IdClass", "javax.persistence.SequenceGenerator", "javax.persistence.TableGenerator", "javax.persistence.Inheritance", "javax.persistence.DiscriminatorColumn", "javax.persistence.DiscriminatorValue", "javax.persistence.Table", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables", "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides"));

    public static boolean isJSR220FieldOrPropertyAccessAnnotation(Annotation a) {
        AnnotationType type = a.getType();
        if (type == null) {
            return false;
        }
        return fieldOrPropertyJSR220Annotations.contains(type.getName());
    }

    public static BeanAccessType findBeanAccessType(JavaClass javaClass) {
        BeanAccessType accessType = BeanAccessType.UNDEFINED;
        if (javaClass.getName().equals("java.lang.Object")) {
            return accessType;
        }
        Element[] classElements = javaClass.getContents().toArray(new Element[0]);
        for (int i = 0; i < classElements.length; ++i) {
            AnnotableElement element;
            Annotation a;
            if (!(classElements[i] instanceof Method) && !(classElements[i] instanceof Field) || (a = ProblemFindingUtils.findFirstAnnotationFromGivenSet(element = (AnnotableElement)classElements[i], fieldOrPropertyJSR220Annotations)) == null) continue;
            boolean fieldAccess = element instanceof Field;
            if (accessType == BeanAccessType.UNDEFINED) {
                accessType = fieldAccess ? BeanAccessType.FIELD : BeanAccessType.PROPERTY;
                continue;
            }
            if ((accessType != BeanAccessType.FIELD || fieldAccess) && (accessType != BeanAccessType.PROPERTY || !fieldAccess)) continue;
            accessType = BeanAccessType.INCONSISTENT;
            break;
        }
        JEEVerificationAnnotationProvider.tmpDbg(javaClass.getName() + " has " + (Object)((Object)accessType) + " access type.");
        return accessType;
    }

    public static JavaClass findPersistenceRootClass(JavaClass javaClass) {
        JavaClass persistenceRoot = null;
        for (JavaClass nextClass = javaClass; nextClass != null; nextClass = nextClass.getSuperClass()) {
            if (!PersistenceAPIHelper.isEntity(nextClass) && !PersistenceAPIHelper.isMappedSuperclass(nextClass)) continue;
            persistenceRoot = nextClass;
        }
        JEEVerificationAnnotationProvider.tmpDbg("Persistence root for " + javaClass.getName() + " is " + persistenceRoot.getName());
        return persistenceRoot;
    }

    public static JavaClass findEntityRootClass(JavaClass javaClass) {
        JavaClass entityRoot = null;
        for (JavaClass nextClass = javaClass; nextClass != null; nextClass = nextClass.getSuperClass()) {
            if (!PersistenceAPIHelper.isEntity(nextClass)) continue;
            entityRoot = nextClass;
        }
        JEEVerificationAnnotationProvider.tmpDbg("Entity root for " + javaClass.getName() + " is " + (entityRoot == null ? null : entityRoot.getName()));
        return entityRoot;
    }

    private static ClassMember findFirstIdTypeMember(JavaClass javaClass) {
        TreeSet<String> idAnnotations = new TreeSet<String>(Arrays.asList("javax.persistence.Id", "javax.persistence.EmbeddedId"));
        for (ClassMember cm : javaClass.getContents()) {
            if (!(cm instanceof Field) && !(cm instanceof Method) || ProblemFindingUtils.findFirstAnnotationFromGivenSet((AnnotableElement)cm, idAnnotations) == null) continue;
            return cm;
        }
        return null;
    }

    public static BeanAccessType findAccessTypeOfHierarchy(JavaClass javaClass) {
        BeanAccessType beanAccessTypeOfHierarchy = BeanAccessType.UNDEFINED;
        if (javaClass.getName().equals("java.lang.Object")) {
            ClassMember firstIdTypeMember = PersistenceAPIHelper.findFirstIdTypeMember(javaClass);
            beanAccessTypeOfHierarchy = firstIdTypeMember == null ? BeanAccessType.UNDEFINED : (firstIdTypeMember instanceof Field ? BeanAccessType.FIELD : BeanAccessType.PROPERTY);
        } else {
            JavaClass startingPoint = PersistenceAPIHelper.findEntityRootClass(javaClass);
            if (startingPoint == null) {
                startingPoint = javaClass;
            }
            JavaClass nextClass = startingPoint;
            while (!nextClass.getName().equals("java.lang.Object")) {
                ClassMember firstIdTypeMemberInSuperClass = PersistenceAPIHelper.findFirstIdTypeMember(nextClass);
                if (firstIdTypeMemberInSuperClass != null) {
                    beanAccessTypeOfHierarchy = firstIdTypeMemberInSuperClass instanceof Field ? BeanAccessType.FIELD : BeanAccessType.PROPERTY;
                }
                nextClass = nextClass.getSuperClass();
            }
        }
        JEEVerificationAnnotationProvider.tmpDbg("Access type for entity hierarchy for " + javaClass.getName() + " is " + (Object)((Object)beanAccessTypeOfHierarchy));
        return beanAccessTypeOfHierarchy;
    }

    public static BeanAccessType findIdClassAccessType(JavaClass javaClass) {
        EntityMappings mappings = PersistenceUtils.getEntityMappings((FileObject)JavaModel.getFileObject((Resource)javaClass.getResource()));
        BeanAccessType result = BeanAccessType.UNDEFINED;
        if (mappings != null) {
            String idClassName = javaClass.getName();
            for (Entity entity : mappings.getEntity()) {
                IdClass idClassOfEntity = entity.getIdClass();
                if (idClassOfEntity == null || !idClassName.equals(idClassOfEntity.getClass2())) continue;
                String entityAccessType = entity.getAccess();
                if ("FIELD".equals(entityAccessType)) {
                    if (result == BeanAccessType.UNDEFINED) {
                        result = BeanAccessType.FIELD;
                        continue;
                    }
                    if (result != BeanAccessType.PROPERTY) continue;
                    result = BeanAccessType.INCONSISTENT;
                    break;
                }
                if (!"PROPERTY".equals(entityAccessType)) continue;
                if (result == BeanAccessType.UNDEFINED) {
                    result = BeanAccessType.PROPERTY;
                    continue;
                }
                if (result != BeanAccessType.FIELD) continue;
                result = BeanAccessType.INCONSISTENT;
                break;
            }
        }
        JEEVerificationAnnotationProvider.tmpDbg("Id Class " + javaClass.getName() + " has " + (Object)((Object)result) + " access type.");
        return result;
    }

    public static boolean isIdClass(JavaClass javaClass) {
        IdClass idClass;
        FileObject fo = JavaModel.getFileObject((Resource)javaClass.getResource());
        if (fo == null) {
            return false;
        }
        EntityMappings mappings = PersistenceUtils.getEntityMappings((FileObject)fo);
        if (mappings == null) {
            return false;
        }
        String name = javaClass.getName();
        for (Entity entity : mappings.getEntity()) {
            idClass = entity.getIdClass();
            if (idClass == null || !name.equals(idClass.getClass2())) continue;
            return true;
        }
        for (Entity entity : mappings.getMappedSuperclass()) {
            idClass = entity.getIdClass();
            if (idClass == null || !name.equals(idClass.getClass2())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmbeddable(JavaClass javaClass) {
        return ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.persistence.Embeddable") != null;
    }

    public static boolean isMappedSuperclass(JavaClass javaClass) {
        return ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.persistence.MappedSuperclass") != null;
    }

    public static boolean isEntity(JavaClass javaClass) {
        return ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.persistence.Entity") != null;
    }

    public static String getAccessorName(String fieldName) {
        String fieldNameStartingFromUpperCase = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        return "get" + fieldNameStartingFromUpperCase;
    }

    public static String getMutatorName(String fieldName) {
        String fieldNameStartingFromUpperCase = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        return "set" + fieldNameStartingFromUpperCase;
    }

    public static String getFieldNameFromAccessorName(String accessorName) {
        String pref = "get";
        int prefLen = pref.length();
        if (!accessorName.startsWith(pref) || accessorName.length() <= prefLen) {
            return null;
        }
        return Character.toLowerCase(accessorName.charAt(prefLen)) + accessorName.substring(prefLen + 1);
    }

    public static String getFieldNameFromMutatorName(String accessorName) {
        String pref = "set";
        int prefLen = pref.length();
        if (!accessorName.startsWith(pref) || accessorName.length() <= prefLen) {
            return null;
        }
        return Character.toLowerCase(accessorName.charAt(prefLen)) + accessorName.substring(prefLen + 1);
    }

    public static Method findFieldMutator(JavaClass javaClass, Field field) {
        List<Type> args = Collections.singletonList(field.getType());
        return javaClass.getMethod(PersistenceAPIHelper.getMutatorName(field.getName()), args, false);
    }

    public static Method findFieldAccessor(JavaClass javaClass, Field field) {
        Method r = javaClass.getMethod(PersistenceAPIHelper.getAccessorName(field.getName()), Collections.EMPTY_LIST, false);
        return r;
    }

    public static Entity getEntity(ClassMember m) {
        EntityMappings mappings;
        if (m != null && (mappings = PersistenceAPIHelper.getEntityMappings(m)) != null) {
            JavaClass javaClass = (JavaClass)m.getDeclaringClass();
            return PersistenceUtils.getEntity((JavaClass)javaClass, (EntityMappings)mappings);
        }
        return null;
    }

    public static EntityMappings getEntityMappings(ClassMember m) {
        ClassDefinition classDef;
        if (m != null && (classDef = m.getDeclaringClass()) instanceof JavaClass) {
            FileObject fo = JavaModel.getFileObject((Resource)((JavaClass)classDef).getResource());
            return fo == null ? null : PersistenceUtils.getEntityMappings((FileObject)fo);
        }
        return null;
    }

    public static boolean isIntegralType(Type type) {
        if (type != null) {
            return integralTypes.contains(type.getName());
        }
        return false;
    }

    public static boolean isFixedBasicType(Type type) {
        if (type != null) {
            return fixedBasicTypes.contains(type.getName());
        }
        return false;
    }

    public static boolean isAnyMemberAnnotatedAsIdOrEmbeddedId(JavaClass javaClass) {
        boolean result = false;
        for (Element classElement : javaClass.getContents()) {
            if (!(classElement instanceof Method) && !(classElement instanceof Field)) continue;
            AnnotableElement element = (AnnotableElement)AnnotableElement.class.cast(classElement);
            Annotation annId = ProblemFindingUtils.findAnnotation(element, "javax.persistence.Id");
            Annotation annEmbdId = ProblemFindingUtils.findAnnotation(element, "javax.persistence.EmbeddedId");
            if (annId == null && annEmbdId == null) continue;
            result = true;
            break;
        }
        return result;
    }

    public static AnnotableElement[] getSimpleIdFields(JavaClass javaClass) {
        ArrayList<AnnotableElement> result = new ArrayList<AnnotableElement>();
        for (Element classElement : javaClass.getContents()) {
            AnnotableElement element;
            if (!(classElement instanceof Method) && !(classElement instanceof Field) || ProblemFindingUtils.findAnnotation(element = (AnnotableElement)AnnotableElement.class.cast(classElement), "javax.persistence.Id") == null) continue;
            result.add(element);
        }
        return result.toArray(new AnnotableElement[result.size()]);
    }

    public static AnnotableElement getEmbeddedId(JavaClass javaClass) {
        for (Element classElement : javaClass.getContents()) {
            AnnotableElement element;
            if (!(classElement instanceof Method) && !(classElement instanceof Field) || ProblemFindingUtils.findAnnotation(element = (AnnotableElement)AnnotableElement.class.cast(classElement), "javax.persistence.Id") == null) continue;
            return element;
        }
        return null;
    }

    public static JavaClass getIdClass(JavaClass javaClass) {
        Annotation annotation = ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.persistence.IdClass");
        if (annotation != null) {
            for (AttributeValue attr : annotation.getAttributeValues()) {
                ClassExpression ce;
                if (attr.getName() != null && !"value".equals(attr.getName())) continue;
                JEEVerificationAnnotationProvider.tmpDbg("value=" + attr.getValue());
                try {
                    ce = (ClassExpression)ClassExpression.class.cast(attr.getValue());
                }
                catch (ClassCastException cce) {
                    return null;
                }
                return (JavaClass)JavaClass.class.cast(ce.getClassName().getType());
            }
        }
        return null;
    }
}

