/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.FLAGS;
import com.sun.mail.imap.protocol.IMAPResponse;
import javax.mail.Flags;

public class MailboxInfo {
    public Flags availableFlags = null;
    public Flags permanentFlags = null;
    public int total = -1;
    public int recent = -1;
    public int first = -1;
    public int uidvalidity = -1;
    public int mode;

    public MailboxInfo(Response[] responseArray) throws ParsingException {
        for (int i = 0; i < responseArray.length; ++i) {
            if (responseArray[i] == null || !(responseArray[i] instanceof IMAPResponse)) continue;
            IMAPResponse iMAPResponse = (IMAPResponse)responseArray[i];
            if (iMAPResponse.keyEquals("EXISTS")) {
                this.total = iMAPResponse.getNumber();
                responseArray[i] = null;
                continue;
            }
            if (iMAPResponse.keyEquals("RECENT")) {
                this.recent = iMAPResponse.getNumber();
                responseArray[i] = null;
                continue;
            }
            if (iMAPResponse.keyEquals("FLAGS")) {
                this.availableFlags = new FLAGS(iMAPResponse);
                responseArray[i] = null;
                continue;
            }
            if (!iMAPResponse.isUnTagged() || !iMAPResponse.isOK()) continue;
            iMAPResponse.skipSpaces();
            if (iMAPResponse.readByte() != 91) {
                iMAPResponse.reset();
                continue;
            }
            boolean bl = true;
            String string = iMAPResponse.readAtom();
            if (string.equalsIgnoreCase("UNSEEN")) {
                this.first = iMAPResponse.readNumber();
            } else if (string.equalsIgnoreCase("UIDVALIDITY")) {
                this.uidvalidity = iMAPResponse.readNumber();
            } else if (string.equalsIgnoreCase("PERMANENTFLAGS")) {
                this.permanentFlags = new FLAGS(iMAPResponse);
            } else if (!string.equalsIgnoreCase("UIDNEXT")) {
                bl = false;
            }
            if (bl) {
                responseArray[i] = null;
                continue;
            }
            iMAPResponse.reset();
        }
        if (this.permanentFlags == null) {
            this.permanentFlags = this.availableFlags != null ? new Flags(this.availableFlags) : new Flags();
        }
    }
}

