/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import java.util.Vector;

public class Rights
implements Cloneable {
    private boolean[] rights = new boolean[128];

    public Rights() {
    }

    public Rights(Rights rights) {
        System.arraycopy(rights.rights, 0, this.rights, 0, this.rights.length);
    }

    public Rights(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.add(Right.getInstance(string.charAt(i)));
        }
    }

    public Rights(Right right) {
        this.rights[right.right] = true;
    }

    public void add(Right right) {
        this.rights[right.right] = true;
    }

    public void add(Rights rights) {
        for (int i = 0; i < rights.rights.length; ++i) {
            if (!rights.rights[i]) continue;
            this.rights[i] = true;
        }
    }

    public void remove(Right right) {
        this.rights[right.right] = false;
    }

    public void remove(Rights rights) {
        for (int i = 0; i < rights.rights.length; ++i) {
            if (!rights.rights[i]) continue;
            this.rights[i] = false;
        }
    }

    public boolean contains(Right right) {
        return this.rights[right.right];
    }

    public boolean contains(Rights rights) {
        for (int i = 0; i < rights.rights.length; ++i) {
            if (!rights.rights[i] || this.rights[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rights)) {
            return false;
        }
        Rights rights = (Rights)object;
        for (int i = 0; i < rights.rights.length; ++i) {
            if (rights.rights[i] == this.rights[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.rights.length; ++i) {
            if (!this.rights[i]) continue;
            ++n;
        }
        return n;
    }

    public Right[] getRights() {
        Vector<Right> vector = new Vector<Right>();
        for (int i = 0; i < this.rights.length; ++i) {
            if (!this.rights[i]) continue;
            vector.addElement(Right.getInstance((char)i));
        }
        Object[] objectArray = new Right[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object clone() {
        return new Rights(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rights.length; ++i) {
            if (!this.rights[i]) continue;
            stringBuffer.append((char)i);
        }
        return stringBuffer.toString();
    }

    public static final class Right {
        private static Right[] cache = new Right[128];
        public static final Right LOOKUP = Right.getInstance('l');
        public static final Right READ = Right.getInstance('r');
        public static final Right KEEP_SEEN = Right.getInstance('s');
        public static final Right WRITE = Right.getInstance('w');
        public static final Right INSERT = Right.getInstance('i');
        public static final Right POST = Right.getInstance('p');
        public static final Right CREATE = Right.getInstance('c');
        public static final Right DELETE = Right.getInstance('d');
        public static final Right ADMINISTER = Right.getInstance('a');
        char right;

        private Right(char c) {
            if (c >= '\u0080') {
                throw new IllegalArgumentException("Right must be ASCII");
            }
            this.right = c;
        }

        public static synchronized Right getInstance(char c) {
            if (c >= '\u0080') {
                throw new IllegalArgumentException("Right must be ASCII");
            }
            if (cache[c] == null) {
                Right.cache[c] = new Right(c);
            }
            return cache[c];
        }

        public String toString() {
            return String.valueOf(this.right);
        }
    }
}

