/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.util.ASCIIUtility;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResponseInputStream
extends BufferedInputStream {
    private static final int increment = 256;
    private byte[] buffer = null;
    private int sz = 0;
    private int idx = 0;

    public ResponseInputStream(InputStream inputStream) {
        super(inputStream, 2048);
    }

    public ByteArray readResponse() throws IOException {
        this.buffer = new byte[128];
        this.idx = 0;
        this.sz = 128;
        this.read0();
        return new ByteArray(this.buffer, 0, this.idx);
    }

    private void read0() throws IOException {
        int n = 0;
        boolean bl = false;
        while (!bl && (n = this.pos >= this.count ? this.read() : this.buf[this.pos++] & 0xFF) != -1) {
            switch (n) {
                case 10: {
                    if (this.idx <= 0 || this.buffer[this.idx - 1] != 13) break;
                    bl = true;
                }
            }
            if (this.idx >= this.sz) {
                this.growBuffer(256);
            }
            this.buffer[this.idx++] = (byte)n;
        }
        if (n == -1) {
            throw new IOException();
        }
        if (this.idx >= 5 && this.buffer[this.idx - 3] == 125) {
            int n2;
            for (n2 = this.idx - 4; n2 >= 0 && this.buffer[n2] != 123; --n2) {
            }
            if (n2 < 0) {
                return;
            }
            int n3 = 0;
            try {
                n3 = ASCIIUtility.parseInt(this.buffer, n2 + 1, this.idx - 3);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (n3 > 0) {
                int n4 = this.sz - this.idx;
                if (n3 > n4) {
                    this.growBuffer(256 > n3 - n4 ? 256 : n3 - n4);
                }
                while (n3 > 0) {
                    int n5 = this.read(this.buffer, this.idx, n3);
                    n3 -= n5;
                    this.idx += n5;
                }
            }
            this.read0();
        }
    }

    private void growBuffer(int n) {
        byte[] byArray = new byte[this.sz + n];
        if (this.buffer != null) {
            System.arraycopy(this.buffer, 0, byArray, 0, this.idx);
        }
        this.buffer = byArray;
        this.sz += n;
    }
}

