/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.file.DefaultTransmitTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.DefaultWriteTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.file.OutputStreamProvider;
import org.netbeans.lib.cvsclient.file.TransmitTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.WriteRcsDiffFilePreprocessor;
import org.netbeans.lib.cvsclient.file.WriteTextFilePreprocessor;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.util.BugLog;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class DefaultFileHandler
implements FileHandler {
    private static final boolean DEBUG = false;
    private static final int CHUNK_SIZE = 32768;
    private Date modifiedDate;
    private TransmitTextFilePreprocessor transmitTextFilePreprocessor;
    private WriteTextFilePreprocessor writeTextFilePreprocessor;
    private WriteTextFilePreprocessor writeRcsDiffFilePreprocessor;
    private GlobalOptions globalOptions;

    public DefaultFileHandler() {
        this.setTransmitTextFilePreprocessor(new DefaultTransmitTextFilePreprocessor());
        this.setWriteTextFilePreprocessor(new DefaultWriteTextFilePreprocessor());
        this.setWriteRcsDiffFilePreprocessor(new WriteRcsDiffFilePreprocessor());
    }

    public TransmitTextFilePreprocessor getTransmitTextFilePreprocessor() {
        return this.transmitTextFilePreprocessor;
    }

    public void setTransmitTextFilePreprocessor(TransmitTextFilePreprocessor transmitTextFilePreprocessor) {
        this.transmitTextFilePreprocessor = transmitTextFilePreprocessor;
    }

    public WriteTextFilePreprocessor getWriteTextFilePreprocessor() {
        return this.writeTextFilePreprocessor;
    }

    public void setWriteTextFilePreprocessor(WriteTextFilePreprocessor writeTextFilePreprocessor) {
        this.writeTextFilePreprocessor = writeTextFilePreprocessor;
    }

    public WriteTextFilePreprocessor getWriteRcsDiffFilePreprocessor() {
        return this.writeRcsDiffFilePreprocessor;
    }

    public void setWriteRcsDiffFilePreprocessor(WriteTextFilePreprocessor writeRcsDiffFilePreprocessor) {
        this.writeRcsDiffFilePreprocessor = writeRcsDiffFilePreprocessor;
    }

    protected String getLengthString(long length) {
        return String.valueOf(length) + "\n";
    }

    protected Reader getProcessedReader(File f) throws IOException {
        return new FileReader(f);
    }

    protected InputStream getProcessedInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    public Request[] getInitialisationRequests() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitTextFile(File file, LoggedDataOutputStream dos) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("File is either null or does not exist. Cannot transmit.");
        }
        File fileToSend = file;
        TransmitTextFilePreprocessor transmitTextFilePreprocessor = this.getTransmitTextFilePreprocessor();
        if (transmitTextFilePreprocessor != null) {
            fileToSend = transmitTextFilePreprocessor.getPreprocessedTextFile(file);
        }
        BufferedInputStream bis = null;
        try {
            int count;
            long length;
            dos.writeBytes(this.getLengthString(length), "US-ASCII");
            bis = new BufferedInputStream(new FileInputStream(fileToSend));
            byte[] chunk = new byte[32768];
            for (length = fileToSend.length(); length > 0L; length -= (long)count) {
                int bytesToRead = length >= 32768L ? 32768 : (int)length;
                count = bis.read(chunk, 0, bytesToRead);
                if (count == -1) {
                    throw new IOException("Unexpected end of stream from " + fileToSend + ".");
                }
                dos.write(chunk, 0, count);
            }
            dos.flush();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {}
            }
            if (transmitTextFilePreprocessor != null) {
                transmitTextFilePreprocessor.cleanup(fileToSend);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitBinaryFile(File file, LoggedDataOutputStream dos) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("File is either null or does not exist. Cannot transmit.");
        }
        BufferedInputStream bis = null;
        try {
            int count;
            long length;
            bis = new BufferedInputStream(new FileInputStream(file));
            dos.writeBytes(this.getLengthString(length), "US-ASCII");
            byte[] chunk = new byte[32768];
            for (length = file.length(); length > 0L; length -= (long)count) {
                int bytesToRead = length >= 32768L ? 32768 : (int)length;
                count = bis.read(chunk, 0, bytesToRead);
                if (count == -1) {
                    throw new IOException("Unexpected end of stream from " + file + ".");
                }
                dos.write(chunk, 0, count);
            }
            dos.flush();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void writeTextFile(String path, String mode, LoggedDataInputStream dis, int length) throws IOException {
        this.writeAndPostProcessTextFile(path, mode, dis, length, this.getWriteTextFilePreprocessor());
    }

    public void writeRcsDiffFile(String path, String mode, LoggedDataInputStream dis, int length) throws IOException {
        this.writeAndPostProcessTextFile(path, mode, dis, length, this.getWriteRcsDiffFilePreprocessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndPostProcessTextFile(String path, String mode, LoggedDataInputStream dis, int length, WriteTextFilePreprocessor processor) throws IOException {
        File file = new File(path);
        boolean readOnly = this.resetReadOnly(file);
        this.createNewFile(file);
        File tempFile = File.createTempFile("cvsCRLF", "tmp");
        try {
            OutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(tempFile));
                byte[] chunk = new byte[32768];
                while (length > 0) {
                    int count = length >= 32768 ? 32768 : length;
                    if ((count = dis.read(chunk, 0, count)) == -1) {
                        throw new IOException("Unexpected end of stream: " + path + "\nMissing " + length + " bytes. Probably network communication failure.\nPlease try again.");
                    }
                    length -= count;
                    os.write(chunk, 0, count);
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ex) {}
                }
            }
            InputStream tempInput = this.getProcessedInputStream(tempFile);
            try {
                processor.copyTextFileToLocation(tempInput, file, new StreamProvider(file));
            }
            finally {
                tempInput.close();
            }
            if (this.modifiedDate != null) {
                file.setLastModified(this.modifiedDate.getTime());
                this.modifiedDate = null;
            }
        }
        finally {
            tempFile.delete();
        }
        if (readOnly) {
            FileUtils.setFileReadOnly(file, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryFile(String path, String mode, LoggedDataInputStream dis, int length) throws IOException {
        File file = new File(path);
        boolean readOnly = this.resetReadOnly(file);
        this.createNewFile(file);
        File cvsDir = new File(file.getParentFile(), "CVS");
        cvsDir.mkdir();
        File tempFile = File.createTempFile("cvsPostConversion", "tmp", cvsDir);
        try {
            int count;
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));
            byte[] chunk = new byte[32768];
            try {
                while (length > 0) {
                    int bytesToRead = length >= 32768 ? 32768 : length;
                    count = dis.read(chunk, 0, bytesToRead);
                    if (count == -1) {
                        throw new IOException("Unexpected end of stream: " + path + "\nMissing " + length + " bytes. Probably network communication failure.\nPlease try again.");
                    }
                    if (count < 0) {
                        break;
                    }
                    length -= count;
                    bos.write(chunk, 0, count);
                }
            }
            finally {
                bos.close();
            }
            BufferedInputStream tempIS = new BufferedInputStream(this.getProcessedInputStream(tempFile));
            bos = new BufferedOutputStream(this.createOutputStream(file));
            try {
                count = tempIS.read(chunk, 0, 32768);
                while (count > 0) {
                    bos.write(chunk, 0, count);
                    count = tempIS.read(chunk, 0, 32768);
                }
            }
            finally {
                bos.close();
                tempIS.close();
            }
            if (this.modifiedDate != null) {
                file.setLastModified(this.modifiedDate.getTime());
                this.modifiedDate = null;
            }
        }
        finally {
            tempFile.delete();
        }
        if (readOnly) {
            FileUtils.setFileReadOnly(file, true);
        }
    }

    protected boolean createNewFile(File file) throws IOException {
        file.getParentFile().mkdirs();
        return file.createNewFile();
    }

    protected OutputStream createOutputStream(File file) throws IOException {
        return new FileOutputStream(file);
    }

    private boolean resetReadOnly(File file) throws IOException {
        boolean readOnly;
        boolean bl = readOnly = this.globalOptions != null && this.globalOptions.isCheckedOutFilesReadOnly();
        if (file.exists() && readOnly) {
            boolean bl2 = readOnly = !file.canWrite();
            if (readOnly) {
                FileUtils.setFileReadOnly(file, false);
            }
        }
        return readOnly;
    }

    public void removeLocalFile(String pathname) throws IOException {
        File fileToDelete = new File(pathname);
        if (fileToDelete.exists() && !fileToDelete.delete()) {
            System.err.println("Could not delete file " + fileToDelete.getAbsolutePath());
        }
    }

    public void renameLocalFile(String pathname, String newName) throws IOException {
        File sourceFile = new File(pathname);
        File destinationFile = new File(sourceFile.getParentFile(), newName);
        sourceFile.renameTo(destinationFile);
    }

    public void setNextFileDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public void setGlobalOptions(GlobalOptions globalOptions) {
        BugLog.getInstance().assertNotNull(globalOptions);
        this.globalOptions = globalOptions;
        this.transmitTextFilePreprocessor.setTempDir(globalOptions.getTempDir());
    }

    private class StreamProvider
    implements OutputStreamProvider {
        private final File file;

        public StreamProvider(File file) {
            this.file = file;
        }

        public OutputStream createOutputStream() throws IOException {
            return DefaultFileHandler.this.createOutputStream(this.file);
        }
    }
}

