/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.ejb;

import com.sun.jdo.api.persistence.mapping.ejb.ConversionHelper;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.modules.persistence.mapping.ejb.DevelopmentNameMapper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;

public class DevelopmentConversionHelper
implements ConversionHelper {
    private static final String COLLECTION = "java.util.Collection";
    private final DevelopmentNameMapper nameMapper;
    private final EjbJar bundleDescriptor;
    private boolean generateFields = true;
    private boolean ensureValidation = true;
    private final HashMap entityMap = new HashMap();
    private final HashMap cmpFieldMap = new HashMap();
    private final HashMap ejbKeyMap = new HashMap();
    private final HashMap relationshipRoleMap = new HashMap();

    public DevelopmentConversionHelper(DevelopmentNameMapper nameMapper, Model model) {
        this.nameMapper = nameMapper;
        this.bundleDescriptor = nameMapper.getBundleDescriptor();
        this.initMaps(model);
    }

    private EjbJar getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    private void initMaps(Model model) {
        EnterpriseBeans allBeans = this.getBundleDescriptor().getEnterpriseBeans();
        Entity[] entityBeans = allBeans.getEntity();
        int count = entityBeans != null ? entityBeans.length : 0;
        DevelopmentNameMapper mapper = this.getNameMapper();
        for (int i = 0; i < count; ++i) {
            Entity ejb = entityBeans[i];
            if (!"Container".equals(ejb.getPersistenceType())) continue;
            String ejbName = ejb.getEjbName();
            this.entityMap.put(ejbName, ejb);
            this.cmpFieldMap.put(ejbName, mapper.getFieldsForEjb(ejbName));
            this.ejbKeyMap.put(ejbName, this.getPKFields(model, ejb));
        }
        this.initRelationshipMap();
    }

    private void initRelationshipMap() {
        Relationships relationships = this.getBundleDescriptor().getSingleRelationships();
        if (relationships != null) {
            EjbRelation[] rels = relationships.getEjbRelation();
            int count = rels != null ? rels.length : 0;
            for (int i = 0; i < count; ++i) {
                EjbRelation relationship = rels[i];
                this.addRole(relationship, relationship.getEjbRelationshipRole());
                this.addRole(relationship, relationship.getEjbRelationshipRole2());
            }
        }
    }

    private void addRole(EjbRelation relationship, EjbRelationshipRole testRole) {
        String ejbName = testRole.getRelationshipRoleSource().getEjbName();
        HashMap<EjbRelation, EjbRelationshipRole> rels = (HashMap<EjbRelation, EjbRelationshipRole>)this.relationshipRoleMap.get(ejbName);
        if (rels == null) {
            rels = new HashMap<EjbRelation, EjbRelationshipRole>();
            this.relationshipRoleMap.put(ejbName, rels);
        }
        rels.put(relationship, testRole);
    }

    private Collection getPKFields(Model model, Entity ejb) {
        String pkeyField = ejb.getPrimkeyField();
        String primaryKeyClass = ejb.getPrimKeyClass();
        HashSet<String> pkeyFields = new HashSet<String>();
        if (!StringHelper.isEmpty(pkeyField)) {
            pkeyFields.add(pkeyField);
        } else if (!primaryKeyClass.equals("java.lang.Object")) {
            Iterator iterator = model.getAllFields(primaryKeyClass).iterator();
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                int m = model.getModifiers(model.getField(primaryKeyClass, fieldName));
                if (Modifier.isStatic(m) || Modifier.isFinal(m)) continue;
                pkeyFields.add(fieldName);
            }
        } else {
            pkeyFields.add(this.getGeneratedPKFieldName());
        }
        return pkeyFields;
    }

    private EjbRelationshipRole getOppositeRoleDescriptor(String ejbName, String cmrFieldName) {
        return this.getRoleDescriptor(ejbName, cmrFieldName, true);
    }

    private EjbRelationshipRole getRoleDescriptor(String ejbName, String cmrFieldName, boolean opposite) {
        HashMap rels = (HashMap)this.relationshipRoleMap.get(ejbName);
        Iterator iterator = rels.keySet().iterator();
        while (iterator.hasNext()) {
            EjbRelation rel = (EjbRelation)iterator.next();
            EjbRelationshipRole role = (EjbRelationshipRole)rels.get(rel);
            EjbRelationshipRole role1 = rel.getEjbRelationshipRole();
            EjbRelationshipRole role2 = rel.getEjbRelationshipRole2();
            CmrField candidateCmr = role.getCmrField();
            if (ejbName.equals(role.getRelationshipRoleSource().getEjbName()) && candidateCmr != null && cmrFieldName.equals(candidateCmr.getCmrFieldName())) {
                return opposite ? (role == role1 ? role2 : role1) : role;
            }
            String ejb1 = role1.getRelationshipRoleSource().getEjbName();
            if (!ejb1.equals(role2.getRelationshipRoleSource().getEjbName()) || !ejbName.equals(ejb1) || (candidateCmr = (role = role == role1 ? role2 : role1).getCmrField()) == null || !cmrFieldName.equals(candidateCmr.getCmrFieldName())) continue;
            return opposite ? (role == role1 ? role2 : role1) : role;
        }
        throw new IllegalArgumentException();
    }

    protected DevelopmentNameMapper getNameMapper() {
        return this.nameMapper;
    }

    public String getMappedClassName(String ejbName) {
        return this.getNameMapper().getPersistenceClassForEjbName(ejbName);
    }

    public boolean hasField(String ejbName, String fieldName) {
        if (!this.generateFields() && this.isGeneratedRelationship(ejbName, fieldName)) {
            return false;
        }
        List fields = (List)this.cmpFieldMap.get(ejbName);
        return fields != null ? fields.contains(fieldName) : false;
    }

    public Object[] getFields(String ejbName) {
        List fields = (List)this.cmpFieldMap.get(ejbName);
        if (fields != null) {
            if (!this.generateFields()) {
                fields.removeAll(this.getGeneratedRelationships(ejbName));
            }
            return fields.toArray();
        }
        return null;
    }

    public boolean isKey(String ejbName, String fieldName, boolean candidate) {
        Collection keyFields = (Collection)this.ejbKeyMap.get(ejbName);
        return keyFields != null ? keyFields.contains(fieldName) : false;
    }

    public String getRelationshipFieldType(String ejbName, String fieldName) {
        if (this.isGeneratedRelationship(ejbName, fieldName)) {
            return COLLECTION;
        }
        EjbRelationshipRole thisRole = this.getRoleDescriptor(ejbName, fieldName, false);
        String returnType = thisRole.getCmrField().getCmrFieldType();
        if (returnType == null || !returnType.equals(COLLECTION)) {
            returnType = this.getNameMapper().getLocalInterfaceForEjbName(this.getRelationshipFieldContent(ejbName, fieldName));
        }
        return returnType;
    }

    public String getMultiplicity(String ejbName, String fieldName) {
        EjbRelationshipRole oppRole = this.getOppositeRoleDescriptor(ejbName, fieldName);
        return oppRole.getMultiplicity();
    }

    public String getRelationshipFieldContent(String ejbName, String fieldName) {
        EjbRelationshipRole oppRole = this.getOppositeRoleDescriptor(ejbName, fieldName);
        return oppRole.getRelationshipRoleSource().getEjbName();
    }

    public String getInverseFieldName(String ejbName, String fieldName) {
        String inverseName;
        EjbRelationshipRole oppRole = this.getOppositeRoleDescriptor(ejbName, fieldName);
        CmrField inverse = oppRole == null ? null : oppRole.getCmrField();
        String string = inverseName = inverse == null ? null : inverse.getCmrFieldName();
        if (this.generateFields() && inverseName == null) {
            inverseName = this.getNameMapper().getGeneratedFieldForEjbField(ejbName, fieldName)[1];
        }
        return inverseName;
    }

    public boolean applyDefaultUnknownPKClassStrategy(String ejbName) {
        return 3 == this.getNameMapper().getKeyClassTypeForEjbName(ejbName);
    }

    public String getGeneratedPKFieldName() {
        return "generatedPKField";
    }

    public String getGeneratedVersionFieldNamePrefix() {
        return "thisVersionFieldWasGeneratedByTheNameMapper";
    }

    public boolean relatedObjectsAreDeleted(String beanName, String fieldName) {
        EjbRelationshipRole oppRole = this.getOppositeRoleDescriptor(beanName, fieldName);
        return oppRole.isCascadeDelete();
    }

    public boolean generateFields() {
        return this.generateFields;
    }

    public void setGenerateFields(boolean flag) {
        this.generateFields = flag;
    }

    public boolean ensureValidation() {
        return this.ensureValidation;
    }

    public void setEnsureValidation(boolean flag) {
        this.ensureValidation = flag;
    }

    public boolean isGeneratedField(String ejbName, String fieldName) {
        return this.getNameMapper().isGeneratedField(ejbName, fieldName);
    }

    public boolean isGeneratedRelationship(String ejbName, String fieldName) {
        return this.getNameMapper().isGeneratedEjbRelationship(ejbName, fieldName);
    }

    public List getGeneratedRelationships(String ejbName) {
        return this.getNameMapper().getGeneratedRelationshipsForEjbName(ejbName);
    }
}

