/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.popupcalendar;

import com.sun.j2ee.blueprints.ui.popupcalendar.SqlUtilDateConverter;
import com.sun.j2ee.blueprints.ui.util.Util;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;

public class PopupCalendarComponent
extends HtmlInputText {
    private static final String LOCALE_STRING = "localeString";
    private static final String DATE_FORMAT_PATTERN = "dateFormatPattern";
    private static final String FIELD_SUFFIX = "_field";
    private static final String ISO_DATE_PATTERN = "yyyy-MM-dd";
    private static final String ISO_DATE_SEPARATOR = "-";
    private static final DecimalFormat DECIMAL_FORMAT4 = new DecimalFormat("0000");
    private static final DecimalFormat DECIMAL_FORMAT2 = new DecimalFormat("00");
    private SimpleDateFormat isoDateFormat;
    private SimpleDateFormat localizedDateFormat;
    private String localizedPrompt;
    private static final Pattern separatorPattern = Pattern.compile("[^a-zA-Z]");
    private int jsFirstDayOfWeek;
    private String localeString = null;
    private boolean fieldsInitialized;
    private PatternInfo patternInfo;
    private String dateFormatPattern = null;
    private String style = null;
    private String styleClass = null;

    public PopupCalendarComponent() {
        this.setRendererType("PopupCalendar");
    }

    public String getFamily() {
        return "PopupCalendar";
    }

    private void ensureDerivedFields() {
        Locale locale;
        if (this.fieldsInitialized) {
            return;
        }
        String localeString = this.getLocaleString();
        if (localeString != null) {
            String[] parts = localeString.split("[-_]", 3);
            switch (parts.length) {
                case 3: {
                    locale = new Locale(parts[0], parts[1], parts[2]);
                    break;
                }
                case 2: {
                    locale = new Locale(parts[0], parts[1]);
                    break;
                }
                default: {
                    locale = new Locale(parts[0]);
                    break;
                }
            }
        } else {
            locale = this.getFacesContext().getViewRoot().getLocale();
        }
        this.initLocaleDependentFields(locale);
        this.fieldsInitialized = true;
    }

    private void initLocaleDependentFields(Locale locale) {
        Matcher mat;
        SimpleDateFormat simpleDateFormat;
        this.isoDateFormat = new SimpleDateFormat(ISO_DATE_PATTERN, locale);
        String pattern = this.getDateFormatPattern();
        if (pattern != null) {
            simpleDateFormat = new SimpleDateFormat(pattern, locale);
        } else {
            DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
            simpleDateFormat = dateFormat instanceof SimpleDateFormat ? (SimpleDateFormat)dateFormat : this.isoDateFormat;
            pattern = simpleDateFormat.toPattern();
        }
        int yearIndex = pattern.indexOf(121);
        int monthIndex = pattern.indexOf(77);
        int dayIndex = pattern.indexOf(100);
        if (yearIndex == -1 || monthIndex == -1 || dayIndex == -1) {
            pattern = ISO_DATE_PATTERN;
            yearIndex = pattern.indexOf(121);
            monthIndex = pattern.indexOf(77);
            dayIndex = pattern.indexOf(100);
        }
        String separator = (mat = separatorPattern.matcher(pattern)).find() ? mat.group() : ISO_DATE_SEPARATOR;
        String localPatternChars = simpleDateFormat.getDateFormatSymbols().getLocalPatternChars();
        char yearChar = localPatternChars.charAt(1);
        String year = String.valueOf(new char[]{yearChar, yearChar, yearChar, yearChar});
        char monthChar = localPatternChars.charAt(2);
        String month = String.valueOf(new char[]{monthChar, monthChar});
        char dayChar = localPatternChars.charAt(3);
        String day = String.valueOf(new char[]{dayChar, dayChar});
        StringBuffer prompt = new StringBuffer();
        StringBuffer newPattern = new StringBuffer();
        if (yearIndex < dayIndex && yearIndex < monthIndex) {
            prompt.append(year);
            prompt.append(separator);
            newPattern.append("yyyy");
            newPattern.append(separator);
        }
        if (dayIndex < monthIndex) {
            prompt.append(day);
            prompt.append(separator);
            prompt.append(month);
            newPattern.append("dd");
            newPattern.append(separator);
            newPattern.append("MM");
        } else {
            prompt.append(month);
            prompt.append(separator);
            prompt.append(day);
            newPattern.append("MM");
            newPattern.append(separator);
            newPattern.append("dd");
        }
        if (yearIndex > dayIndex && yearIndex > monthIndex) {
            prompt.append(separator);
            prompt.append(year);
            newPattern.append(separator);
            newPattern.append("yyyy");
        }
        String newPatternStr = newPattern.toString();
        yearIndex = newPatternStr.indexOf(121);
        monthIndex = newPatternStr.indexOf(77);
        dayIndex = newPatternStr.indexOf(100);
        this.patternInfo = new PatternInfo(yearIndex, monthIndex, dayIndex, separator);
        this.localizedDateFormat = new SimpleDateFormat(newPatternStr, locale);
        this.localizedPrompt = prompt.toString().toLowerCase(locale);
        Calendar cal = Calendar.getInstance(locale);
        this.jsFirstDayOfWeek = cal.getFirstDayOfWeek() - 1;
    }

    String getInputTextValue() {
        String selectedDate = this.getFormattedModelValue();
        if (selectedDate == null) {
            return this.getLocalizedPrompt();
        }
        return selectedDate;
    }

    private String getFormattedModelValue() {
        Date date;
        FacesContext context = FacesContext.getCurrentInstance();
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        String isoDate = null;
        Converter converter = this.getConverter();
        if (converter != null) {
            try {
                isoDate = converter.getAsString(context, (UIComponent)this, value);
            }
            catch (ConverterException e) {
                return null;
            }
        }
        if (value instanceof String) {
            isoDate = (String)value;
        } else {
            converter = new SqlUtilDateConverter();
            try {
                isoDate = converter.getAsString(context, (UIComponent)this, value);
            }
            catch (ConverterException e) {
                return null;
            }
            this.setConverter(converter);
        }
        this.ensureDerivedFields();
        try {
            date = this.isoDateFormat.parse(isoDate);
        }
        catch (ParseException e) {
            return null;
        }
        return this.localizedDateFormat.format(date);
    }

    String getInputTextTooltip() {
        return this.getLocalizedPrompt();
    }

    String getInputTextClientId(FacesContext context) {
        return this.getJavaScriptObjectName(context) + FIELD_SUFFIX;
    }

    String getJavaScriptObjectName(FacesContext context) {
        return this.getClientId(context).replace(':', '_');
    }

    String getJavaScriptForNewInstance(FacesContext context) {
        this.ensureDerivedFields();
        StringBuffer js = new StringBuffer("var " + this.getJavaScriptObjectName(context));
        js.append(" = dojo.widget.createWidget('PopupCalendar', { baseId: '");
        js.append(this.getJavaScriptObjectName(context) + "',\n");
        js.append("calendarParams: { yearIndex: " + this.patternInfo.getYearIndex());
        js.append(", monthIndex: " + this.patternInfo.getMonthIndex());
        js.append(", dayIndex: " + this.patternInfo.getDayIndex());
        js.append(", separator: '" + this.patternInfo.getSeparator() + "',\n");
        js.append("months: ['");
        DateFormatSymbols dfs = this.localizedDateFormat.getDateFormatSymbols();
        String[] months = dfs.getMonths();
        for (int i = 0; i < 11; ++i) {
            js.append(months[i]);
            js.append("', '");
        }
        js.append(months[11]);
        js.append("'],\n");
        js.append("weekdays: ['");
        String[] weekdays = dfs.getShortWeekdays();
        for (int i = 1; i < 7; ++i) {
            js.append(weekdays[i]);
            js.append("', '");
        }
        js.append(weekdays[7]);
        js.append("'],\n");
        js.append("jsFirstWeekday: " + this.jsFirstDayOfWeek + " }});\n");
        return js.toString();
    }

    public void validate(FacesContext context) {
        String monthString;
        String dayString;
        int i;
        String submittedValue = (String)this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        if (Pattern.matches("^" + this.getLocalizedPrompt() + "$", submittedValue)) {
            this.setSubmittedValue("");
            super.validate(context);
            return;
        }
        Pattern pat = Pattern.compile("\\S");
        Matcher matcher = pat.matcher(submittedValue);
        if (!matcher.find()) {
            this.setSubmittedValue("");
            super.validate(context);
            return;
        }
        Pattern pat2 = Pattern.compile("\\d+");
        Matcher matcher2 = pat2.matcher(submittedValue);
        ArrayList<String> numStrings = new ArrayList<String>(3);
        for (i = 0; matcher2.find() && i < 3; ++i) {
            numStrings.add(matcher2.group());
        }
        if (i != 3) {
            this.errorBadFormat(context);
            return;
        }
        this.ensureDerivedFields();
        int dayIndex = this.patternInfo.getDayIndex();
        int monthIndex = this.patternInfo.getMonthIndex();
        int yearIndex = this.patternInfo.getYearIndex();
        String yearString = yearIndex < dayIndex && yearIndex < monthIndex ? (String)numStrings.remove(0) : (String)numStrings.remove(2);
        StringBuffer isoString = new StringBuffer();
        int year = Integer.parseInt(yearString);
        isoString.append(this.zeroPad(year, 4));
        isoString.append(ISO_DATE_SEPARATOR);
        if (dayIndex < monthIndex) {
            dayString = (String)numStrings.get(0);
            monthString = (String)numStrings.get(1);
        } else {
            monthString = (String)numStrings.get(0);
            dayString = (String)numStrings.get(1);
        }
        int month = Integer.parseInt(monthString);
        int day = Integer.parseInt(dayString);
        isoString.append(this.zeroPad(month, 2));
        isoString.append(ISO_DATE_SEPARATOR);
        isoString.append(this.zeroPad(day, 2));
        this.setSubmittedValue(isoString.toString());
        super.validate(context);
    }

    protected Object getConvertedValue(FacesContext context, Object isoValue) throws ConverterException {
        if (isoValue instanceof String) {
            Converter converter = this.getConverterWithType(context);
            if (converter != null) {
                return converter.getAsObject(context, (UIComponent)this, (String)isoValue);
            }
            if ("".equals(isoValue)) {
                return null;
            }
        }
        return isoValue;
    }

    private Converter getConverterWithType(FacesContext context) {
        Class type;
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null && Date.class.isAssignableFrom(type = vb.getType(context))) {
            converter = new SqlUtilDateConverter();
            this.setConverter(converter);
            return converter;
        }
        return null;
    }

    private String zeroPad(int number, int width) {
        DecimalFormat formatter;
        if (width == 2) {
            formatter = DECIMAL_FORMAT2;
        } else if (width == 4) {
            formatter = DECIMAL_FORMAT4;
        } else {
            throw new IllegalArgumentException("Width must be 2 or 4");
        }
        return formatter.format(number);
    }

    private void errorBadFormat(FacesContext context) {
        String pattern = Util.getMessage("popupcalendar.badFormat");
        String summary = MessageFormat.format(pattern, this.getLocalizedPrompt());
        FacesMessage message = new FacesMessage(summary);
        message.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage(this.getClientId(context), message);
        this.setValid(false);
        this.setSubmittedValue(null);
    }

    public String getLocaleString() {
        if (this.localeString != null) {
            return this.localeString;
        }
        ValueBinding _vb = this.getValueBinding(LOCALE_STRING);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setLocaleString(String localeString) {
        this.localeString = localeString;
        this.fieldsInitialized = false;
    }

    public String getDateFormatPattern() {
        if (this.dateFormatPattern != null) {
            return this.dateFormatPattern;
        }
        ValueBinding _vb = this.getValueBinding(DATE_FORMAT_PATTERN);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
        this.fieldsInitialized = false;
    }

    public String getValueAsString() {
        return (String)this.getValue();
    }

    public void setValueAsString(String stringValue) {
        this.setValue(stringValue);
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding _vb = this.getValueBinding("style");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueBinding _vb = this.getValueBinding("styleClass");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    private String getLocalizedPrompt() {
        this.ensureDerivedFields();
        return this.localizedPrompt;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (DATE_FORMAT_PATTERN.equals(name) || LOCALE_STRING.equals(name)) {
            this.fieldsInitialized = false;
        }
        super.setValueBinding(name, binding);
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.dateFormatPattern = (String)_values[1];
        this.localeString = (String)_values[2];
        this.style = (String)_values[3];
        this.styleClass = (String)_values[4];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.dateFormatPattern, this.localeString, this.style, this.styleClass};
        return _values;
    }

    private static class PatternInfo {
        private int yearIndex;
        private int monthIndex;
        private int dayIndex;
        private String separator;

        public PatternInfo(int yearIndex, int monthIndex, int dayIndex, String separator) {
            this.yearIndex = yearIndex;
            this.monthIndex = monthIndex;
            this.dayIndex = dayIndex;
            this.separator = separator;
        }

        public int getDayIndex() {
            return this.dayIndex;
        }

        public int getMonthIndex() {
            return this.monthIndex;
        }

        public String getSeparator() {
            return this.separator;
        }

        public int getYearIndex() {
            return this.yearIndex;
        }
    }
}

