/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

public class RADVisualComponent
extends RADComponent {
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE = "layoutComponentHorizontalSize";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_SIZE = "layoutComponentVerticalSize";
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE = "layoutComponentHorizontalResizable";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE = "layoutComponentVerticalResizable";
    private HashMap constraints = new HashMap();
    private Node.Property[] constraintsProperties;
    private ConstraintsListener constraintsListener;
    private MetaAccessibleContext accessibilityData;
    private FormProperty[] accessibilityProperties;

    public final RADVisualContainer getParentContainer() {
        return (RADVisualContainer)this.getParentComponent();
    }

    public final int getComponentIndex() {
        RADVisualContainer parent = (RADVisualContainer)this.getParentComponent();
        return parent != null ? parent.getIndexOf(this) : -1;
    }

    final LayoutSupportManager getParentLayoutSupport() {
        RADVisualContainer parent = (RADVisualContainer)this.getParentComponent();
        return parent != null ? parent.getLayoutSupport() : null;
    }

    public void setLayoutConstraints(Class layoutDelegateClass, LayoutConstraints constr) {
        if (constr != null) {
            this.constraints.put(layoutDelegateClass.getName(), constr);
        }
    }

    public LayoutConstraints getLayoutConstraints(Class layoutDelegateClass) {
        return (LayoutConstraints)this.constraints.get(layoutDelegateClass.getName());
    }

    HashMap getConstraintsMap() {
        return this.constraints;
    }

    void setConstraintsMap(Map map) {
        for (Object layoutClassName : map.keySet()) {
            this.constraints.put(layoutClassName, map.get(layoutClassName));
        }
    }

    protected void createPropertySets(List propSets) {
        super.createPropertySets(propSets);
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        if (this.constraintsProperties != null && this.constraintsProperties.length > 0) {
            propSets.add(propSets.size() - 1, new Node.PropertySet("layout", FormUtils.getBundleString("CTL_LayoutTab"), FormUtils.getBundleString("CTL_LayoutTabHint")){

                public Node.Property[] getProperties() {
                    return RADVisualComponent.this.getConstraintsProperties();
                }
            });
        }
        if (this.accessibilityProperties == null) {
            this.createAccessibilityProperties();
        }
        if (this.accessibilityProperties.length > 0) {
            propSets.add(new Node.PropertySet("accessibility", FormUtils.getBundleString("CTL_AccessibilityTab"), FormUtils.getBundleString("CTL_AccessibilityTabHint")){

                public Node.Property[] getProperties() {
                    return RADVisualComponent.this.getAccessibilityProperties();
                }
            });
        }
    }

    public Node.Property getPropertyByName(String name, Class propertyType, boolean fromAll) {
        if (fromAll && this.accessibilityProperties == null) {
            this.createAccessibilityProperties();
        }
        return super.getPropertyByName(name, propertyType, fromAll);
    }

    protected void clearProperties() {
        super.clearProperties();
        this.constraintsProperties = null;
        this.accessibilityData = null;
        this.accessibilityProperties = null;
    }

    public Node.Property[] getConstraintsProperties() {
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        return this.constraintsProperties;
    }

    public void resetConstraintsProperties() {
        if (this.constraintsProperties != null) {
            for (int i = 0; i < this.constraintsProperties.length; ++i) {
                this.nameToProperty.remove(this.constraintsProperties[i].getName());
            }
            this.constraintsProperties = null;
            this.propertySets = null;
            RADComponentNode node = this.getNodeReference();
            if (node != null) {
                node.fireComponentPropertySetsChange();
            }
        }
    }

    private void createConstraintsProperties() {
        this.constraintsProperties = null;
        LayoutSupportManager layoutSupport = this.getParentLayoutSupport();
        if (layoutSupport != null) {
            LayoutConstraints constr = layoutSupport.getConstraints(this);
            if (constr != null) {
                this.constraintsProperties = constr.getProperties();
            }
        } else if (this.getParentContainer() != null) {
            LayoutComponent component = this.getFormModel().getLayoutModel().getLayoutComponent(this.getId());
            if (component == null) {
                return;
            }
            this.constraintsProperties = new Node.Property[]{new LayoutComponentSizeProperty(component, 0), new LayoutComponentSizeProperty(component, 1), new LayoutComponentResizableProperty(component, 0), new LayoutComponentResizableProperty(component, 1)};
            component.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    RADComponentNode node = RADVisualComponent.this.getNodeReference();
                    if ("horizontalPrefSize".equals(propName)) {
                        node.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE, null, null);
                    } else if ("verticalPrefSize".equals(propName)) {
                        node.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_SIZE, null, null);
                    } else if ("horizontalMaxSize".equals(propName)) {
                        node.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE, null, null);
                    } else if ("verticalMaxSize".equals(propName)) {
                        node.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE, null, null);
                    }
                }
            });
        }
        if (this.constraintsProperties == null) {
            this.constraintsProperties = NO_PROPERTIES;
            return;
        }
        for (int i = 0; i < this.constraintsProperties.length; ++i) {
            if (!(this.constraintsProperties[i] instanceof FormProperty)) continue;
            FormProperty prop = (FormProperty)this.constraintsProperties[i];
            prop.addVetoableChangeListener(this.getConstraintsListener());
            prop.addPropertyChangeListener(this.getConstraintsListener());
            prop.setPropertyContext(new RADProperty.RADPropertyContext(this));
            if (this.isReadOnly() || !this.isValid()) {
                int type = prop.getAccessType() | 0xA;
                prop.setAccessType(type);
            }
            this.nameToProperty.put(prop.getName(), prop);
        }
    }

    private ConstraintsListener getConstraintsListener() {
        if (this.constraintsListener == null) {
            this.constraintsListener = new ConstraintsListener();
        }
        return this.constraintsListener;
    }

    public FormProperty[] getAccessibilityProperties() {
        if (this.accessibilityProperties == null) {
            this.createAccessibilityProperties();
        }
        return this.accessibilityProperties;
    }

    private void createAccessibilityProperties() {
        Object comp = this.getBeanInstance();
        if (comp instanceof Accessible && ((Accessible)comp).getAccessibleContext() != null) {
            if (this.accessibilityData == null) {
                this.accessibilityData = new MetaAccessibleContext();
            }
            this.accessibilityProperties = this.accessibilityData.getProperties();
            for (int i = 0; i < this.accessibilityProperties.length; ++i) {
                FormProperty prop = this.accessibilityProperties[i];
                this.setPropertyListener(prop);
                prop.setPropertyContext(new RADProperty.RADPropertyContext(this));
                this.nameToProperty.put(prop.getName(), prop);
            }
        } else {
            this.accessibilityData = null;
            this.accessibilityProperties = NO_PROPERTIES;
        }
    }

    private class LayoutComponentResizableProperty
    extends PropertySupport.ReadWrite {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentResizableProperty(LayoutComponent component, int dimension) {
            super(dimension == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE, Boolean.class, null, null);
            boolean horizontal = dimension == 0;
            this.setDisplayName(FormUtils.getBundleString(horizontal ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.setShortDescription(FormUtils.getBundleString(horizontal ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "HINT_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.component = component;
            this.dimension = dimension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            Boolean oldValue = (Boolean)this.getValue();
            Boolean newValue = (Boolean)value;
            boolean resizable = newValue;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval interval = this.component.getLayoutInterval(this.dimension);
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            try {
                layoutModel.setIntervalSize(interval, resizable ? -1 : -2, interval.getPreferredSize(false), resizable ? Short.MAX_VALUE : -2);
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), oldValue, newValue);
                autoUndo = false;
                Object var11_10 = null;
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(ue);
                }
                if (autoUndo) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
                throw throwable;
            }
            if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                RADVisualComponent.this.getFormModel().addUndoableEdit(ue);
            }
            if (autoUndo) {
                RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
            }
        }

        public Object getValue() {
            int pref = this.component.getLayoutInterval(this.dimension).getPreferredSize(false);
            int max = this.component.getLayoutInterval(this.dimension).getMaximumSize(false);
            return max != pref && max != -2;
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() {
            this.setValue(Boolean.FALSE);
        }

        public boolean isDefaultValue() {
            return this.getValue().equals(Boolean.FALSE);
        }

        public boolean canWrite() {
            return !RADVisualComponent.this.isReadOnly();
        }
    }

    private class LayoutComponentSizeProperty
    extends PropertySupport.ReadWrite {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentSizeProperty(LayoutComponent component, int dimension) {
            super(dimension == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_SIZE, Integer.class, null, null);
            boolean horizontal = dimension == 0;
            this.setDisplayName(FormUtils.getBundleString(horizontal ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "PROP_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.setShortDescription(FormUtils.getBundleString(horizontal ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "HINT_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.component = component;
            this.dimension = dimension;
            this.setValue("canEditAsText", Boolean.TRUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer oldValue = (Integer)this.getValue();
            Integer newValue = (Integer)value;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval interval = this.component.getLayoutInterval(this.dimension);
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            try {
                layoutModel.setIntervalSize(interval, interval.getMinimumSize(false), newValue, interval.getMaximumSize(false));
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), oldValue, newValue);
                autoUndo = false;
                Object var10_9 = null;
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(ue);
                }
                if (autoUndo) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
                throw throwable;
            }
            if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                RADVisualComponent.this.getFormModel().addUndoableEdit(ue);
            }
            if (autoUndo) {
                RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
            }
        }

        public Object getValue() {
            int size = this.component.getLayoutInterval(this.dimension).getPreferredSize(false);
            return new Integer(size);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() {
            this.setValue(new Integer(-1));
        }

        public boolean isDefaultValue() {
            return (Integer)this.getValue() == -1;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport(){
                private String notExplicitelyDefined = FormUtils.getBundleString("VALUE_SizeNotExplicitelyDefined");

                public String[] getTags() {
                    return new String[]{this.notExplicitelyDefined};
                }

                public String getAsText() {
                    Integer value = (Integer)this.getValue();
                    if (value == -1) {
                        return this.notExplicitelyDefined;
                    }
                    return value.toString();
                }

                public void setAsText(String str) {
                    if (this.notExplicitelyDefined.equals(str)) {
                        this.setValue(new Integer(-1));
                    } else {
                        try {
                            this.setValue(new Integer(Integer.parseInt(str)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            };
        }

        public boolean canWrite() {
            return !RADVisualComponent.this.isReadOnly();
        }
    }

    public static class AccessibleParentEditor
    extends ComponentChooserEditor {
        public AccessibleParentEditor() {
            this.setBeanTypes(new Class[]{Accessible.class});
        }
    }

    private class MetaAccessibleContext {
        private Object accName = BeanSupport.NO_VALUE;
        private Object accDescription = BeanSupport.NO_VALUE;
        private Object accParent = BeanSupport.NO_VALUE;
        private FormProperty[] properties;

        private MetaAccessibleContext() {
        }

        FormProperty[] getProperties() {
            if (this.properties == null) {
                this.properties = new FormProperty[]{new FormProperty("AccessibleContext.accessibleName", String.class, FormUtils.getBundleString("PROP_AccessibleName"), FormUtils.getBundleString("PROP_AccessibleName")){

                    public Object getTargetValue() {
                        return MetaAccessibleContext.this.accName != BeanSupport.NO_VALUE ? MetaAccessibleContext.this.accName : this.getDefaultValue();
                    }

                    public void setTargetValue(Object value) {
                        MetaAccessibleContext.this.accName = (String)value;
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        return MetaAccessibleContext.this.getAccessibleContext().getAccessibleName();
                    }

                    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
                        super.restoreDefaultValue();
                        MetaAccessibleContext.this.accName = BeanSupport.NO_VALUE;
                    }

                    String getPartialSetterCode() {
                        return "getAccessibleContext().setAccessibleName(" + this.getJavaInitializationString() + ")";
                    }
                }, new FormProperty("AccessibleContext.accessibleDescription", String.class, FormUtils.getBundleString("PROP_AccessibleDescription"), FormUtils.getBundleString("PROP_AccessibleDescription")){

                    public Object getTargetValue() {
                        return MetaAccessibleContext.this.accDescription != BeanSupport.NO_VALUE ? MetaAccessibleContext.this.accDescription : this.getDefaultValue();
                    }

                    public void setTargetValue(Object value) {
                        MetaAccessibleContext.this.accDescription = (String)value;
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        return MetaAccessibleContext.this.getAccessibleContext().getAccessibleDescription();
                    }

                    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
                        super.restoreDefaultValue();
                        MetaAccessibleContext.this.accDescription = BeanSupport.NO_VALUE;
                    }

                    String getPartialSetterCode() {
                        return "getAccessibleContext().setAccessibleDescription(" + this.getJavaInitializationString() + ")";
                    }
                }, new FormProperty("AccessibleContext.accessibleParent", Accessible.class, FormUtils.getBundleString("PROP_AccessibleParent"), FormUtils.getBundleString("PROP_AccessibleParent")){

                    public Object getTargetValue() {
                        return MetaAccessibleContext.this.accParent != BeanSupport.NO_VALUE ? MetaAccessibleContext.this.accParent : this.getDefaultValue();
                    }

                    public void setTargetValue(Object value) {
                        MetaAccessibleContext.this.accParent = (Accessible)value;
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        Container cont;
                        RADVisualContainer metacont;
                        Accessible acP = MetaAccessibleContext.this.getAccessibleContext().getAccessibleParent();
                        if (acP != null && (metacont = RADVisualComponent.this.getParentContainer()) != null && (cont = metacont.getContainerDelegate(metacont.getBeanInstance())) == acP) {
                            return metacont;
                        }
                        return acP;
                    }

                    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
                        super.restoreDefaultValue();
                        MetaAccessibleContext.this.accParent = BeanSupport.NO_VALUE;
                    }

                    public PropertyEditor getExpliciteEditor() {
                        return new AccessibleParentEditor();
                    }

                    String getPartialSetterCode() {
                        String str = this.getJavaInitializationString();
                        return str == null ? null : "getAccessibleContext().setAccessibleParent(" + str + ")";
                    }
                }};
            }
            return this.properties;
        }

        private AccessibleContext getAccessibleContext() {
            return ((Accessible)RADVisualComponent.this.getBeanInstance()).getAccessibleContext();
        }
    }

    private class ConstraintsListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private ConstraintsListener() {
        }

        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            Object source = ev.getSource();
            String eventName = ev.getPropertyName();
            if (source instanceof FormProperty && ("propertyValue".equals(eventName) || "propertyValueAndEditor".equals(eventName))) {
                LayoutSupportManager layoutSupport = RADVisualComponent.this.getParentLayoutSupport();
                int index = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints constraints = layoutSupport.getConstraints(index);
                ev = new PropertyChangeEvent(constraints, ((FormProperty)((Object)source)).getName(), ev.getOldValue(), ev.getNewValue());
                layoutSupport.componentLayoutChanged(index, ev);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            Object source = ev.getSource();
            if (source instanceof FormProperty && "currentEditor".equals(ev.getPropertyName())) {
                LayoutSupportManager layoutSupport = RADVisualComponent.this.getParentLayoutSupport();
                int index = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints constraints = layoutSupport.getConstraints(index);
                ev = new PropertyChangeEvent(constraints, null, null, null);
                try {
                    layoutSupport.componentLayoutChanged(index, ev);
                }
                catch (PropertyVetoException ex) {
                    // empty catch block
                }
            }
        }
    }
}

