/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.EventCustomEditor;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponentNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Utilities;

class EventProperty
extends PropertySupport.ReadWrite {
    private static String NO_EVENT;
    private static boolean somethingChanged;
    private static boolean invalidValueTried;
    private Event event;
    private String selectedEventHandler;

    EventProperty(Event event, String eventId) {
        super(eventId, String.class, event.getListenerMethod().getName(), event.getListenerMethod().getName());
        this.event = event;
        this.setShortDescription(event.getEventSetDescriptor().getListenerType().getName());
    }

    Event getEvent() {
        return this.event;
    }

    private FormEvents getFormEvents() {
        return this.event.getComponent().getFormModel().getFormEvents();
    }

    private Method getListenerMethod() {
        return this.event.getListenerMethod();
    }

    String[] getEventHandlers() {
        return this.event.getEventHandlers();
    }

    public Object getValue() {
        if (this.selectedEventHandler == null && this.event.hasEventHandlers()) {
            this.selectedEventHandler = (String)this.event.getEventHandlerList().get(0);
        }
        return this.selectedEventHandler;
    }

    public void setValue(Object val) {
        Change change = null;
        String newSelectedHandler = null;
        if (val instanceof Change) {
            change = (Change)val;
        } else if (val instanceof String) {
            String[] handlers = this.getEventHandlers();
            if (handlers.length > 0) {
                String current;
                String string = current = this.selectedEventHandler != null ? this.selectedEventHandler : handlers[0];
                if ("".equals(val)) {
                    change = new Change();
                    change.getRemoved().add(current);
                    for (int i = 0; i < handlers.length; ++i) {
                        if (handlers[i].equals(current)) continue;
                        newSelectedHandler = handlers[i];
                        break;
                    }
                } else {
                    newSelectedHandler = (String)val;
                    boolean ignore = false;
                    for (int i = 0; i < handlers.length; ++i) {
                        if (!handlers[i].equals(val)) continue;
                        ignore = true;
                        break;
                    }
                    if (!ignore) {
                        change = new Change();
                        change.getRenamedNewNames().add(val);
                        change.getRenamedOldNames().add(current);
                    }
                }
            } else if (!"".equals(val)) {
                change = new Change();
                change.getAdded().add((String)val);
                newSelectedHandler = (String)val;
            }
        } else if (val == null) {
            if (this.selectedEventHandler == null) {
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (change != null) {
            somethingChanged = true;
            FormEvents formEvents = this.getFormEvents();
            if (change.hasRemoved()) {
                Iterator it = change.getRemoved().iterator();
                while (it.hasNext()) {
                    formEvents.detachEvent(this.event, (String)it.next());
                }
            }
            if (change.hasRenamed()) {
                for (int i = 0; i < change.getRenamedOldNames().size(); ++i) {
                    String oldName = (String)change.getRenamedOldNames().get(i);
                    String newName = (String)change.getRenamedNewNames().get(i);
                    try {
                        formEvents.renameEventHandler(oldName, newName);
                        Event[] events = formEvents.getEventsForHandler(newName);
                        for (int j = 0; j < events.length; ++j) {
                            Node.Property prop = events[j].getComponent().getPropertyByName(this.getName());
                            if (prop == null || prop == this) continue;
                            try {
                                if (!oldName.equals(prop.getValue())) continue;
                                prop.setValue((Object)newName);
                                continue;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        ErrorManager.getDefault().notify(16, (Throwable)ex);
                        newSelectedHandler = null;
                    }
                }
            }
            if (change.hasAdded()) {
                Iterator it = change.getAdded().iterator();
                while (it.hasNext()) {
                    try {
                        formEvents.attachEvent(this.event, (String)it.next(), null);
                    }
                    catch (IllegalArgumentException ex) {
                        ErrorManager.getDefault().notify(16, (Throwable)ex);
                        newSelectedHandler = null;
                    }
                }
            }
        }
        this.selectedEventHandler = newSelectedHandler;
        RADComponentNode node = this.event.getComponent().getNodeReference();
        if (node != null) {
            node.firePropertyChangeHelper(this.getName(), null, null);
        }
    }

    public Object getValue(String key) {
        if ("canEditAsText".equals(key)) {
            return Boolean.TRUE;
        }
        if ("initialEditValue".equals(key)) {
            somethingChanged = false;
            invalidValueTried = false;
            return this.selectedEventHandler != null ? null : this.getFormEvents().findFreeHandlerName(this.event, this.event.getComponent());
        }
        if ("postSetAction".equals(key)) {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent ev) {
                    if (!somethingChanged && !invalidValueTried) {
                        EventProperty.this.getFormEvents().attachEvent(EventProperty.this.event, EventProperty.this.selectedEventHandler, null);
                    }
                }
            };
        }
        return super.getValue(key);
    }

    public boolean canWrite() {
        return !this.isReadOnly();
    }

    private boolean isReadOnly() {
        return this.event.getComponent().isReadOnly();
    }

    public PropertyEditor getPropertyEditor() {
        return new EventEditor();
    }

    private class EventEditor
    extends PropertyEditorSupport {
        private EventEditor() {
        }

        public String getAsText() {
            if (this.getValue() == null) {
                if (NO_EVENT == null) {
                    NO_EVENT = FormUtils.getBundleString("CTL_NoEvent");
                }
                return NO_EVENT;
            }
            return this.getValue().toString();
        }

        public void setAsText(String txt) {
            if (!"".equals(txt) && !Utilities.isJavaIdentifier((String)txt)) {
                invalidValueTried = true;
                IllegalArgumentException iae = new IllegalArgumentException();
                String annotation = FormUtils.getFormattedBundleString("FMT_MSG_InvalidJavaIdentifier", new Object[]{txt});
                ErrorManager.getDefault().annotate((Throwable)iae, 65536, "Not a java identifier", annotation, null, null);
                throw iae;
            }
            if ("".equals(txt) && this.getValue() == null) {
                invalidValueTried = true;
                IllegalArgumentException iae = new IllegalArgumentException();
                String emptyStringTxt = FormUtils.getBundleString("FMT_MSG_EmptyString");
                String annotation = FormUtils.getFormattedBundleString("FMT_MSG_InvalidJavaIdentifier", new Object[]{emptyStringTxt});
                ErrorManager.getDefault().annotate((Throwable)iae, 65536, "Not a java identifier", annotation, null, null);
                throw iae;
            }
            invalidValueTried = false;
            this.setValue(txt);
        }

        public String[] getTags() {
            String[] handlers = EventProperty.this.getEventHandlers();
            return handlers.length > 1 ? handlers : null;
        }

        public boolean supportsCustomEditor() {
            return !EventProperty.this.isReadOnly();
        }

        public Component getCustomEditor() {
            if (EventProperty.this.isReadOnly()) {
                return null;
            }
            final EventCustomEditor ed = new EventCustomEditor(EventProperty.this);
            DialogDescriptor dd = new DialogDescriptor((Object)ed, FormUtils.getFormattedBundleString("FMT_MSG_HandlersFor", new Object[]{EventProperty.this.getListenerMethod().getName()}), true, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource().equals(DialogDescriptor.OK_OPTION)) {
                        ed.doChanges();
                    }
                }
            });
            return DialogDisplayer.getDefault().createDialog(dd);
        }
    }

    static class Change {
        private List added;
        private List removed;
        private List renamedOldName;
        private List renamedNewName;

        Change() {
        }

        boolean hasAdded() {
            return this.added != null && this.added.size() > 0;
        }

        boolean hasRemoved() {
            return this.removed != null && this.removed.size() > 0;
        }

        boolean hasRenamed() {
            return this.renamedOldName != null && this.renamedOldName.size() > 0;
        }

        List getAdded() {
            if (this.added == null) {
                this.added = new ArrayList();
            }
            return this.added;
        }

        List getRemoved() {
            if (this.removed == null) {
                this.removed = new ArrayList();
            }
            return this.removed;
        }

        List getRenamedOldNames() {
            if (this.renamedOldName == null) {
                this.renamedOldName = new ArrayList();
            }
            return this.renamedOldName;
        }

        List getRenamedNewNames() {
            if (this.renamedNewName == null) {
                this.renamedNewName = new ArrayList();
            }
            return this.renamedNewName;
        }
    }
}

