/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.openide.util.NbBundle;

public class CustomZoomPanel
extends JPanel {
    private JLabel enlargeLabel;
    private JTextField enlargeText;
    private JLabel decreasingLabel;
    private JTextField decreaseText;

    public CustomZoomPanel() {
        this.initComponents();
        this.initAccessibility();
    }

    private void initComponents() {
        this.enlargeLabel = new JLabel();
        this.enlargeLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("LBL_EnlargeFactor_Mnem").charAt(0));
        this.enlargeText = new JTextField();
        this.decreasingLabel = new JLabel();
        this.decreasingLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("LBL_DecreaseFactor_Mnem").charAt(0));
        this.decreaseText = new JTextField();
        this.setLayout(new GridBagLayout());
        this.enlargeLabel.setText(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("LBL_EnlargeFactor"));
        this.enlargeLabel.setLabelFor(this.enlargeText);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.enlargeLabel, gridBagConstraints1);
        this.enlargeText.setDocument(new WholeNumberDocument());
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 11, 0, 11);
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.enlargeText, gridBagConstraints1);
        this.decreasingLabel.setText(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("LBL_DecreaseFactor"));
        this.decreasingLabel.setLabelFor(this.decreaseText);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(5, 12, 11, 0);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.decreasingLabel, gridBagConstraints1);
        this.decreaseText.setDocument(new WholeNumberDocument());
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 11, 11, 11);
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.decreaseText, gridBagConstraints1);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("ACSD_CustomZoomPanel"));
        this.enlargeText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("ACS_EnlargeText"));
        this.decreaseText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)CustomZoomPanel.class).getString("ACS_DecreaseText"));
    }

    public int getEnlargeFactor() {
        return Integer.parseInt(this.enlargeText.getText());
    }

    public void setEnlargeFactor(int enlargeFactor) {
        this.enlargeText.setText("" + enlargeFactor);
    }

    public int getDecreaseFactor() {
        return Integer.parseInt(this.decreaseText.getText());
    }

    public void setDecreaseFactor(int decreaseFactor) {
        this.decreaseText.setText("" + decreaseFactor);
    }

    private static class WholeNumberDocument
    extends PlainDocument {
        private WholeNumberDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < source.length; ++i) {
                if (Character.isDigit(source[i])) {
                    result.append(source[i]);
                    continue;
                }
                if (!Boolean.getBoolean("netbeans.debug.excpetions")) continue;
                System.err.println("Image: Trying insert non-digit in custom zoom action.");
            }
            if (result.length() == 0) {
                return;
            }
            super.insertString(offs, result.toString(), a);
        }
    }
}

