/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.jmi.reflect.RefFeatured;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.refactoring.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class UseSuperTypePanel
extends CustomRefactoringPanel {
    private final UseSuperTypeRefactoring refactoring;
    private JLabel label;
    private JScrollPane listScrollPane;
    private JList superTypeList;

    public UseSuperTypePanel(UseSuperTypeRefactoring refactoring, final ParametersPanel parent) {
        this.refactoring = refactoring;
        this.initComponents();
        Element subType = refactoring.getTypeElement();
        String title = null;
        if (!(subType instanceof JavaClass)) {
            title = NbBundle.getMessage((Class)UseSuperTypePanel.class, (String)"LBL_UseSuperType");
        } else {
            String className = ((JavaClass)subType).getName();
            title = NbBundle.getMessage((Class)UseSuperTypePanel.class, (String)"LBL_UseSyperTypeTitle", (Object)className);
        }
        this.setName(title);
        this.superTypeList.setCellRenderer(new UIUtilities.JavaElementListCellRenderer(){

            protected String extractText(Object value) {
                RefFeatured current;
                JavaClass topLevel = (JavaClass)value;
                while ((current = topLevel.refImmediateComposite()) instanceof JavaClass) {
                    topLevel = (JavaClass)current;
                }
                String packageName = topLevel.getName();
                packageName = packageName.substring(0, packageName.length() - topLevel.getSimpleName().length());
                String className = ((JavaClass)value).getName().substring(packageName.length());
                if (packageName.length() > 0) {
                    packageName = " (" + packageName.substring(0, packageName.length() - 1) + ")";
                }
                return className.concat(packageName);
            }
        });
        this.superTypeList.setModel(new DefaultComboBoxModel<JavaClass>(refactoring.getCandidateSuperTypes()));
        this.superTypeList.setSelectionMode(0);
        this.superTypeList.setSelectedIndex(0);
        this.superTypeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                parent.stateChanged(null);
            }
        });
    }

    public void initialize() {
    }

    public JavaClass getSuperType() {
        return (JavaClass)this.superTypeList.getSelectedValue();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.superTypeList = new JList();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(600, 500));
        this.setPreferredSize(new Dimension(300, 200));
        this.label.setLabelFor(this.superTypeList);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getBundle((Class)UseSuperTypePanel.class).getString("DSC_UseSuperType"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.label, gridBagConstraints);
        this.superTypeList.setSelectionMode(0);
        this.listScrollPane.setViewportView(this.superTypeList);
        this.superTypeList.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)UseSuperTypePanel.class, (String)"ACSD_SupertypeToUse"));
        this.superTypeList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)UseSuperTypePanel.class, (String)"ACSD_SupertypeToUseDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listScrollPane, gridBagConstraints);
    }
}

