/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.PullUpAction;
import org.netbeans.modules.refactoring.ui.PullUpPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PullUpRefactoringUI
implements RefactoringUI {
    private final PullUpRefactoring refactoring;
    private final JavaClass sourceType;
    private final Set initialMembers = new HashSet();
    private PullUpPanel panel;

    public PullUpRefactoringUI(Element[] selectedElements) {
        this.sourceType = PullUpRefactoringUI.getSourceType(selectedElements, this.initialMembers);
        this.refactoring = new PullUpRefactoring(this.sourceType);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (this.panel == null) {
            this.panel = new PullUpPanel(this.refactoring, this.initialMembers, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage((Class)PullUpAction.class, (String)"DSC_PullUp", (Object)this.sourceType.getName());
    }

    public String getName() {
        return NbBundle.getMessage((Class)PullUpAction.class, (String)"LBL_PullUp");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PullUpRefactoringUI.class.getName());
    }

    private void captureParameters() {
        this.refactoring.setTargetType(this.panel.getTargetType());
        this.refactoring.setMembers(this.panel.getMembers());
    }

    private static JavaClass getSourceType(Element[] elements, Set initialMembers) {
        JavaClass result = null;
        HashMap elementsByClass = new HashMap();
        for (int i = 0; i < elements.length; ++i) {
            Element temp;
            ClassDefinition element = null;
            for (temp = elements[i]; !(temp == null || temp instanceof Resource || temp instanceof JavaClass || temp instanceof Field || temp instanceof Method); temp = (Element)temp.refImmediateComposite()) {
                if (!(temp instanceof MultipartId)) continue;
                element = temp;
            }
            if (temp == null) continue;
            if (temp instanceof Resource) {
                int start;
                element = null;
                String name = ((Resource)temp).getName();
                int end = name.indexOf(46, start = name.lastIndexOf(47) + 1);
                if (end < 0) {
                    end = name.length();
                }
                name = name.substring(start, end);
                Iterator it = ((Resource)temp).getClassifiers().iterator();
                while (it.hasNext()) {
                    JavaClass cls = (JavaClass)it.next();
                    temp = cls;
                    if (!name.equals(cls.getSimpleName())) continue;
                    break;
                }
            }
            if (temp instanceof JavaClass) {
                if (element == null || !((JavaClass)temp).getInterfaceNames().contains(element)) {
                    PullUpRefactoringUI.addToMap(elementsByClass, (JavaClass)temp, null);
                } else {
                    Element cls = temp;
                    temp = element;
                    element = cls;
                }
            }
            if (temp instanceof Feature) {
                element = ((Feature)temp).getDeclaringClass();
            }
            if (!(element instanceof JavaClass)) continue;
            PullUpRefactoringUI.addToMap(elementsByClass, (JavaClass)element, temp);
        }
        Set maxMembers = Collections.EMPTY_SET;
        Iterator it = elementsByClass.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Set value = (Set)entry.getValue();
            if (maxMembers.size() >= value.size() && (maxMembers.size() != value.size() || !value.contains(null))) continue;
            maxMembers = value;
            result = (JavaClass)entry.getKey();
        }
        initialMembers.addAll(maxMembers);
        return result;
    }

    private static void addToMap(Map map, JavaClass parentClass, Element member) {
        HashSet<Element> value = (HashSet<Element>)map.get(parentClass);
        if (value == null) {
            value = new HashSet<Element>();
            map.put(parentClass, value);
        }
        value.add(member);
    }
}

