/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.ui.MoveClassAction;
import org.openide.ErrorManager;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.PasteType;

public class ClipboardConvertor
implements ExClipboard.Convertor {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$refactoring$ui$MoveClassAction;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public Transferable convert(Transferable t) {
        HashSet dataObjects;
        Node[] nodes = NodeTransfer.nodes((Transferable)t, (int)4);
        if (nodes != null && nodes.length > 0 && this.getDOs(nodes, dataObjects = new HashSet())) {
            return NodeTransfer.createPaste((NodeTransfer.Paste)new RefactoringPaste(t, nodes, dataObjects));
        }
        return t;
    }

    private boolean getDOs(Node[] nodes, Set result) {
        HashSet<DataObject> folders = new HashSet<DataObject>();
        boolean jdoFound = false;
        for (int i = 0; i < nodes.length; ++i) {
            DataObject dob = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? ClipboardConvertor.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (!ClipboardConvertor.isOnClassPath(dob)) {
                return false;
            }
            if (dob instanceof DataFolder) {
                folders.add(dob);
            } else if (dob instanceof JavaDataObject) {
                jdoFound = true;
            }
            result.add(dob);
        }
        if (jdoFound) {
            return true;
        }
        Iterator i = folders.iterator();
        while (i.hasNext()) {
            DataFolder fold = (DataFolder)i.next();
            Enumeration e = fold.children(true);
            while (e.hasMoreElements()) {
                if (!(e.nextElement() instanceof JavaDataObject)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isOnClassPath(DataObject dob) {
        if (dob == null) {
            return false;
        }
        return ((JMManager)JavaMetamodel.getManager()).getMergedClassPath().contains(dob.getPrimaryFile());
    }

    private class RefactoringPaste
    implements NodeTransfer.Paste {
        private Transferable orig;
        private Node nodes;
        private Set dataObjects;

        RefactoringPaste(Transferable t) {
            this.orig = t;
        }

        RefactoringPaste(Transferable t, Node[] noodes, Set dataObjects) {
            this.orig = t;
            this.nodes = this.nodes;
            this.dataObjects = dataObjects;
        }

        public PasteType[] types(Node target) {
            if (target instanceof DataFolder.FolderNode) {
                return new PasteType[]{new RefactoringPasteType(this.orig, target, this.dataObjects)};
            }
            return target.getPasteTypes(this.orig);
        }
    }

    private class RefactoringPasteType
    extends PasteType {
        Node target;
        Transferable orig;
        Set dataObjects;

        RefactoringPasteType(Transferable orig, Node target, Set dataObjects) {
            this.target = target;
            this.orig = orig;
            this.dataObjects = dataObjects;
        }

        public Transferable paste() throws IOException {
            Node[] nodes = NodeTransfer.nodes((Transferable)this.orig, (int)4);
            DataObject dob = (DataObject)this.target.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ClipboardConvertor.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            final PasteType[] types = this.target.getPasteTypes(this.orig);
            if (types == null || types.length == 0) {
                ErrorManager.getDefault().notify(1, (Throwable)new Exception("No paste type available"));
                return null;
            }
            if (!ClipboardConvertor.isOnClassPath(dob)) {
                types[0].paste();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MoveClassAction move = (MoveClassAction)MoveClassAction.findObject((Class)(class$org$netbeans$modules$refactoring$ui$MoveClassAction == null ? (class$org$netbeans$modules$refactoring$ui$MoveClassAction = ClipboardConvertor.class$("org.netbeans.modules.refactoring.ui.MoveClassAction")) : class$org$netbeans$modules$refactoring$ui$MoveClassAction));
                        move.performAction(RefactoringPasteType.this.dataObjects, ((DataFolder)RefactoringPasteType.this.target.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ClipboardConvertor.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)).getPrimaryFile(), types[0]);
                    }
                });
            }
            return null;
        }
    }
}

