/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.MultipartIdClass;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.UndoWatcher;
import org.netbeans.modules.refactoring.Utilities;
import org.netbeans.modules.refactoring.api.ExtractSuperClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class ExtractSuperClassRefactoringPlugin
extends JavaRefactoringPlugin {
    private final ExtractSuperClassRefactoring refactoring;
    static /* synthetic */ Class class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin;

    ExtractSuperClassRefactoringPlugin(ExtractSuperClassRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 2);
        try {
            JavaClass sourceType = this.refactoring.getSourceType();
            Problem result = ExtractSuperClassRefactoringPlugin.isElementAvail((Element)sourceType);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (!CheckUtils.isElementInOpenProject((Element)sourceType)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
            if (sourceType instanceof UnresolvedClass) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            this.fireProgressListenerStep();
            if (sourceType.isInterface() || sourceType instanceof JavaEnum) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)ExtractSuperClassRefactoringPlugin.class, (String)"ERR_ExtractSC_MustBeClass"));
                return problem;
            }
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        Problem result = null;
        JavaClass sourceType = this.refactoring.getSourceType();
        String oldName = sourceType.getSimpleName();
        String newName = this.refactoring.getSuperClassName();
        if (!org.openide.util.Utilities.isJavaIdentifier((String)newName)) {
            result = ExtractSuperClassRefactoringPlugin.createProblem(result, true, NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        Resource resource = sourceType.getResource();
        FileObject primFile = JavaModel.getFileObject((Resource)resource);
        FileObject folder = primFile.getParent();
        FileObject[] children = folder.getChildren();
        for (int x = 0; x < children.length; ++x) {
            if (children[x].isVirtual() || !children[x].getName().equals(newName) || !"java".equals(children[x].getExt())) continue;
            result = ExtractSuperClassRefactoringPlugin.createProblem(result, true, NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_ClassClash", (Object)newName, (Object)resource.getPackageName()));
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem checkParameters() {
        ExtractSuperClassRefactoring.MemberInfo[] members = this.refactoring.getMembers();
        this.fireProgressListenerStart(2, members.length);
        try {
            Problem problems = null;
            for (int i = 0; i < members.length; ++i) {
                MultipartId ifcName;
                RefFeatured parent;
                NamedElement member = members[i].member;
                Object cls = member instanceof Feature ? ((Feature)member).getDeclaringClass() : (!((parent = (ifcName = (MultipartId)member).refImmediateComposite()) instanceof JavaClass) ? null : (!((JavaClass)parent).getInterfaceNames().contains(ifcName) ? null : (ClassDefinition)parent));
                if (!this.refactoring.getSourceType().equals(cls)) {
                    Problem problem = ExtractSuperClassRefactoringPlugin.createProblem(problems, true, NbBundle.getMessage((Class)ExtractSuperClassRefactoringPlugin.class, (String)"ERR_ExtractSC_IllegalMember", (Object)member.getName()));
                    return problem;
                }
                this.fireProgressListenerStep();
            }
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        ExtractSuperClassRefactoring.MemberInfo[] members = this.refactoring.getMembers();
        NamedElement[] membs = new NamedElement[members.length];
        for (int x = 0; x < members.length; ++x) {
            membs[x] = members[x].member;
        }
        List typeParams = ExtractInterfaceRefactoringPlugin.findUsedGenericTypes(membs, this.refactoring.getSourceType());
        boolean makeAbstract = Modifier.isAbstract(this.refactoring.getSourceType().getModifiers());
        for (int i = 0; i < members.length && !makeAbstract; ++i) {
            if (!members[i].makeAbstract) continue;
            makeAbstract = true;
        }
        CreateSCElement createSCElement = new CreateSCElement(this.refactoring.getSourceType().getResource(), this.refactoring.getSuperClassName(), makeAbstract, typeParams);
        refactoringElements.add(this.refactoring, createSCElement);
        String superClassName = this.refactoring.getSourceType().getSuperClass().getName();
        refactoringElements.add(this.refactoring, new AddExtendsElement(this.refactoring.getSourceType(), this.refactoring.getSuperClassName(), typeParams));
        if (!"java.lang.Object".equals(superClassName)) {
            refactoringElements.add(this.refactoring, new AddExtendsElement(createSCElement, superClassName));
        }
        for (int i = 0; i < members.length; ++i) {
            if (members[i].makeAbstract) {
                refactoringElements.add(this.refactoring, new AddAbstractMethodElement((Method)members[i].member, createSCElement, 0));
                continue;
            }
            refactoringElements.add(this.refactoring, new MoveMemberElement(members[i].member, createSCElement, 0));
        }
        return null;
    }

    private static class AddExtendsElement
    extends SimpleRefactoringElementImpl {
        private final CreateSCElement element;
        private final String text;
        private JavaClass sourceType;
        private final List typeParams;
        private String scName;

        AddExtendsElement(JavaClass sourceType, String scName, List typeParams) {
            this(sourceType, null, scName, typeParams);
        }

        AddExtendsElement(CreateSCElement element, String scName) {
            this(null, element, scName, null);
        }

        private AddExtendsElement(JavaClass sourceType, CreateSCElement element, String scName, List typeParams) {
            this.sourceType = sourceType;
            this.element = element;
            this.scName = scName;
            this.typeParams = typeParams;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin = ExtractSuperClassRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.ExtractInterfaceRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin), (String)"TXT_ExtractSC_AddExtends", (Object)scName);
        }

        public void performChange() {
            MultipartId mpi;
            if (this.sourceType == null) {
                this.sourceType = this.element.getNewSuperClass();
                mpi = JavaModelUtil.resolveImportsForClass((Element)this.sourceType, (JavaClass)((JavaClass)JavaModel.getDefaultExtent().getType().resolve(this.scName)));
            } else {
                JavaModelPackage extent = (JavaModelPackage)this.sourceType.refImmediatePackage();
                mpi = extent.getMultipartId().createMultipartId(this.scName, null, null);
            }
            if (this.typeParams != null && this.typeParams.size() > 0) {
                List typeArgs = mpi.getTypeArguments();
                MultipartIdClass idProxy = ((JavaModelPackage)this.sourceType.refImmediatePackage()).getMultipartId();
                Iterator iter = this.typeParams.iterator();
                while (iter.hasNext()) {
                    typeArgs.add(idProxy.createMultipartId(((TypeParameter)iter.next()).getName(), null, null));
                }
            }
            this.sourceType.setSuperClassName(mpi);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return this.sourceType == null ? this.element.getParentFile() : JavaMetamodel.getManager().getFileObject(this.sourceType.getResource());
        }

        public Element getJavaElement() {
            return this.sourceType == null ? this.element.getJavaElement() : this.sourceType;
        }

        public PositionBounds getPosition() {
            return this.sourceType == null ? this.element.getPosition() : JavaMetamodel.getManager().getElementPosition((Element)this.sourceType);
        }
    }

    private static class MoveMemberElement
    extends SimpleRefactoringElementImpl {
        private final NamedElement elementToMove;
        private final CreateSCElement element;
        private final int newModifiers;
        private final String text;

        MoveMemberElement(NamedElement elementToMove, CreateSCElement element, int newModifiers) {
            this.elementToMove = elementToMove;
            this.element = element;
            this.newModifiers = newModifiers;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$ExtractSuperClassRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$ExtractSuperClassRefactoringPlugin = ExtractSuperClassRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.ExtractSuperClassRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$ExtractSuperClassRefactoringPlugin), (String)"TXT_ExtractSC_Member", (Object)UIUtilities.getDisplayText(elementToMove));
        }

        public void performChange() {
            Element parent = (Element)this.elementToMove.refImmediateComposite();
            parent.replaceChild((Element)this.elementToMove, null);
            if (this.elementToMove instanceof MultipartId) {
                this.element.getNewSuperClass().getInterfaceNames().add(JavaModelUtil.resolveImportsForClass((Element)this.element.getNewSuperClass(), (JavaClass)((JavaClass)((MultipartId)this.elementToMove).getElement())));
                this.elementToMove.refDelete();
            } else {
                Feature feature = (Feature)this.elementToMove;
                if (this.newModifiers != 0) {
                    feature.setModifiers(this.newModifiers);
                }
                this.element.getNewSuperClass().getContents().add(this.elementToMove);
                ((MetadataElement)this.elementToMove).fixImports((Element)this.element.getNewSuperClass(), (Element)this.elementToMove);
            }
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.elementToMove.getResource());
        }

        public Element getJavaElement() {
            return JavaModelUtil.getDeclaringFeature((Element)this.elementToMove);
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.elementToMove);
        }
    }

    private static class AddAbstractMethodElement
    extends SimpleRefactoringElementImpl {
        private final Method methodToAdd;
        private final CreateSCElement element;
        private final int newModifiers;
        private final String text;

        AddAbstractMethodElement(Method methodToAdd, CreateSCElement element, int newModifiers) {
            this.methodToAdd = methodToAdd;
            this.element = element;
            this.newModifiers = newModifiers;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$ExtractSuperClassRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$ExtractSuperClassRefactoringPlugin = ExtractSuperClassRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.ExtractSuperClassRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$ExtractSuperClassRefactoringPlugin), (String)"TXT_ExtractSC_Method", (Object)UIUtilities.getDisplayText((NamedElement)methodToAdd));
        }

        public void performChange() {
            if (this.element.getNewSuperClass() == null) {
                return;
            }
            JavaModelPackage extent = (JavaModelPackage)this.element.getNewSuperClass().refImmediatePackage();
            Method newMethod = extent.getMethod().createMethod(this.methodToAdd.getName(), Utilities.duplicateList(this.methodToAdd.getAnnotations(), extent), (this.newModifiers == 0 ? this.methodToAdd.getModifiers() : this.newModifiers) | 0x400, this.methodToAdd.getJavadocText(), null, null, null, Utilities.duplicateList(this.methodToAdd.getTypeParameters(), extent), Utilities.duplicateList(this.methodToAdd.getParameters(), extent), Utilities.duplicateList(this.methodToAdd.getExceptionNames(), extent), (TypeReference)((MetadataElement)this.methodToAdd.getTypeName()).duplicate(extent), this.methodToAdd.getDimCount());
            this.element.getNewSuperClass().getContents().add(newMethod);
            ((MetadataElement)newMethod).fixImports((Element)this.element.getNewSuperClass(), (Element)this.methodToAdd);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.methodToAdd.getResource());
        }

        public Element getJavaElement() {
            return this.methodToAdd;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.methodToAdd);
        }
    }

    private static class CreateSCElement
    extends SimpleRefactoringElementImpl {
        private final String scName;
        private final Resource source;
        private final List typeParams;
        private final String text;
        private final boolean makeAbstract;
        private JavaClass newSC = null;

        CreateSCElement(Resource source, String scName, boolean makeAbstract, List typeParams) {
            this.source = source;
            this.scName = scName;
            this.typeParams = typeParams;
            this.makeAbstract = makeAbstract;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin = ExtractSuperClassRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.ExtractInterfaceRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin), (String)"TXT_ExtractSC_CreateSC", (Object)scName);
        }

        public void performChange() {
            ExternalChange ec = new ExternalChange(){
                private FileSystem fs;
                private String newSCName;
                private String folderName;

                public void performExternalChange() {
                    try {
                        FileObject folderFO;
                        FileObject tempFO = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Classes/Class.java");
                        if (this.fs == null) {
                            FileObject sourceFO = JavaModel.getFileObject((Resource)CreateSCElement.this.source);
                            folderFO = sourceFO.getParent();
                            this.folderName = folderFO.getPath();
                            this.fs = folderFO.getFileSystem();
                        } else {
                            folderFO = this.fs.findResource(this.folderName);
                        }
                        DataFolder folder = (DataFolder)DataObject.find((FileObject)folderFO);
                        DataObject template = DataObject.find((FileObject)tempFO);
                        DataObject newSCDO = template.createFromTemplate(folder, CreateSCElement.this.scName);
                        UndoWatcher.watch(newSCDO);
                        FileObject newSCFO = newSCDO.getPrimaryFile();
                        this.newSCName = newSCFO.getPath();
                        CreateSCElement.this.newSC = (JavaClass)JavaMetamodel.getManager().getResource(newSCFO).getClassifiers().iterator().next();
                    }
                    catch (DataObjectNotFoundException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }

                public void undoExternalChange() {
                    try {
                        FileObject newSCFO = this.fs.findResource(this.newSCName);
                        DataObject newSCDO = DataObject.find((FileObject)newSCFO);
                        newSCDO.delete();
                    }
                    catch (DataObjectNotFoundException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            };
            ec.performExternalChange();
            JavaMetamodel.getManager().registerUndoElement(ec);
            if (this.makeAbstract) {
                this.newSC.setModifiers(this.newSC.getModifiers() | 0x400);
            }
            List scTypeParams = this.newSC.getTypeParameters();
            Iterator iter = this.typeParams.iterator();
            while (iter.hasNext()) {
                scTypeParams.add(((TypeParameter)iter.next()).duplicate());
            }
        }

        JavaClass getNewSuperClass() {
            return this.newSC;
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaModel.getFileObject((Resource)this.source).getParent();
        }

        public Element getJavaElement() {
            return null;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

