/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.classpath.Util;

public final class UseSuperTypeRefactoring
extends AbstractRefactoring {
    private final Element subType;
    private JavaClass superType;
    private boolean searchInComments;
    private JavaClass[] candidateSuperTypes;

    public UseSuperTypeRefactoring(Element javaClass) {
        this.subType = javaClass;
        this.candidateSuperTypes = this.deriveSuperTypes(this.subType);
    }

    protected void setClassPath() {
        Util.setDefaultClassPath();
    }

    public Element getTypeElement() {
        return this.subType;
    }

    public void setTargetSuperType(JavaClass superClass) {
        this.superType = superClass;
    }

    public JavaClass getTargetSuperType() {
        return this.superType;
    }

    public JavaClass[] getCandidateSuperTypes() {
        return this.candidateSuperTypes;
    }

    private JavaClass[] deriveSuperTypes(Element subType) {
        if (!(subType instanceof JavaClass)) {
            return new JavaClass[0];
        }
        JavaClass subTypeClass = (JavaClass)subType;
        HashSet<JavaClass> candidateSuperTypeList = new HashSet<JavaClass>();
        List interfaceList = subTypeClass.getInterfaces();
        this.addChangedTypes(candidateSuperTypeList, interfaceList);
        JavaClass tempType = subTypeClass;
        while ((tempType = tempType.getSuperClass()) != null) {
            if (tempType instanceof ParameterizedType) {
                tempType = ((ParameterizedType)tempType).getDefinition();
            }
            candidateSuperTypeList.add(tempType);
            List superInterfaces = tempType.getInterfaces();
            if (superInterfaces == null || superInterfaces.size() <= 0) continue;
            this.addChangedTypes(candidateSuperTypeList, superInterfaces);
        }
        JavaClass[] superTypes = candidateSuperTypeList.toArray(new JavaClass[0]);
        return superTypes;
    }

    private void addChangedTypes(Collection candidateSuperTypeList, Collection javaClassList) {
        Iterator interfacesIterator = javaClassList.iterator();
        while (interfacesIterator.hasNext()) {
            JavaClass superClass = (JavaClass)interfacesIterator.next();
            if (superClass instanceof ParameterizedType) {
                superClass = ((ParameterizedType)superClass).getDefinition();
            }
            candidateSuperTypeList.add(superClass);
        }
    }
}

