/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import java.io.IOException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

public class CommentElement
extends SimpleRefactoringElementImpl {
    Resource resource;
    Element javaElement;
    int textoffset;
    String text;
    private String plainText;
    private PositionBounds bounds = null;
    private String htmlText;

    public CommentElement(int offset, String txt, Resource rsc) {
        this.textoffset = offset;
        this.text = txt;
        this.resource = rsc;
        this.computeText();
    }

    public String getDisplayText() {
        return "// " + this.htmlText;
    }

    public Element getJavaElement() {
        if (this.javaElement == null) {
            this.javaElement = this.resource.getElementByOffset(this.textoffset);
            while (!(this.javaElement instanceof Feature) && !(this.javaElement instanceof Resource)) {
                this.javaElement = (Element)this.javaElement.refImmediateComposite();
            }
        }
        return this.javaElement;
    }

    public FileObject getParentFile() {
        return JavaModel.getFileObject((Resource)this.resource);
    }

    public PositionBounds getPosition() {
        if (this.bounds == null) {
            String commentText = this.resource.getSourceText();
            int lineNumber = -1;
            int column = 0;
            DataObject dobj = JavaMetamodel.getManager().getDataObject(this.resource);
            EditorCookie editorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
            StyledDocument doc = null;
            try {
                doc = editorCookie.openDocument();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return this.bounds;
            }
            DataEditorSupport support = (DataEditorSupport)dobj.getCookie(EditorCookie.class);
            for (int offset = 0; offset < this.textoffset; ++offset) {
                column = this.textoffset - offset;
                if ((offset = commentText.indexOf(10, offset)) == -1) break;
                ++lineNumber;
            }
            int documentOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)lineNumber) + column;
            PositionRef start = support.createPositionRef(documentOffset, Position.Bias.Forward);
            PositionRef end = support.createPositionRef(documentOffset + this.text.length(), Position.Bias.Forward);
            this.bounds = new PositionBounds(start, end);
        }
        return this.bounds;
    }

    public String getText() {
        return this.plainText;
    }

    public void performChange() {
    }

    private void computeText() {
        String commentText = this.resource.getSourceText();
        int start = commentText.lastIndexOf(10, this.textoffset);
        int end = commentText.indexOf(10, this.textoffset);
        StringBuffer htmlBuffer = new StringBuffer();
        if (end == -1) {
            end = commentText.length();
        }
        htmlBuffer.append("<i>");
        htmlBuffer.append(CheckUtils.htmlize(commentText.substring(start + 1, this.textoffset)));
        htmlBuffer.append("<b>");
        htmlBuffer.append(commentText.substring(this.textoffset, this.textoffset + this.text.length()));
        htmlBuffer.append("</b>");
        htmlBuffer.append(CheckUtils.trimToEnd(CheckUtils.htmlize(commentText.substring(this.textoffset + this.text.length(), end))));
        htmlBuffer.append("</i>");
        this.htmlText = htmlBuffer.toString();
        this.plainText = commentText.substring(start + 1, end);
    }
}

