/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public class ColorModel {
    static final String ALL_LANGUAGES = NbBundle.getMessage((Class)ColorModel.class, (String)"CTL_All_Languages");
    static final String HIGHLIGHTING_LANGUAGE = "Highlighting";
    private EditorSettings editorSettings = EditorSettings.getDefault();
    private Map languageToMimeType;
    private Set hiddenCategories = new HashSet();

    public Set getProfiles() {
        return this.editorSettings.getFontColorProfiles();
    }

    public String getCurrentProfile() {
        return this.editorSettings.getCurrentFontColorProfile();
    }

    public boolean isCustomProfile(String profile) {
        return this.editorSettings.isCustomFontColorProfile(profile);
    }

    public void setCurrentProfile(String profile) {
        this.editorSettings.setCurrentFontColorProfile(profile);
    }

    public Collection getAnnotations(String profile) {
        Iterator it = AnnotationTypes.getTypes().getAnnotationTypeNames();
        ArrayList<SimpleAttributeSet> annotations = new ArrayList<SimpleAttributeSet>();
        while (it.hasNext()) {
            String name = (String)it.next();
            AnnotationType annotationType = AnnotationTypes.getTypes().getType(name);
            if (!annotationType.isVisible()) continue;
            URL iconURL = annotationType.getGlyph();
            Image image = null;
            image = iconURL.getProtocol().equals("nbresloc") ? org.openide.util.Utilities.loadImage((String)iconURL.getPath().substring(1)) : Toolkit.getDefaultToolkit().getImage(iconURL);
            SimpleAttributeSet category = new SimpleAttributeSet();
            String description = annotationType.getDescription();
            if (description == null) continue;
            category.addAttribute(EditorStyleConstants.DisplayName, description);
            category.addAttribute(StyleConstants.NameAttribute, annotationType.getDescription());
            if (image != null) {
                category.addAttribute("icon", new ImageIcon(image));
            }
            if (annotationType.isUseHighlightColor()) {
                category.addAttribute(StyleConstants.Background, annotationType.getHighlight());
            }
            if (!annotationType.isInheritForegroundColor()) {
                category.addAttribute(StyleConstants.Foreground, annotationType.getForegroundColor());
            }
            if (annotationType.isUseWaveUnderlineColor()) {
                category.addAttribute(EditorStyleConstants.WaveUnderlineColor, annotationType.getWaveUnderlineColor());
            }
            category.addAttribute("annotationType", annotationType);
            annotations.add(category);
        }
        return annotations;
    }

    public void setAnnotations(String profile, Collection annotations) {
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            AttributeSet category = (AttributeSet)it.next();
            AnnotationType annotationType = (AnnotationType)category.getAttribute("annotationType");
            if (category.isDefined(StyleConstants.Background)) {
                annotationType.setUseHighlightColor(true);
                annotationType.setHighlight((Color)category.getAttribute(StyleConstants.Background));
            } else {
                annotationType.setUseHighlightColor(false);
            }
            if (category.isDefined(StyleConstants.Foreground)) {
                annotationType.setInheritForegroundColor(false);
                annotationType.setForegroundColor((Color)category.getAttribute(StyleConstants.Foreground));
            } else {
                annotationType.setInheritForegroundColor(true);
            }
            if (category.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                annotationType.setUseWaveUnderlineColor(true);
                annotationType.setWaveUnderlineColor((Color)category.getAttribute(EditorStyleConstants.WaveUnderlineColor));
                continue;
            }
            annotationType.setUseWaveUnderlineColor(false);
        }
    }

    public Collection getHighlightings(String profile) {
        Collection r = this.editorSettings.getHighlightings(profile).values();
        if (r == null) {
            return null;
        }
        return this.hideDummyCategories(r);
    }

    public Collection getHighlightingDefaults(String profile) {
        Collection r = this.editorSettings.getHighlightingDefaults(profile).values();
        if (r == null) {
            return null;
        }
        return this.hideDummyCategories(r);
    }

    public void setHighlightings(String profile, Collection highlihgtings) {
        this.editorSettings.setHighlightings(profile, ColorModel.toMap(highlihgtings));
    }

    public Set getLanguages() {
        return this.getLanguageToMimeTypeMap().keySet();
    }

    public Collection getCategories(String profile, String language) {
        if (language.equals(ALL_LANGUAGES)) {
            return this.editorSettings.getDefaultFontColors(profile);
        }
        String mimeType = this.getMimeType(language);
        FontColorSettingsFactory fcs = EditorSettings.getDefault().getFontColorSettings(new String[]{mimeType});
        return fcs.getAllFontColors(profile);
    }

    public Collection getDefaults(String profile, String language) {
        if (language.equals(ALL_LANGUAGES)) {
            return this.editorSettings.getDefaultFontColorDefaults(profile);
        }
        String mimeType = this.getMimeType(language);
        FontColorSettingsFactory fcs = EditorSettings.getDefault().getFontColorSettings(new String[]{mimeType});
        return fcs.getAllFontColorDefaults(profile);
    }

    public void setCategories(String profile, String language, Collection categories) {
        if (language.equals(ALL_LANGUAGES)) {
            this.editorSettings.setDefaultFontColors(profile, categories);
            return;
        }
        String mimeType = this.getMimeType(language);
        if (mimeType == null) {
            if (System.getProperty("org.netbeans.optionsDialog") != null) {
                System.out.println("ColorModelImpl.setCategories - unknown language " + language);
            }
            return;
        }
        FontColorSettingsFactory fcs = EditorSettings.getDefault().getFontColorSettings(new String[]{mimeType});
        fcs.setAllFontColors(profile, categories);
    }

    public Component getEditorPreviewComponent() {
        return new Preview(HIGHLIGHTING_LANGUAGE);
    }

    public Component getSyntaxColoringPreviewComponent(String language) {
        return new Preview(language);
    }

    private String getMimeType(String language) {
        return (String)this.getLanguageToMimeTypeMap().get(language);
    }

    private Map getLanguageToMimeTypeMap() {
        if (this.languageToMimeType == null) {
            this.languageToMimeType = new HashMap();
            Set mimeTypes = this.editorSettings.getMimeTypes();
            Iterator it = mimeTypes.iterator();
            while (it.hasNext()) {
                String mimeType = (String)it.next();
                this.languageToMimeType.put(this.editorSettings.getLanguageName(mimeType), mimeType);
            }
            this.languageToMimeType.put(ALL_LANGUAGES, "Defaults");
        }
        return this.languageToMimeType;
    }

    private Collection hideDummyCategories(Collection categories) {
        ArrayList<AttributeSet> result = new ArrayList<AttributeSet>();
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            AttributeSet as = (AttributeSet)it.next();
            if (this.hiddenCategories.contains(as.getAttribute(StyleConstants.NameAttribute))) continue;
            result.add(as);
        }
        return result;
    }

    private static Map toMap(Collection categories) {
        if (categories == null) {
            return null;
        }
        HashMap<Object, AttributeSet> result = new HashMap<Object, AttributeSet>();
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            AttributeSet as = (AttributeSet)it.next();
            result.put(as.getAttribute(StyleConstants.NameAttribute), as);
        }
        return result;
    }

    class Preview
    extends JPanel {
        static final String PROP_CURRENT_ELEMENT = "currentAElement";
        private JEditorPane editorPane;
        private FontColorSettingsFactory fontColorSettings;
        private String currentLanguage;

        Preview(final String language) {
            super(new BorderLayout());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorUI editorUI;
                    Preview.this.editorPane = new JEditorPane();
                    Preview.this.updateMimeType(language);
                    if (language == ColorModel.HIGHLIGHTING_LANGUAGE && (editorUI = Utilities.getEditorUI((JTextComponent)Preview.this.editorPane)) != null) {
                        editorUI.setLineNumberEnabled(true);
                        editorUI.getExtComponent();
                        Preview.this.add((Component)editorUI.getExtComponent(), "Center");
                        return;
                    }
                    Preview.this.add((Component)Preview.this.editorPane, "Center");
                }
            });
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void setParameters(final String language, final Collection defaults, final Collection highlightings, final Collection syntaxColorings) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String internalMimeType = null;
                    if (!language.equals(Preview.this.currentLanguage)) {
                        Preview.this.updateMimeType(language);
                        Preview.this.currentLanguage = language;
                        internalMimeType = Preview.this.languageToInternalMimeType(language);
                        Preview.this.fontColorSettings = EditorSettings.getDefault().getFontColorSettings(new String[]{internalMimeType});
                    }
                    if (internalMimeType == null) {
                        internalMimeType = Preview.this.languageToInternalMimeType(language);
                    }
                    if (defaults != null) {
                        ColorModel.this.editorSettings.setDefaultFontColors("test" + ColorModel.this.hashCode(), defaults);
                    }
                    if (highlightings != null) {
                        ColorModel.this.editorSettings.setHighlightings("test" + ColorModel.this.hashCode(), ColorModel.toMap(highlightings));
                    }
                    if (syntaxColorings != null) {
                        Preview.this.fontColorSettings.setAllFontColors("test" + ColorModel.this.hashCode(), syntaxColorings);
                    }
                }
            });
        }

        private void updateMimeType(String language) {
            String internalMimeType = this.languageToInternalMimeType(language);
            Document document = this.editorPane.getDocument();
            document.putProperty("mimeType", internalMimeType);
            this.editorPane.setContentType(internalMimeType);
            document = this.editorPane.getDocument();
            document.putProperty("mimeType", internalMimeType);
            this.editorPane.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    int position = e.getDot();
                    EditorUI editorUI = Utilities.getEditorUI((JTextComponent)Preview.this.editorPane);
                    if (editorUI == null) {
                        return;
                    }
                    SyntaxSupport ss = Utilities.getSyntaxSupport((JTextComponent)editorUI.getComponent());
                    if (!(ss instanceof ExtSyntaxSupport)) {
                        return;
                    }
                    try {
                        TokenItem tokenItem = ((ExtSyntaxSupport)ss).getTokenChain(position, position + 1);
                        if (tokenItem == null) {
                            return;
                        }
                        String elementName = tokenItem.getTokenContextPath().getNamePrefix();
                        elementName = tokenItem.getTokenID().getCategory() != null ? elementName + tokenItem.getTokenID().getCategory().getName() : elementName + tokenItem.getTokenID().getName();
                        Preview.this.firePropertyChange(Preview.PROP_CURRENT_ELEMENT, null, elementName);
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.editorPane.setEnabled(false);
            InputStream is = this.loadPreviewExample(language);
            if (is == null) {
                is = this.loadPreviewExample("Java");
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            StringBuffer sb = new StringBuffer();
            try {
                String line = r.readLine();
                while (line != null) {
                    sb.append(line).append('\n');
                    line = r.readLine();
                }
                this.editorPane.setText(new String(sb));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        private InputStream loadPreviewExample(String language) {
            String mimeType = ColorModel.this.getMimeType(language);
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject exampleFile = fs.findResource("OptionsDialog/PreviewExamples/" + mimeType);
            try {
                return exampleFile != null ? exampleFile.getInputStream() : null;
            }
            catch (FileNotFoundException fnfe) {
                return null;
            }
        }

        private String languageToInternalMimeType(String language) {
            String mimeType = language == ColorModel.HIGHLIGHTING_LANGUAGE || language == ALL_LANGUAGES ? "text/x-java" : ColorModel.this.getMimeType(language);
            return "test" + ColorModel.this.hashCode() + "_" + mimeType;
        }
    }
}

