/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.execution.NbClassLoader;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

class ClassLoaderSupport
extends NbClassLoader
implements FileChangeListener,
PropertyChangeListener {
    private FileChangeListener listener;
    private PropertyChangeListener propListener;
    private static PermissionCollection allPermission;
    private static boolean firstTime;
    private ClassPath classPath;

    public static ClassLoader create(ClassPath cp) {
        try {
            return new ClassLoaderSupport(cp);
        }
        catch (FileStateInvalidException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ClassLoaderSupport(ClassPath cp) throws FileStateInvalidException {
        super(cp.getRoots(), ClassLoader.getSystemClassLoader(), null);
        this.classPath = cp;
        this.setDefaultPermissions(ClassLoaderSupport.getAllPermissions());
        this.listener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        this.propListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);
        cp.addPropertyChangeListener(this.propListener);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String resName;
        FileObject fo;
        Class c = super.findClass(name);
        if (c != null && (fo = this.classPath.findResource(resName = name.replace('.', '/') + ".class")) != null) {
            fo.addFileChangeListener(this.listener);
        }
        return c;
    }

    public URL findResource(String name) {
        FileObject fo;
        URL url = super.findResource(name);
        if (url != null && (fo = this.classPath.findResource(name)) != null) {
            fo.addFileChangeListener(this.listener);
        }
        return url;
    }

    private void test(FileObject fo) {
        this.classPath.resetClassLoader((ClassLoader)((Object)this));
        fo.removeFileChangeListener(this.listener);
    }

    private void reset() {
        this.classPath.resetClassLoader((ClassLoader)((Object)this));
    }

    private void testRemove(FileObject fo) {
        fo.removeFileChangeListener(this.listener);
    }

    public void fileFolderCreated(FileEvent fe) {
        this.testRemove(fe.getFile());
    }

    public void fileDataCreated(FileEvent fe) {
        this.testRemove(fe.getFile());
    }

    public void fileChanged(FileEvent fe) {
        this.test(fe.getFile());
    }

    public void fileDeleted(FileEvent fe) {
        this.test(fe.getFile());
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.test(fe.getFile());
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.testRemove(fe.getFile());
    }

    static synchronized PermissionCollection getAllPermissions() {
        if (allPermission == null) {
            allPermission = new Permissions();
            allPermission.add(new AllPermission());
        }
        return allPermission;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("roots".equals(evt.getPropertyName())) {
            this.reset();
        }
    }

    static {
        firstTime = true;
    }
}

