/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.openide.ErrorManager;
import org.openide.loaders.DataNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class PaletteItemNode
extends FilterNode {
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private String name;
    private String bundleName;
    private String displayNameKey;
    private String className;
    private String tooltipKey;
    private String icon16URL;
    private String icon32URL;
    private String displayName;
    private String description;
    private Image icon16;
    private Image icon32;

    PaletteItemNode(DataNode original, String name, String bundleName, String displayNameKey, String className, String tooltipKey, String icon16URL, String icon32URL, InstanceContent content) {
        super((Node)original, FilterNode.Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)this);
        this.name = name;
        this.bundleName = bundleName;
        this.displayNameKey = displayNameKey;
        this.className = className;
        this.tooltipKey = tooltipKey;
        this.icon16URL = icon16URL;
        this.icon32URL = icon32URL;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this._getDisplayName(this.bundleName, this.displayNameKey, this.className);
        }
        return this.displayName;
    }

    public String getShortDescription() {
        if (this.description == null) {
            this.description = this._getShortDescription(this.bundleName, this.tooltipKey, this.className, this.displayNameKey);
        }
        return this.description;
    }

    public Image getIcon(int type) {
        Image icon = null;
        if (type == 1 || type == 3) {
            if (this.icon16 == null) {
                this.icon16 = this._getIcon(this.icon16URL);
                if (this.icon16 == null) {
                    this.icon16 = Utilities.loadImage((String)"org/netbeans/modules/palette/resources/unknown16.gif");
                }
            }
            icon = this.icon16;
        } else if (type == 2 || type == 4) {
            if (this.icon32 == null) {
                this.icon32 = this._getIcon(this.icon32URL);
                if (this.icon32 == null) {
                    this.icon32 = Utilities.loadImage((String)"org/netbeans/modules/palette/resources/unknown32.gif");
                }
            }
            icon = this.icon32;
        }
        return icon;
    }

    public boolean canRename() {
        return false;
    }

    public Node.PropertySet[] getPropertySets() {
        return NO_PROPERTIES;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable t = ExTransferable.create((Transferable)super.clipboardCopy());
        Lookup lookup = this.getLookup();
        ActiveEditorDrop drop = (ActiveEditorDrop)lookup.lookup(ActiveEditorDrop.class);
        ActiveEditorDropTransferable s = new ActiveEditorDropTransferable(drop);
        t.put((ExTransferable.Single)s);
        return t;
    }

    public Transferable drag() throws IOException {
        Transferable t = this.clipboardCopy();
        return t;
    }

    public String _getDisplayName(String bundleName, String displayNameKey, String instanceName) {
        String displayName = null;
        try {
            displayName = NbBundle.getBundle((String)bundleName).getString(displayNameKey);
            if (displayName == null && displayNameKey != null) {
                displayName = displayNameKey;
            }
            if (displayName == null && instanceName != null && instanceName.trim().length() > 0) {
                int dotIndex = instanceName.lastIndexOf(46);
                displayName = instanceName.substring(dotIndex);
            }
            if (displayName == null) {
                displayName = this.name;
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return displayName == null ? "" : displayName;
    }

    public String _getShortDescription(String bundleName, String tooltipKey, String instanceName, String displayNameKey) {
        String tooltip = null;
        try {
            tooltip = NbBundle.getBundle((String)bundleName).getString(tooltipKey);
            if (tooltip == null && tooltipKey != null) {
                tooltip = tooltipKey;
            }
            if (tooltip == null && instanceName != null && instanceName.trim().length() > 0) {
                int dotIndex = instanceName.indexOf(46);
                tooltip = instanceName.substring(0, dotIndex).replace('-', '.');
            }
            if (tooltip == null) {
                tooltip = this._getDisplayName(bundleName, displayNameKey, instanceName);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return tooltip == null ? "" : tooltip;
    }

    public Image _getIcon(String iconURL) {
        Image icon = null;
        try {
            icon = Utilities.loadImage((String)iconURL);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return icon;
    }

    private static class ActiveEditorDropTransferable
    extends ExTransferable.Single {
        private ActiveEditorDrop drop;

        ActiveEditorDropTransferable(ActiveEditorDrop drop) {
            super(ActiveEditorDrop.FLAVOR);
            this.drop = drop;
        }

        public Object getData() {
            return this.drop;
        }
    }
}

