/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.optional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.StartServer;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.util.WLDebug;
import org.netbeans.modules.j2ee.weblogic9.util.WLTailer;
import org.openide.ErrorManager;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class WLStartServer
extends StartServer {
    private static final int SERVER_CHECK_TIMEOUT = 2000;
    private WLDeploymentManager dm;
    private Process serverProcess;
    private boolean isDebuggable;

    public WLStartServer(DeploymentManager dm) {
        this.dm = (WLDeploymentManager)dm;
    }

    public ProgressObject startDebugging(Target target) {
        if (WLDebug.isEnabled()) {
            WLDebug.notify(((Object)((Object)this)).getClass(), "starting server in debug mode");
        }
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName));
        RequestProcessor.getDefault().post((Runnable)new WLStartDebugRunnable(serverProgress), 0, 5);
        this.isDebuggable = true;
        return serverProgress;
    }

    public boolean isDebuggable(Target target) {
        return this.isDebuggable;
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        return new ServerDebugInfo(this.dm.getHost(), new Integer(this.dm.getInstanceProperties().getProperty("debuggerPort")).intValue());
    }

    public boolean supportsStartDeploymentManager() {
        return this.dm.getInstanceProperties().getProperty("isLocal").equals("true");
    }

    public ProgressObject stopDeploymentManager() {
        if (WLDebug.isEnabled()) {
            WLDebug.notify(((Object)((Object)this)).getClass(), "stopping server!");
        }
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName));
        RequestProcessor.getDefault().post((Runnable)new WLStopRunnable(serverProgress), 0, 5);
        this.isDebuggable = false;
        return serverProgress;
    }

    public ProgressObject startDeploymentManager() {
        if (WLDebug.isEnabled()) {
            WLDebug.notify(((Object)((Object)this)).getClass(), "starting server!");
        }
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName));
        RequestProcessor.getDefault().post((Runnable)new WLStartRunnable(serverProgress), 0, 5);
        this.isDebuggable = false;
        return serverProgress;
    }

    public boolean needsStartForTargetList() {
        return true;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForAdminConfig() {
        return true;
    }

    public boolean isRunning() {
        return this.isRunning(true);
    }

    public boolean isRunning(boolean checkResponse) {
        block4: {
            Process proc = this.dm.getServerProcess();
            if (proc != null) {
                try {
                    proc.exitValue();
                    return false;
                }
                catch (IllegalThreadStateException e) {
                    if (checkResponse) break block4;
                    return true;
                }
            }
        }
        if (checkResponse) {
            String host = this.dm.getHost();
            int port = new Integer(this.dm.getPort());
            return WLStartServer.ping(host, port, 2000);
        }
        return false;
    }

    private boolean isStopped() {
        int port;
        Process proc = this.dm.getServerProcess();
        if (proc != null) {
            try {
                proc.exitValue();
                return true;
            }
            catch (IllegalThreadStateException e) {
                return false;
            }
        }
        String host = this.dm.getHost();
        return !WLStartServer.ping(host, port = new Integer(this.dm.getPort()).intValue(), 2000);
    }

    /*
     * Exception decompiling
     */
    public static boolean ping(String host, int port, int timeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String[] properties2StringArray(Properties properties) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            list.add(key + "=" + properties.getProperty(key));
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean supportsStartDebugging(Target target) {
        return this.supportsStartDeploymentManager();
    }

    private static class WLDeploymentStatus
    implements DeploymentStatus {
        private ActionType action;
        private CommandType command;
        private StateType state;
        private String message;

        public WLDeploymentStatus(ActionType action, CommandType command, StateType state, String message) {
            this.action = action;
            this.command = command;
            this.state = state;
            this.message = message;
        }

        public ActionType getAction() {
            return this.action;
        }

        public CommandType getCommand() {
            return this.command;
        }

        public String getMessage() {
            return this.message;
        }

        public StateType getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return StateType.COMPLETED.equals(this.state);
        }

        public boolean isFailed() {
            return StateType.FAILED.equals(this.state);
        }

        public boolean isRunning() {
            return StateType.RUNNING.equals(this.state);
        }
    }

    private static class WLServerProgress
    implements ProgressObject {
        private Vector listeners = new Vector();
        private DeploymentStatus deploymentStatus;
        private Object source;

        public WLServerProgress(Object source) {
            this.source = source;
        }

        public void notifyStart(StateType state, String message) {
            this.notify(new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, state, message));
        }

        public void notifyStop(StateType state, String message) {
            this.notify(new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, state, message));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(DeploymentStatus deploymentStatus) {
            ProgressEvent evt = new ProgressEvent(this.source, null, deploymentStatus);
            this.deploymentStatus = deploymentStatus;
            Vector targets = null;
            WLServerProgress wLServerProgress = this;
            synchronized (wLServerProgress) {
                if (this.listeners != null) {
                    targets = (Vector)this.listeners.clone();
                }
            }
            if (targets != null) {
                for (int i = 0; i < targets.size(); ++i) {
                    ProgressListener target = (ProgressListener)targets.elementAt(i);
                    target.handleProgressEvent(evt);
                }
            }
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.listeners.remove(progressListener);
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.listeners.add(progressListener);
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return new TargetModuleID[0];
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("");
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("");
        }
    }

    private class WLStopRunnable
    implements Runnable {
        private String domainHome;
        private WLServerProgress serverProgress;
        private static final int TIMEOUT = 120000;
        private static final int DELAY = 5000;
        private static final String SHUTDOWN_SH = "stopWebLogic.sh";
        private static final String SHUTDOWN_BAT = "stopWebLogic.cmd";

        public WLStopRunnable(WLServerProgress serverProgress) {
            this.serverProgress = serverProgress;
            this.domainHome = WLStartServer.this.dm.getInstanceProperties().getProperty("domainRoot");
        }

        public void run() {
            try {
                long start = System.currentTimeMillis();
                Process serverProcess = Runtime.getRuntime().exec(this.domainHome + "/bin/" + (Utilities.isWindows() ? SHUTDOWN_BAT : SHUTDOWN_SH));
                new WLTailer(serverProcess.getInputStream(), WLStartServer.this.dm.getURI());
                String serverName = WLStartServer.this.dm.getInstanceProperties().getProperty("displayName");
                while (System.currentTimeMillis() - start < 120000L) {
                    if (WLStartServer.this.isStopped()) {
                        try {
                            serverProcess.waitFor();
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        long pbLagTime = (System.currentTimeMillis() - start) / 4L;
                        try {
                            Thread.sleep(pbLagTime);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        this.serverProgress.notifyStop(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STOPPED", (Object)serverName));
                        return;
                    }
                    this.serverProgress.notifyStop(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {}
                }
                this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_StopServerTimeout"));
                serverProcess.destroy();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
        }
    }

    private class WLStartDebugRunnable
    implements Runnable {
        private String domainHome;
        private String debuggerPort;
        private WLServerProgress serverProgress;
        private static final int TIMEOUT = 900000;
        private static final int DELAY = 5000;
        private static final String STARTUP_SH = "startWebLogic.sh";
        private static final String STARTUP_BAT = "startWebLogic.cmd";

        public WLStartDebugRunnable(WLServerProgress serverProgress) {
            this.serverProgress = serverProgress;
            this.domainHome = WLStartServer.this.dm.getInstanceProperties().getProperty("domainRoot");
            this.debuggerPort = WLStartServer.this.dm.getInstanceProperties().getProperty("debuggerPort");
        }

        public void run() {
            try {
                long start = System.currentTimeMillis();
                File cwd = new File(this.domainHome);
                assert (cwd.isDirectory()) : "Working directory for weblogic does not exist:" + this.domainHome;
                NbProcessDescriptor pd = new NbProcessDescriptor(this.domainHome + "/" + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH), "");
                String[] envp = new String[]{"JAVA_OPTIONS=-Xdebug -Xnoagent -Djava.compiler=none -Xrunjdwp:server=y,suspend=n,transport=dt_socket,address=" + this.debuggerPort};
                WLStartServer.this.serverProcess = pd.exec(null, envp, true, cwd);
                WLStartServer.this.dm.setServerProcess(WLStartServer.this.serverProcess);
                new WLTailer(WLStartServer.this.serverProcess.getInputStream(), WLStartServer.this.dm.getURI());
                String serverName = WLStartServer.this.dm.getInstanceProperties().getProperty("displayName");
                while (System.currentTimeMillis() - start < 900000L) {
                    if (WLStartServer.this.isRunning()) {
                        this.serverProgress.notifyStart(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STARTED", (Object)serverName));
                        return;
                    }
                    this.serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {}
                }
                this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_StartServerTimeout"));
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
        }
    }

    private class WLStartRunnable
    implements Runnable {
        private String domainHome;
        private WLServerProgress serverProgress;
        private static final int TIMEOUT = 900000;
        private static final int DELAY = 5000;
        private static final String STARTUP_SH = "startWebLogic.sh";
        private static final String STARTUP_BAT = "startWebLogic.cmd";

        public WLStartRunnable(WLServerProgress serverProgress) {
            this.serverProgress = serverProgress;
            this.domainHome = WLStartServer.this.dm.getInstanceProperties().getProperty("domainRoot");
        }

        public void run() {
            try {
                long start = System.currentTimeMillis();
                WLStartServer.this.serverProcess = Runtime.getRuntime().exec(this.domainHome + "/" + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH));
                WLStartServer.this.dm.setServerProcess(WLStartServer.this.serverProcess);
                new WLTailer(WLStartServer.this.serverProcess.getInputStream(), WLStartServer.this.dm.getURI());
                String serverName = WLStartServer.this.dm.getInstanceProperties().getProperty("displayName");
                while (System.currentTimeMillis() - start < 900000L) {
                    if (WLStartServer.this.isRunning()) {
                        this.serverProgress.notifyStart(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STARTED", (Object)serverName));
                        return;
                    }
                    this.serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {}
                }
                this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_StartServerTimeout"));
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
        }
    }
}

