/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;

public class URLWait {
    public static boolean waitForUrlReady(URL url, int timeout) {
        boolean success = false;
        String host = url.getHost();
        int port = url.getPort();
        try {
            InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return URLWait.waitForURLConnection(url, timeout, 100);
    }

    private static boolean waitForURLConnection(URL url, int timeout, int retryTime) {
        Connect connect = new Connect(url, retryTime);
        Thread t = new Thread(connect);
        t.start();
        try {
            t.join(timeout);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (t.isAlive()) {
            connect.finishLoop();
            t.interrupt();
        }
        return connect.getStatus();
    }

    private static class Connect
    implements Runnable {
        private String host;
        private URL url;
        private int retryTime;
        private boolean status = false;
        private volatile boolean loop = true;

        public Connect(URL url, int retryTime) {
            this.url = url;
            this.retryTime = retryTime;
            this.host = url.getHost();
        }

        public void finishLoop() {
            this.loop = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InetAddress.getByName(this.host);
            }
            catch (UnknownHostException e) {
                return;
            }
            HttpURLConnection con = null;
            while (this.loop) {
                try {
                    boolean error;
                    con = (HttpURLConnection)this.url.openConnection();
                    int code = con.getResponseCode();
                    boolean bl = error = code == -1 || code > 399 && code < 600;
                    if (!error) {
                        this.status = true;
                        return;
                    }
                }
                catch (IOException ioe) {
                }
                finally {
                    if (con != null) {
                        con.disconnect();
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        boolean getStatus() {
            return this.status;
        }
    }
}

