/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ScrollJavaDocPane;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class HTMLScrollJavaDocPane
extends ScrollJavaDocPane {
    private JToolBar toolbar;
    private ImageIcon iBack;
    private ImageIcon iForward;
    private ImageIcon iShowWeb;
    private JButton bBack;
    private JButton bForward;
    private JButton bShowWeb;
    private static final String BACK = "org/netbeans/modules/html/editor/resources/back.gif";
    private static final String FORWARD = "org/netbeans/modules/html/editor/resources/forward.gif";
    private static final String SHOW_WEB = "org/netbeans/modules/html/editor/resources/htmlView.gif";
    private CompletionJavaDoc cjd;

    public HTMLScrollJavaDocPane(ExtEditorUI extEditorUI) {
        super(extEditorUI);
        this.cjd = extEditorUI.getCompletionJavaDoc();
    }

    protected ImageIcon resolveIcon(String res) {
        return new ImageIcon(Utilities.loadImage((String)res));
    }

    protected void installTitleComponent() {
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setBorder(new EmptyBorder(new Insets(1, 2, 1, 2)));
        this.toolbar.setLayout(new GridBagLayout());
        GridBagConstraints gdc = new GridBagConstraints();
        gdc.gridx = 0;
        gdc.gridy = 0;
        gdc.anchor = 17;
        this.iBack = this.resolveIcon(BACK);
        if (this.iBack != null) {
            this.bBack = new ScrollJavaDocPane.BrowserButton((ScrollJavaDocPane)this, (Icon)this.iBack);
            this.bBack.addMouseListener(new MouseEventListener(this.bBack));
            this.bBack.setEnabled(false);
            this.bBack.setContentAreaFilled(false);
            this.bBack.setMargin(new Insets(0, 0, 0, 0));
            this.bBack.setToolTipText(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("HINT_javadoc_browser_back_button"));
            this.toolbar.add((Component)this.bBack, gdc);
        }
        gdc.gridx = 1;
        gdc.gridy = 0;
        gdc.anchor = 17;
        this.iForward = this.resolveIcon(FORWARD);
        if (this.iForward != null) {
            this.bForward = new ScrollJavaDocPane.BrowserButton((ScrollJavaDocPane)this, (Icon)this.iForward);
            this.bForward.addMouseListener(new MouseEventListener(this.bForward));
            this.bForward.setEnabled(false);
            this.bForward.setContentAreaFilled(false);
            this.bForward.setToolTipText(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("HINT_javadoc_browser_forward_button"));
            this.bForward.setMargin(new Insets(0, 0, 0, 0));
            this.toolbar.add((Component)this.bForward, gdc);
        }
        gdc.gridx = 2;
        gdc.gridy = 0;
        gdc.weightx = 1.0;
        gdc.anchor = 17;
        this.iShowWeb = this.resolveIcon(SHOW_WEB);
        if (this.iShowWeb != null) {
            this.bShowWeb = new ScrollJavaDocPane.BrowserButton((ScrollJavaDocPane)this, (Icon)this.iShowWeb);
            this.bShowWeb.setToolTipText(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("HINT_javadoc_browser_show_web_button"));
            this.bShowWeb.addMouseListener(new MouseEventListener(this.bShowWeb));
            this.bShowWeb.setContentAreaFilled(false);
            this.bShowWeb.setMargin(new Insets(0, 0, 0, 0));
            this.toolbar.add((Component)this.bShowWeb, gdc);
        }
        this.add(this.toolbar);
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.scrollPane.setBounds(r.x, 25, r.width, r.height - 25);
        this.toolbar.setBounds(r.x + 1, 1, r.width - 2, 24);
    }

    public void setForwardEnabled(boolean enable) {
        this.bForward.setEnabled(enable);
    }

    public void setBackEnabled(boolean enable) {
        this.bBack.setEnabled(enable);
    }

    public void setShowWebEnabled(boolean enable) {
        this.bShowWeb.setEnabled(enable);
    }

    class MouseEventListener
    extends MouseAdapter {
        JButton button;

        MouseEventListener(JButton button) {
            this.button = button;
        }

        public void mouseEntered(MouseEvent ev) {
            if (this.button.isEnabled()) {
                this.button.setContentAreaFilled(true);
                this.button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent ev) {
            this.button.setContentAreaFilled(false);
            this.button.setBorderPainted(false);
        }

        public void mouseClicked(MouseEvent evt) {
            if (this.button.equals(HTMLScrollJavaDocPane.this.bBack)) {
                HTMLScrollJavaDocPane.this.cjd.backHistory();
            } else if (this.button.equals(HTMLScrollJavaDocPane.this.bForward)) {
                HTMLScrollJavaDocPane.this.cjd.forwardHistory();
            } else if (this.button.equals(HTMLScrollJavaDocPane.this.bShowWeb)) {
                HTMLScrollJavaDocPane.this.cjd.openInExternalBrowser();
            }
        }
    }
}

