/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class Library {
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_CONTENT = "content";
    private LibraryImplementation impl;
    private List listeners;

    Library(LibraryImplementation impl) {
        this.impl = impl;
        this.impl.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                Library.this.fireChange(propName, evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public List getContent(String volumeType) {
        return this.impl.getContent(volumeType);
    }

    public String getName() {
        return this.impl.getName();
    }

    public String getDescription() {
        return this.getLocalizedString(this.impl.getLocalizingBundle(), this.impl.getDescription());
    }

    public String getDisplayName() {
        return this.getLocalizedString(this.impl.getLocalizingBundle(), this.impl.getName());
    }

    public String getType() {
        return this.impl.getType();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Library) {
            Library peer = (Library)obj;
            return peer.impl.equals(this.impl);
        }
        return false;
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    LibraryImplementation getLibraryImplementation() {
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String propertyName, Object oldValue, Object newValue) {
        Iterator it = null;
        Library library = this;
        synchronized (library) {
            if (this.listeners == null) {
                return;
            }
            it = new ArrayList(this.listeners).iterator();
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        while (it.hasNext()) {
            ((PropertyChangeListener)it.next()).propertyChange(event);
        }
    }

    private String getLocalizedString(String bundleName, String key) {
        ResourceBundle bundle;
        if (key == null) {
            return null;
        }
        if (bundleName == null) {
            return key;
        }
        try {
            bundle = NbBundle.getBundle((String)bundleName);
        }
        catch (MissingResourceException mre) {
            ErrorManager.getDefault().notify(1, (Throwable)mre);
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return key;
        }
    }
}

