/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbfreeform.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.ejbfreeform.EJBProjectGenerator;
import org.netbeans.modules.j2ee.ejbfreeform.ui.EJBLocationsWizardPanel;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class EJBLocationsPanel
extends JPanel
implements HelpCtx.Provider {
    private File baseFolder;
    private File nbProjectFolder;
    private File srcPackagesLocation;
    private AntProjectHelper projectHelper;
    private List serverIDs;
    private ChangeListener listener;
    private DocumentListener documentListener;
    private BigDecimal ejbJarXmlVersion;
    private boolean isNew = false;
    private boolean isNS2 = false;
    private boolean is15 = false;
    private boolean updatingLevels = false;
    private static final String J2EE_SPEC_15_LABEL = NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"TXT_J2EESpecLevel_2");
    private static final String J2EE_SPEC_14_LABEL = NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"TXT_J2EESpecLevel_0");
    private static final String J2EE_SPEC_13_LABEL = NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"TXT_J2EESpecLevel_1");
    private JComboBox j2eeSpecComboBox;
    private JButton jButton1;
    private JButton jButtonEJB;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JTextField jTextFieldConfigFiles;
    private JTextField resourcesTextField;
    private JComboBox serverTypeComboBox;
    private JLabel warningLabel;

    public EJBLocationsPanel(EJBLocationsWizardPanel panel) {
        this.listener = panel;
        this.initComponents();
        this.isNew = true;
        this.initServerInstances();
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                EJBLocationsPanel.this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                EJBLocationsPanel.this.update(e);
            }

            public void changedUpdate(DocumentEvent e) {
                EJBLocationsPanel.this.update(e);
            }
        };
        this.jTextFieldConfigFiles.getDocument().addDocumentListener(this.documentListener);
    }

    public EJBLocationsPanel(EJBLocationsWizardPanel panel, Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
        this(panel);
        List ejbModules;
        this.projectHelper = projectHelper;
        this.setFolders(Util.getProjectLocation((AntProjectHelper)projectHelper, (PropertyEvaluator)projectEvaluator), FileUtil.toFile((FileObject)projectHelper.getProjectDirectory()));
        Element ejbData = aux.getConfigurationFragment("ejb-data", "http://www.netbeans.org/ns/freeform-project-ejb/2", true);
        if (ejbData != null) {
            this.isNS2 = true;
        }
        if ((ejbModules = EJBProjectGenerator.getEJBmodules(projectHelper, aux)) != null) {
            EJBProjectGenerator.EJBModule em = (EJBProjectGenerator.EJBModule)ejbModules.get(0);
            this.is15 = em.j2eeSpecLevel.equals("1.5");
        }
        this.isNew = false;
        this.updateJ2eeLevels();
        if (this.is15) {
            this.serverIDs.remove("GENERIC");
            this.serverTypeComboBox.removeItem(Deployment.getDefault().getServerDisplayName("GENERIC"));
        }
        if (ejbModules != null) {
            EJBProjectGenerator.EJBModule wm = (EJBProjectGenerator.EJBModule)ejbModules.get(0);
            String configFiles = EJBLocationsPanel.getLocationDisplayName(projectEvaluator, this.nbProjectFolder, wm.configFiles);
            String classpath = EJBLocationsPanel.getLocationDisplayName(projectEvaluator, this.nbProjectFolder, wm.classpath);
            String resourceFiles = EJBLocationsPanel.getLocationDisplayName(projectEvaluator, this.nbProjectFolder, projectEvaluator.getProperty("resource.dir"));
            String serverID = projectEvaluator.getProperty("j2ee.server.type");
            this.jTextFieldConfigFiles.setText(configFiles);
            this.resourcesTextField.setText(resourceFiles);
            this.setSrcPackages(classpath);
            if (wm.j2eeSpecLevel.equals("1.5")) {
                this.j2eeSpecComboBox.setSelectedItem(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"TXT_J2EESpecLevel_2"));
            } else if (wm.j2eeSpecLevel.equals("1.4")) {
                this.j2eeSpecComboBox.setSelectedItem(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"TXT_J2EESpecLevel_0"));
            } else {
                this.j2eeSpecComboBox.setSelectedItem(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"TXT_J2EESpecLevel_1"));
            }
            if (serverID != null) {
                this.selectServerID(serverID);
            }
        }
    }

    private void updateJ2eeLevels() {
        Set<String> supportedVersions;
        String prevSelectedItem = (String)this.j2eeSpecComboBox.getSelectedItem();
        int selectedServerIndex = this.serverTypeComboBox.getSelectedIndex();
        if (selectedServerIndex == -1) {
            return;
        }
        String serverID = (String)this.serverIDs.get(selectedServerIndex);
        String servInsID = this.getFirstServerInstanceID(serverID);
        if (servInsID != null) {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(servInsID);
            supportedVersions = j2eePlatform.getSupportedSpecVersions();
        } else {
            supportedVersions = new HashSet<String>();
            supportedVersions.add("1.3");
            supportedVersions.add("1.4");
        }
        this.updatingLevels = true;
        this.j2eeSpecComboBox.removeAllItems();
        if (supportedVersions.contains("1.5") && (this.isNew || this.isNS2)) {
            this.j2eeSpecComboBox.addItem(J2EE_SPEC_15_LABEL);
        }
        if (supportedVersions.contains("1.4") && !this.is15) {
            this.j2eeSpecComboBox.addItem(J2EE_SPEC_14_LABEL);
        }
        if (supportedVersions.contains("1.3") && !this.is15) {
            this.j2eeSpecComboBox.addItem(J2EE_SPEC_13_LABEL);
        }
        if (prevSelectedItem != null) {
            this.j2eeSpecComboBox.setSelectedItem(prevSelectedItem);
        }
        this.updatingLevels = false;
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    private void update(DocumentEvent e) {
        this.setEjbJarXmlJ2eeVersion(EJBLocationsPanel.findEbjJarXml(this.getAsFile(this.jTextFieldConfigFiles.getText())));
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    public static String getLocationDisplayName(PropertyEvaluator evaluator, File base, String val) {
        if (val == null || val.trim().length() <= 0) {
            return "";
        }
        File f = Util.resolveFile((PropertyEvaluator)evaluator, (File)base, (String)val);
        if (f == null) {
            return val;
        }
        String location = f.getAbsolutePath();
        if (CollocationQuery.areCollocated((File)base, (File)f)) {
            location = PropertyUtils.relativizeFile((File)base, (File)f).replace('/', File.separatorChar);
        }
        return location;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(EJBLocationsPanel.class);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldConfigFiles = new JTextField();
        this.jButtonEJB = new JButton();
        this.jLabel5 = new JLabel();
        this.j2eeSpecComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.serverTypeComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.resourcesTextField = new JTextField();
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel();
        this.warningLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(375, 135));
        this.jLabel1.setText(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"LBL_ConfigFilesPanel_Description"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.jTextFieldConfigFiles);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"LBL_ConfigFilesPanel_ConfigFilesLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 11);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 11);
        this.add((Component)this.jTextFieldConfigFiles, gridBagConstraints);
        this.jTextFieldConfigFiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"ACS_LBL_ConfigFilesPanel_ConfigFilesLocation_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonEJB, (String)NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"BTN_BasicProjectInfoPanel_browseAntScript"));
        this.jButtonEJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EJBLocationsPanel.this.jButtonEJBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jButtonEJB, gridBagConstraints);
        this.jButtonEJB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"ACS_LBL_ConfigFilesPanel_ConfigFilesLocationBrowse_A11YDesc"));
        this.jLabel5.setLabelFor(this.j2eeSpecComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"LBL_ConfigFilesPanel_J2EESpecLevel_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 11);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.j2eeSpecComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EJBLocationsPanel.this.j2eeSpecComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.j2eeSpecComboBox, gridBagConstraints);
        this.j2eeSpecComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"ACS_LBL_ConfigFilesPanel_J2EESpecLevel_A11YDesc"));
        this.jLabel3.setLabelFor(this.serverTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"LBL_ConfigFilesPanel_ServerType_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 11);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.serverTypeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                EJBLocationsPanel.this.serverTypeComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.serverTypeComboBox, gridBagConstraints);
        this.serverTypeComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"ACS_LBL_ConfigFilesPanel_ServerType_A11YDesc"));
        this.jLabel6.setLabelFor(this.resourcesTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"LBL_ConfigFilesPanel_Resources_label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 11);
        this.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 11);
        this.add((Component)this.resourcesTextField, gridBagConstraints);
        this.resourcesTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"ACS_LBL_ConfigFilesPanel_ResourceFolder_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"BTN_ConfigFilesPanel_ResourcesBrowse"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EJBLocationsPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"ACS_LBL_ConfigFilesPanel_ResourceFolderBrowse_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.warningLabel.setForeground(new Color(89, 71, 191));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.warningLabel, gridBagConstraints);
    }

    private void j2eeSpecComboBoxActionPerformed(ActionEvent evt) {
        String selectedItem = (String)this.j2eeSpecComboBox.getSelectedItem();
        String warningMessage = null;
        if (!this.updatingLevels && this.listener != null) {
            this.listener.stateChanged(null);
        }
        if (J2EE_SPEC_14_LABEL.equals(selectedItem) && new BigDecimal("2.0").equals(this.ejbJarXmlVersion)) {
            warningMessage = NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"MSG_EjbJarXmlUpdate");
        }
        this.warningLabel.setText(warningMessage);
    }

    private void serverTypeComboBoxItemStateChanged(ItemEvent evt) {
        this.updateJ2eeLevels();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        File resources = this.getResourcesLocation();
        JFileChooser chooser = EJBLocationsPanel.createChooser(resources != null ? resources.getAbsolutePath() : this.baseFolder.getAbsolutePath());
        if (0 == chooser.showOpenDialog(this)) {
            this.setResources(chooser.getSelectedFile());
        }
    }

    private void jButtonEJBActionPerformed(ActionEvent evt) {
        JFileChooser chooser = EJBLocationsPanel.createChooser(this.getConfigFilesLocation().getAbsolutePath());
        if (0 == chooser.showOpenDialog(this)) {
            this.setConfigFiles(chooser.getSelectedFile());
        }
    }

    private static JFileChooser createChooser(String path) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)new File(path));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        return chooser;
    }

    protected List getEJBModules() {
        ArrayList<EJBProjectGenerator.EJBModule> l = new ArrayList<EJBProjectGenerator.EJBModule>();
        EJBProjectGenerator.EJBModule ejbModule = new EJBProjectGenerator.EJBModule();
        ejbModule.configFiles = this.getRelativeLocation(this.getConfigFilesLocation());
        String j2eeLevel = (String)this.j2eeSpecComboBox.getSelectedItem();
        if (j2eeLevel != null) {
            ejbModule.j2eeSpecLevel = j2eeLevel.equals(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"TXT_J2EESpecLevel_2")) ? "1.5" : (j2eeLevel.equals(NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"TXT_J2EESpecLevel_0")) ? "1.4" : "1.3");
        }
        ejbModule.classpath = "";
        l.add(ejbModule);
        return l;
    }

    protected List getJavaSrcFolder() {
        ArrayList<String> l = new ArrayList<String>();
        File sourceLoc = this.getSrcPackagesLocation();
        l.add(this.getRelativeLocation(sourceLoc));
        l.add(sourceLoc.getName());
        return l;
    }

    protected List getEJBSrcFolder() {
        ArrayList<String> l = new ArrayList<String>();
        File webLocation = this.getConfigFilesLocation();
        l.add(this.getRelativeLocation(webLocation));
        l.add(webLocation.getName());
        return l;
    }

    protected List getResourcesFolder() {
        ArrayList<String> l = new ArrayList<String>();
        File resourceLoc = this.getResourcesLocation();
        l.add(resourceLoc != null ? this.getRelativeLocation(resourceLoc) : null);
        l.add(resourceLoc != null ? resourceLoc.getName() : null);
        return l;
    }

    private File getAsFile(String filename) {
        File f = new File(filename.trim());
        return PropertyUtils.resolveFile((File)this.nbProjectFolder, (String)filename);
    }

    public void setFolders(File baseFolder, File nbProjectFolder) {
        this.baseFolder = baseFolder;
        this.nbProjectFolder = nbProjectFolder;
    }

    protected void setConfigFilesField(String path) {
        if (path != null && !path.equals("")) {
            this.setConfigFiles(new File(path));
        } else {
            this.setConfigFiles(path);
        }
    }

    protected void setConfigFiles(String path) {
        this.jTextFieldConfigFiles.setText(path);
    }

    protected void setSrcPackages(String path) {
        this.setSrcPackages(this.getAsFile(path));
    }

    private void setConfigFiles(File file) {
        this.setConfigFiles(this.relativizeFile(file));
    }

    private void setResources(File file) {
        this.resourcesTextField.setText(this.relativizeFile(file));
    }

    protected File getConfigFilesLocation() {
        return this.getAsFile(this.jTextFieldConfigFiles.getText()).getAbsoluteFile();
    }

    protected File getResourcesLocation() {
        String resources = this.resourcesTextField.getText().trim();
        return resources.length() <= 0 ? null : this.getAsFile(this.resourcesTextField.getText()).getAbsoluteFile();
    }

    private void setSrcPackages(File file) {
        this.srcPackagesLocation = file;
    }

    protected File getSrcPackagesLocation() {
        return this.srcPackagesLocation;
    }

    private String relativizeFile(File file) {
        File normalizedFile = FileUtil.normalizeFile((File)file);
        if (CollocationQuery.areCollocated((File)this.nbProjectFolder, (File)file)) {
            return PropertyUtils.relativizeFile((File)this.nbProjectFolder, (File)normalizedFile);
        }
        return normalizedFile.getAbsolutePath();
    }

    private String getRelativeLocation(File location) {
        File normalizedLocation = FileUtil.normalizeFile((File)location);
        return Util.relativizeLocation((File)this.baseFolder, (File)this.nbProjectFolder, (File)normalizedLocation);
    }

    private void initServerInstances() {
        String[] servInstIDs = Deployment.getDefault().getServerInstanceIDs();
        this.serverIDs = new ArrayList();
        for (int i = 0; i < servInstIDs.length; ++i) {
            J2eePlatform j2eePlat = Deployment.getDefault().getJ2eePlatform(servInstIDs[i]);
            String serverID = Deployment.getDefault().getServerID(servInstIDs[i]);
            String servDisplayName = Deployment.getDefault().getServerDisplayName(serverID);
            if (servDisplayName == null || this.serverIDs.contains(serverID) || j2eePlat == null || !j2eePlat.getSupportedModuleTypes().contains(J2eeModule.EJB)) continue;
            this.serverIDs.add(serverID);
            this.serverTypeComboBox.addItem(servDisplayName);
        }
        this.serverIDs.add("GENERIC");
        this.serverTypeComboBox.addItem(Deployment.getDefault().getServerDisplayName("GENERIC"));
        if (this.serverIDs.size() > 0) {
            this.serverTypeComboBox.setSelectedIndex(0);
        } else {
            this.serverTypeComboBox.setEnabled(false);
            this.j2eeSpecComboBox.setEnabled(false);
        }
    }

    private String getFirstServerInstanceID(String serverID) {
        if (serverID == null) {
            return null;
        }
        String[] servInstIDs = Deployment.getDefault().getServerInstanceIDs();
        for (int i = 0; i < servInstIDs.length; ++i) {
            if (serverID != Deployment.getDefault().getServerID(servInstIDs[i])) continue;
            return servInstIDs[i];
        }
        return null;
    }

    public String getSelectedServerID() {
        int idx = this.serverTypeComboBox.getSelectedIndex();
        if (idx == -1) {
            return null;
        }
        String serverID = (String)this.serverIDs.get(idx);
        return serverID;
    }

    private void selectServerID(String serverID) {
        for (int i = 0; i < this.serverIDs.size(); ++i) {
            if (!serverID.equals(this.serverIDs.get(i))) continue;
            this.serverTypeComboBox.setSelectedIndex(i);
            break;
        }
    }

    public String getSelectedJ2eeSpec() {
        Object item = this.j2eeSpecComboBox.getSelectedItem();
        if (item == null) {
            return null;
        }
        if (item.equals(J2EE_SPEC_15_LABEL)) {
            return "1.5";
        }
        if (item.equals(J2EE_SPEC_14_LABEL)) {
            return "1.4";
        }
        return "1.3";
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        File cfLoc = this.getConfigFilesLocation();
        if (this.jTextFieldConfigFiles.getText().equals("") || !cfLoc.isDirectory()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"MSG_NoConfFolder"));
            return false;
        }
        if (this.is15 && this.getSelectedServerID().equals("GENERIC")) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"MSG_NoGENERICServer"));
            return false;
        }
        File[] dds = this.getConfigFilesLocation().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equals("ejb-jar.xml");
            }
        });
        if (dds.length == 0 && !this.getSelectedJ2eeSpec().equals("1.5")) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"MSG_NoEjbJarXml"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    public static FileObject findEbjJarXml(File configFolder) {
        FileObject confFolderFo = FileUtil.toFileObject((File)configFolder);
        FileObject ejbJarXml = null;
        if (confFolderFo != null) {
            ejbJarXml = confFolderFo.getFileObject("ejb-jar.xml");
        }
        return ejbJarXml;
    }

    public static BigDecimal getEjbJarXmlVersion(FileObject ejbJarXml) throws IOException {
        if (ejbJarXml != null) {
            return DDProvider.getDefault().getDDRoot(ejbJarXml).getVersion();
        }
        return null;
    }

    private void setEjbJarXmlJ2eeVersion(FileObject ejbJarXml) {
        try {
            BigDecimal version;
            this.ejbJarXmlVersion = version = EJBLocationsPanel.getEjbJarXmlVersion(ejbJarXml);
            if (version == null) {
                return;
            }
            if (new BigDecimal("2.0").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(J2EE_SPEC_13_LABEL);
            } else if (new BigDecimal("2.1").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(J2EE_SPEC_14_LABEL);
            } else if (new BigDecimal("3.0").equals(version)) {
                this.j2eeSpecComboBox.setSelectedItem(J2EE_SPEC_15_LABEL);
            }
        }
        catch (IOException e) {
            ErrorManager errorManager = ErrorManager.getDefault();
            String message = NbBundle.getMessage((Class)EJBLocationsPanel.class, (String)"MSG_EjbJarXmlCorrupted");
            errorManager.notify(errorManager.annotate((Throwable)e, message));
        }
    }

    public static class Panel
    implements ProjectPropertiesPanel {
        private Project project;
        private AntProjectHelper projectHelper;
        private PropertyEvaluator projectEvaluator;
        private AuxiliaryConfiguration aux;
        private EJBLocationsPanel panel;

        public Panel(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
            this.project = project;
            this.projectHelper = projectHelper;
            this.projectEvaluator = projectEvaluator;
            this.aux = aux;
        }

        public void storeValues() {
            if (this.panel == null) {
                return;
            }
            AuxiliaryConfiguration aux = Util.getAuxiliaryConfiguration((AntProjectHelper)this.projectHelper);
            EJBProjectGenerator.putEJBModules(this.projectHelper, aux, this.panel.getEJBModules());
            EJBProjectGenerator.putServerID(this.projectHelper, this.panel.getSelectedServerID());
            EJBProjectGenerator.putResourceFolder(this.projectHelper, this.panel.getResourcesFolder());
            String j2eeLevel = ((EJBProjectGenerator.EJBModule)this.panel.getEJBModules().get((int)0)).j2eeSpecLevel;
            EJBProjectGenerator.putJ2EELevel(this.projectHelper, j2eeLevel);
            FileObject ejbJarXml = EJBLocationsPanel.findEbjJarXml(this.panel.getConfigFilesLocation());
            try {
                if (j2eeLevel.equals("1.4") && !new BigDecimal("2.1").equals(EJBLocationsPanel.getEjbJarXmlVersion(ejbJarXml))) {
                    EjbJar root = DDProvider.getDefault().getDDRoot(ejbJarXml);
                    root.setVersion(new BigDecimal("2.1"));
                    root.write(ejbJarXml);
                }
            }
            catch (IOException e) {
                ErrorManager errorManager = ErrorManager.getDefault();
                String message = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ejbfreeform$ui$EJBLocationsPanel == null ? (class$org$netbeans$modules$j2ee$ejbfreeform$ui$EJBLocationsPanel = EJBLocationsPanel.class$("org.netbeans.modules.j2ee.ejbfreeform.ui.EJBLocationsPanel")) : class$org$netbeans$modules$j2ee$ejbfreeform$ui$EJBLocationsPanel), (String)"MSG_EjbJarXmlCorrupted");
                errorManager.notify(errorManager.annotate((Throwable)e, message));
            }
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ejbfreeform$ui$EJBLocationsPanel == null ? (class$org$netbeans$modules$j2ee$ejbfreeform$ui$EJBLocationsPanel = EJBLocationsPanel.class$("org.netbeans.modules.j2ee.ejbfreeform.ui.EJBLocationsPanel")) : class$org$netbeans$modules$j2ee$ejbfreeform$ui$EJBLocationsPanel), (String)"LBL_ProjectCustomizer_Category_EJB");
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = new EJBLocationsPanel(null, this.project, this.projectHelper, this.projectEvaluator, this.aux);
            }
            return this.panel;
        }

        public int getPreferredPosition() {
            return 40;
        }
    }
}

