/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.wizard.AddServerInstanceWizard;
import org.netbeans.modules.j2ee.deployment.plugins.api.OptionalDeploymentManagerFactory;
import org.openide.util.NbBundle;

public class ServerChooserVisual
extends JPanel {
    private final List listeners = new ArrayList();
    private AddServerInstanceWizard wizard;
    private HashMap displayNames = new HashMap();
    private JTextField displayNameEditField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JComboBox serverComboBox;

    public ServerChooserVisual() {
        this.initComponents();
        ServerAdapter selected = (ServerAdapter)this.serverComboBox.getSelectedItem();
        if (selected != null) {
            this.fillDisplayName(selected.getServer());
        }
        this.displayNameEditField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ServerChooserVisual.this.displayNameEditFieldUpdate();
            }

            public void removeUpdate(DocumentEvent e) {
                ServerChooserVisual.this.displayNameEditFieldUpdate();
            }

            public void changedUpdate(DocumentEvent e) {
                ServerChooserVisual.this.displayNameEditFieldUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public void read(AddServerInstanceWizard wizard) {
        Object prop;
        if (this.wizard == null) {
            this.wizard = wizard;
        }
        if ((prop = wizard.getProperty("ServInstWizard_displayName")) != null) {
            this.displayNameEditField.setText((String)prop);
        }
    }

    public void store(AddServerInstanceWizard wizard) {
        wizard.putProperty("ServInstWizard_displayName", this.displayNameEditField.getText());
        Object selectedItem = this.serverComboBox.getSelectedItem();
        if (selectedItem != null) {
            wizard.putProperty("ServInstWizard_server", ((ServerAdapter)selectedItem).getServer());
        }
    }

    public boolean isValid() {
        boolean result;
        boolean bl = result = this.isServerValid() && this.isDisplayNameValid();
        if (result) {
            this.wizard.setErrorMessage(null);
        }
        return result;
    }

    private boolean isServerValid() {
        boolean result;
        boolean bl = result = this.serverComboBox.getSelectedItem() != null;
        if (!result) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerChooserVisual.class, (String)"MSG_SCV_ChooseServer"));
        }
        return result;
    }

    private boolean isDisplayNameValid() {
        String trimmed = this.displayNameEditField.getText().trim();
        if (trimmed.length() <= 0) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerChooserVisual.class, (String)"MSG_SCV_DisplayName"));
            return false;
        }
        if (this.getServerInstance(trimmed) != null) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerChooserVisual.class, (String)"MSG_SCV_DisplayNameExists"));
            return false;
        }
        return true;
    }

    private ServerInstance getServerInstance(String displayName) {
        for (ServerInstance instance : ServerRegistry.getInstance().getInstances()) {
            if (instance.getDisplayName().compareToIgnoreCase(displayName) != 0) continue;
            return instance;
        }
        return null;
    }

    private void displayNameEditFieldUpdate() {
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList tempList;
        ChangeEvent event = new ChangeEvent(this);
        List list = this.listeners;
        synchronized (list) {
            tempList = new ArrayList(this.listeners);
        }
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(event);
        }
    }

    private String generateDisplayName(Server server) {
        String name;
        int count = 0;
        do {
            name = server.getDisplayName();
            if (count != 0) {
                name = name + " (" + String.valueOf(count) + ")";
            }
            ++count;
        } while (this.getServerInstance(name) != null);
        return name;
    }

    private void fillDisplayName(Server server) {
        String name = (String)this.displayNames.get(server);
        if (name == null) {
            name = this.generateDisplayName(server);
        }
        this.displayNameEditField.setText(name);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.serverComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.displayNameEditField = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setName(NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_Name"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_NAME"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_DESC"));
        this.jLabel1.setDisplayedMnemonic(NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_Server_mnem").charAt(0));
        this.jLabel1.setLabelFor(this.serverComboBox);
        this.jLabel1.setText(NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_Server"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.serverComboBox.setModel(new ServerModel());
        this.serverComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ServerChooserVisual.this.serverComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.serverComboBox, gridBagConstraints);
        this.serverComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_NAME_Server"));
        this.serverComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_DESC_Server"));
        this.jLabel2.setDisplayedMnemonic(NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_DisplayName_mnem").charAt(0));
        this.jLabel2.setLabelFor(this.displayNameEditField);
        this.jLabel2.setText(NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.displayNameEditField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ServerChooserVisual.this.displayNameEditFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.displayNameEditField, gridBagConstraints);
        this.displayNameEditField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_NAME_DisplayName"));
        this.displayNameEditField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_DESC_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void displayNameEditFieldKeyReleased(KeyEvent evt) {
        ServerAdapter serverAdapter = (ServerAdapter)this.serverComboBox.getSelectedItem();
        if (serverAdapter != null) {
            this.displayNames.put(serverAdapter.getServer(), this.displayNameEditField.getText());
        }
    }

    private void serverComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            Server server = ((ServerAdapter)evt.getItem()).getServer();
            this.fillDisplayName(server);
        }
        this.fireChange();
    }

    private static class ServerAdapter
    implements Comparable {
        private Server server;

        public ServerAdapter(Server server) {
            this.server = server;
        }

        public Server getServer() {
            return this.server;
        }

        public String toString() {
            return this.server.getDisplayName();
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }

    private static class ServerModel
    implements ComboBoxModel {
        private List servers = new ArrayList();
        private ServerAdapter selected;

        public ServerModel() {
            Collection allServers = ServerRegistry.getInstance().getServers();
            for (Server server : allServers) {
                OptionalDeploymentManagerFactory factory = server.getOptionalFactory();
                if (factory == null || factory.getAddInstanceIterator() == null) continue;
                ServerAdapter serverAdapter = new ServerAdapter(server);
                this.servers.add(serverAdapter);
                if (!"J2EE".equals(server.getShortName())) continue;
                this.selected = serverAdapter;
            }
            Collections.sort(this.servers);
            if (this.selected == null) {
                this.selected = this.servers.size() > 0 ? (ServerAdapter)this.servers.get(0) : null;
            }
        }

        public Object getElementAt(int index) {
            return this.servers.get(index);
        }

        public void removeListDataListener(ListDataListener l) {
        }

        public void addListDataListener(ListDataListener l) {
        }

        public int getSize() {
            return this.servers.size();
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object anItem) {
            this.selected = (ServerAdapter)anItem;
        }
    }
}

