/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.model.WebServiceDataPersistenceDelegate;
import org.netbeans.modules.websvc.registry.model.WebServiceGroup;
import org.netbeans.modules.websvc.registry.model.WebServiceListModel;
import org.netbeans.modules.websvc.registry.netbeans.PersistenceManagerInterface;
import org.openide.ErrorManager;

public class WebServicePersistenceManager
implements ExceptionListener,
PersistenceManagerInterface {
    private static final String SAXParserFactory_PROP = "javax.xml.parsers.SAXParserFactory";
    private static final String SAX_PARSER = "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl";
    private File websvcDir = new File(System.getProperty("netbeans.user"), "websvc");
    private File websvcRefFile = new File(this.websvcDir, "websvc_ref.xml");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ClassLoader cl) {
        WebServiceListModel wsListModel = WebServiceListModel.getInstance();
        if (this.websvcRefFile.exists()) {
            String originalParserFactory = System.getProperty(SAXParserFactory_PROP);
            ClassLoader origClassLoader = null;
            XMLDecoder decoder = null;
            try {
                System.getProperties().put(SAXParserFactory_PROP, SAX_PARSER);
                origClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(this.websvcRefFile)));
                Object o = decoder.readObject();
                int wsDataNums = 0;
                if (!(o instanceof Integer)) {
                    ErrorManager.getDefault().log(1, "Error while loading in WS registry: " + o);
                    return;
                }
                wsDataNums = (Integer)o;
                for (int i = 0; i < wsDataNums; ++i) {
                    try {
                        WebServiceData wsData = (WebServiceData)decoder.readObject();
                        wsListModel.addWebService(wsData);
                        continue;
                    }
                    catch (Exception exc) {
                        ErrorManager.getDefault().notify(4096, (Throwable)exc);
                    }
                }
                o = decoder.readObject();
                int wsGroups = 0;
                if (!(o instanceof Integer)) {
                    ErrorManager.getDefault().log(1, "Error while loading in WS registry: " + o);
                    return;
                }
                wsGroups = (Integer)o;
                for (int i = 0; i < wsGroups; ++i) {
                    try {
                        WebServiceGroup group = (WebServiceGroup)decoder.readObject();
                        wsListModel.addWebServiceGroup(group);
                        continue;
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify(4096, (Throwable)ex);
                    }
                }
            }
            catch (Throwable thrown) {
                ErrorManager.getDefault().notify(65536, thrown);
            }
            finally {
                System.getProperties().put(SAXParserFactory_PROP, originalParserFactory);
                if (origClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(origClassLoader);
                }
                if (decoder != null) {
                    decoder.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ClassLoader cl) {
        WebServiceListModel wsListModel = WebServiceListModel.getInstance();
        ClassLoader origClassLoader = null;
        XMLEncoder encoder = null;
        try {
            if (!this.websvcDir.exists()) {
                this.websvcDir.mkdirs();
            }
            if (this.websvcRefFile.exists()) {
                this.websvcRefFile.delete();
            }
            encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(this.websvcRefFile)));
            encoder.setExceptionListener(this);
            WebServiceDataPersistenceDelegate wsDelegate = new WebServiceDataPersistenceDelegate();
            encoder.setPersistenceDelegate(Class.forName("javax.xml.namespace.QName", false, cl), new WebServiceDataPersistenceDelegate());
            encoder.setPersistenceDelegate(Class.forName("com.sun.xml.rpc.wsdl.document.soap.SOAPStyle", false, cl), new WebServiceDataPersistenceDelegate());
            encoder.setPersistenceDelegate(Class.forName("com.sun.xml.rpc.wsdl.document.soap.SOAPUse", false, cl), new WebServiceDataPersistenceDelegate());
            Set wsDataSet = wsListModel.getWebServiceSet();
            encoder.writeObject(new Integer(wsDataSet.size()));
            Iterator iter = wsDataSet.iterator();
            origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            while (iter.hasNext()) {
                WebServiceData wsData = (WebServiceData)iter.next();
                encoder.writeObject(wsData);
            }
            Set wsGroupSet = wsListModel.getWebServiceGroupSet();
            encoder.writeObject(new Integer(wsGroupSet.size()));
            for (WebServiceGroup group : wsGroupSet) {
                encoder.writeObject(group);
            }
            if (origClassLoader != null) {
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
            if (encoder != null) {
                encoder.close();
                encoder.flush();
            }
        }
        catch (Throwable thrown) {
            try {
                ErrorManager.getDefault().notify(65536, thrown);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (origClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(origClassLoader);
                }
                if (encoder != null) {
                    encoder.close();
                    encoder.flush();
                }
            }
        }
    }

    public void exceptionThrown(Exception e) {
        e.printStackTrace();
    }
}

