/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.rename;

import java.text.MessageFormat;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PersistenceXmlRenameRefactoring {
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, String newName, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        if (!(refObject instanceof JavaClass)) {
            return null;
        }
        JavaClass jClass = (JavaClass)refObject;
        newName = Utility.renameClass(jClass.getName(), newName);
        for (FileObject ddFile : PersistenceRefactoringUtil.getPersistence(jClass)) {
            PUDataObject dataObject = ProviderUtil.getPUDataObject((FileObject)ddFile);
            if (!ProviderUtil.isValid((PUDataObject)dataObject)) {
                Problem newProblem = new Problem(false, NbBundle.getMessage(PersistenceXmlRenameRefactoring.class, (String)"TXT_PersistenceXmlInvalidProblem", (Object)ddFile.getPath()));
                problem = Utility.addProblemsToEnd(problem, newProblem);
                continue;
            }
            PersistenceUnit[] persistenceUnits = ProviderUtil.getPersistenceUnits((PUDataObject)dataObject);
            for (int i = 0; i < persistenceUnits.length; ++i) {
                PersistenceUnit unit = persistenceUnits[i];
                for (int j = 0; j < unit.getClass2().length; ++j) {
                    if (!unit.getClass2()[j].equals(jClass.getName())) continue;
                    PersistenceXmlClassRenameRefactoringElement refactoringElem = new PersistenceXmlClassRenameRefactoringElement(unit, jClass.getName(), newName, dataObject, ddFile);
                    refactoringElements.add(refactoring, (RefactoringElementImplementation)refactoringElem);
                }
            }
        }
        return problem;
    }

    private static class PersistenceXmlClassRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        private PersistenceUnit persistenceUnit;
        private PUDataObject puDataObject;

        public PersistenceXmlClassRenameRefactoringElement(PersistenceUnit persistenceUnit, String oldName, String newName, PUDataObject puDataObject, FileObject parentFile) {
            this.oldName = oldName;
            this.newName = newName;
            this.persistenceUnit = persistenceUnit;
            this.puDataObject = puDataObject;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlRenameRefactoring.class, (String)"TXT_PersistenceXmlRename"), args);
        }

        public void performExternalChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.newName, (String)this.oldName, (PUDataObject)this.puDataObject);
        }

        public void undoExternalChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.oldName, (String)this.newName, (PUDataObject)this.puDataObject);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }
    }
}

