/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring;

import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.refactoring.Utility;

public abstract class EjbInterfaceType {
    public static final EjbInterfaceType BEAN_IMPL = new EjbInterfaceType(){

        public String getClassName(Ejb bean) {
            return bean == null ? null : bean.getEjbClass();
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean != null) {
                bean.setEjbClass(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            if (MessageDriven.class.isAssignableFrom(beanType)) {
                return "javax.ejb.MessageDrivenBean";
            }
            if (Entity.class.isAssignableFrom(beanType)) {
                return "javax.ejb.EntityBean";
            }
            if (Session.class.isAssignableFrom(beanType)) {
                return "javax.ejb.SessionBean";
            }
            return null;
        }

        public String getSuffix() {
            return "Bean";
        }

        public String toString() {
            return "implementation class";
        }
    };
    public static final EjbInterfaceType LOCAL_HOME = new EjbInterfaceType(){

        public String getClassName(Ejb bean) {
            if (bean instanceof EntityAndSession) {
                return ((EntityAndSession)bean).getLocalHome();
            }
            return null;
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean instanceof EntityAndSession) {
                ((EntityAndSession)bean).setLocalHome(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            return "javax.ejb.EJBLocalHome";
        }

        public String getSuffix() {
            return "LocalHome";
        }

        public String toString() {
            return "local home interface";
        }

        public CommonDDBean[] getReferences(Ejb bean) {
            return bean.getEjbLocalRef();
        }

        public String getReferenceValue(CommonDDBean ref) {
            return ((EjbLocalRef)ref).getLocalHome();
        }

        public void setRefValue(CommonDDBean ref, String value) {
            ((EjbLocalRef)ref).setLocalHome(value);
        }
    };
    public static final EjbInterfaceType LOCAL = new EjbInterfaceType(){

        public String getClassName(Ejb bean) {
            if (bean instanceof EntityAndSession) {
                return ((EntityAndSession)bean).getLocal();
            }
            return null;
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean instanceof EntityAndSession) {
                ((EntityAndSession)bean).setLocal(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            return "javax.ejb.EJBLocalObject";
        }

        public String getSuffix() {
            return "Local";
        }

        public String toString() {
            return "local interface";
        }

        public CommonDDBean[] getReferences(Ejb bean) {
            return bean.getEjbLocalRef();
        }

        public String getReferenceValue(CommonDDBean ref) {
            return ((EjbLocalRef)ref).getLocal();
        }

        public void setRefValue(CommonDDBean ref, String value) {
            ((EjbLocalRef)ref).setLocal(value);
        }
    };
    public static final EjbInterfaceType REMOTE = new EjbInterfaceType(){

        public String getClassName(Ejb bean) {
            if (bean instanceof EntityAndSession) {
                return ((EntityAndSession)bean).getRemote();
            }
            return null;
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean instanceof EntityAndSession) {
                ((EntityAndSession)bean).setRemote(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            return "javax.ejb.EJBObject";
        }

        public String getSuffix() {
            return "Remote";
        }

        public String toString() {
            return "remote interface";
        }

        public CommonDDBean[] getReferences(Ejb bean) {
            return bean.getEjbRef();
        }

        public String getReferenceValue(CommonDDBean ref) {
            return ((EjbRef)ref).getRemote();
        }

        public void setRefValue(CommonDDBean ref, String value) {
            ((EjbRef)ref).setRemote(value);
        }
    };
    public static final EjbInterfaceType HOME = new EjbInterfaceType(){

        public String getClassName(Ejb bean) {
            if (bean instanceof EntityAndSession) {
                return ((EntityAndSession)bean).getHome();
            }
            return null;
        }

        public void setNewClassName(Ejb bean, String newName) {
            if (bean instanceof EntityAndSession) {
                ((EntityAndSession)bean).setHome(newName);
            }
        }

        protected String getSuperClassName(Class beanType) {
            return "javax.ejb.EJBHome";
        }

        public String getSuffix() {
            return "RemoteHome";
        }

        public String toString() {
            return "home interface";
        }

        public CommonDDBean[] getReferences(Ejb bean) {
            return bean.getEjbRef();
        }

        public String getReferenceValue(CommonDDBean ref) {
            return ((EjbRef)ref).getHome();
        }

        public void setRefValue(CommonDDBean ref, String value) {
            ((EjbRef)ref).setHome(value);
        }
    };
    public static final EjbInterfaceType LOCAL_BUSINESS = new EjbInterfaceType(){

        public String getClassName(Ejb bean) {
            return this.getClassNameForBeanBaseName(LOCAL.getBeanBaseName(LOCAL.getClassName(bean)));
        }

        public void setNewClassName(Ejb bean, String newName) {
        }

        protected String getSuperClassName(Class beanType) {
            return null;
        }

        public String getSuffix() {
            return "LocalBusiness";
        }

        public String toString() {
            return "local business interface";
        }
    };
    public static final EjbInterfaceType REMOTE_BUSINESS = new EjbInterfaceType(){

        public String getClassName(Ejb bean) {
            return this.getClassNameForBeanBaseName(REMOTE.getBeanBaseName(REMOTE.getClassName(bean)));
        }

        public void setNewClassName(Ejb bean, String newName) {
        }

        protected String getSuperClassName(Class beanType) {
            return null;
        }

        public String getSuffix() {
            return "RemoteBusiness";
        }

        public String toString() {
            return "remote business interface";
        }
    };

    public abstract String getClassName(Ejb var1);

    public abstract void setNewClassName(Ejb var1, String var2);

    protected abstract String getSuperClassName(Class var1);

    public abstract String getSuffix();

    public JavaClass resolveClass(Ejb bean) {
        String superClassName;
        JavaClass javaClass = Utility.resolveRealClass(this.getClassName(bean));
        if (javaClass != null && ((superClassName = this.getSuperClassName(bean.getClass())) == null || Utility.isSubTypeOf((ClassDefinition)javaClass, superClassName))) {
            return javaClass;
        }
        return null;
    }

    public String getClassNameForBeanBaseName(String beanBaseName) {
        return beanBaseName + this.getSuffix();
    }

    public String getBeanBaseName(String className) {
        return EjbInterfaceType.stripSuffix(className, this.getSuffix());
    }

    private static String stripSuffix(String s, String suffix) {
        return s != null && s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : s;
    }

    public Ejb getBean(EnterpriseBeans eBeans, Class beanType, String className) {
        Ejb[] ejbs;
        if (eBeans != null && (ejbs = eBeans.getEjbs()) != null) {
            for (int i = 0; i < ejbs.length; ++i) {
                Ejb bean;
                Ejb ejb = ejbs[i];
                if (ejb == null || !beanType.isAssignableFrom(ejb.getClass()) || !className.equals(this.getClassName(bean = ejbs[i]))) continue;
                return bean;
            }
        }
        return null;
    }

    public Ejb getBean(EnterpriseBeans eBeans, Class beanType, ClassDefinition jc) {
        Ejb[] ejbs;
        if (eBeans != null && (ejbs = eBeans.getEjbs()) != null) {
            for (int i = 0; i < ejbs.length; ++i) {
                Ejb bean;
                JavaClass javaClass;
                Ejb ejb = ejbs[i];
                if (ejb == null || !beanType.isAssignableFrom(ejb.getClass()) || (javaClass = this.resolveClass(bean = ejbs[i])) == null || !javaClass.isSubTypeOf(jc) && !jc.isSubTypeOf((ClassDefinition)javaClass)) continue;
                return bean;
            }
        }
        return null;
    }

    public CommonDDBean[] getReferences(Ejb bean) {
        return null;
    }

    public String getReferenceValue(CommonDDBean ref) {
        return null;
    }

    public void setRefValue(CommonDDBean ref, String value) {
    }

    public static EjbInterfaceType getEjbInterfaceType(ClassDefinition javaClass, boolean resolveBusiness) {
        if (Utility.isSubTypeOf(javaClass, "javax.ejb.EJBLocalObject")) {
            return LOCAL;
        }
        if (Utility.isSubTypeOf(javaClass, "javax.ejb.EJBObject")) {
            return REMOTE;
        }
        if (Utility.isSubTypeOf(javaClass, "javax.ejb.EJBHome")) {
            return HOME;
        }
        if (Utility.isSubTypeOf(javaClass, "javax.ejb.EJBLocalHome")) {
            return LOCAL_HOME;
        }
        if (Utility.isSubTypeOf(javaClass, "javax.ejb.SessionBean") || Utility.isSubTypeOf(javaClass, "javax.ejb.EntityBean") || Utility.isSubTypeOf(javaClass, "javax.ejb.MessageDrivenBean")) {
            return BEAN_IMPL;
        }
        for (ClassDefinition implementor : ((JavaClass)javaClass).getImplementors()) {
            EjbInterfaceType ejbInterfaceType = EjbInterfaceType.getEjbInterfaceType(implementor, false);
            if (ejbInterfaceType == null) continue;
            if (resolveBusiness) {
                String beanBaseName = ejbInterfaceType.getBeanBaseName(implementor.getName());
                if (ejbInterfaceType == LOCAL) {
                    if (!beanBaseName.equals(LOCAL_BUSINESS.getBeanBaseName(javaClass.getName()))) continue;
                    return LOCAL_BUSINESS;
                }
                if (ejbInterfaceType != REMOTE || !beanBaseName.equals(REMOTE_BUSINESS.getBeanBaseName(javaClass.getName()))) continue;
                return REMOTE_BUSINESS;
            }
            return ejbInterfaceType;
        }
        return null;
    }
}

