/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;
import org.openide.util.Task;

public final class SourceElement
extends Element {
    public static final int STATUS_NOT = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_PARTIAL = 2;
    public static final int STATUS_OK = 3;
    static final long serialVersionUID = -1439690719608070114L;

    public SourceElement(Impl impl) {
        super(impl);
    }

    final Impl getSourceImpl() {
        return (Impl)this.impl;
    }

    public int getStatus() {
        return this.getSourceImpl().getStatus();
    }

    public Task prepare() {
        return this.getSourceImpl().prepare();
    }

    public void setPackage(Identifier id) throws SourceException {
        this.getSourceImpl().setPackage(id);
    }

    public Identifier getPackage() {
        return this.getSourceImpl().getPackage();
    }

    public Import[] getImports() {
        return this.getSourceImpl().getImports();
    }

    public void setImports(Import[] imprt) throws SourceException {
        this.getSourceImpl().changeImports(imprt, 0);
    }

    public void addImport(Import el) throws SourceException {
        this.getSourceImpl().changeImports(new Import[]{el}, 1);
    }

    public void addImports(Import[] els) throws SourceException {
        this.getSourceImpl().changeImports(els, 1);
    }

    public void removeImport(Import el) throws SourceException {
        this.getSourceImpl().changeImports(new Import[]{el}, -1);
    }

    public void removeImports(Import[] els) throws SourceException {
        this.getSourceImpl().changeImports(els, -1);
    }

    public void addClass(ClassElement el) throws SourceException {
        Identifier id = Identifier.create(el.getName().getName());
        if (this.getClass(id) != null) {
            this.throwAddException("FMT_EXC_AddClassToSource", el);
        }
        this.getSourceImpl().changeClasses(new ClassElement[]{el}, 1);
    }

    public void addClasses(ClassElement[] els) throws SourceException {
        for (int i = 0; i < els.length; ++i) {
            Identifier id = Identifier.create(els[i].getName().getName());
            if (this.getClass(id) == null) continue;
            this.throwAddException("FMT_EXC_AddClassToSource", els[i]);
        }
        this.getSourceImpl().changeClasses(els, 1);
    }

    private void throwAddException(String formatKey, ClassElement element) throws SourceException {
        String msg = NbBundle.getMessage((Class)ElementFormat.class, (String)formatKey, (Object)element.getName().getName());
        this.throwSourceException(msg);
    }

    public void removeClass(ClassElement el) throws SourceException {
        this.getSourceImpl().changeClasses(new ClassElement[]{el}, -1);
    }

    public void removeClasses(ClassElement[] els) throws SourceException {
        this.getSourceImpl().changeClasses(els, -1);
    }

    public void setClasses(ClassElement[] els) throws SourceException {
        this.getSourceImpl().changeClasses(els, 0);
    }

    public ClassElement[] getClasses() {
        return this.getSourceImpl().getClasses();
    }

    public ClassElement getClass(Identifier name) {
        return this.getSourceImpl().getClass(name);
    }

    public ClassElement[] getAllClasses() {
        return this.getSourceImpl().getAllClasses();
    }

    public void print(ElementPrinter printer) throws ElementPrinterInterruptException {
        Identifier pack = this.getPackage();
        if (pack != null) {
            printer.print("package ");
            printer.print(pack.getFullName());
            printer.println(";");
            printer.println("");
        }
        Import[] imp = this.getImports();
        for (int i = 0; i < imp.length; ++i) {
            printer.print(imp[i].toString());
            printer.println(";");
        }
        if (imp.length > 0) {
            printer.println("");
        }
        SourceElement.print(this.getClasses(), printer);
    }

    public void runAtomic(Runnable run) {
        this.getSourceImpl().runAtomic(run);
    }

    public void runAtomicAsUser(Runnable run) throws SourceException {
        this.getSourceImpl().runAtomicAsUser(run);
    }

    public static interface Impl
    extends Element.Impl {
        public static final int ADD = 1;
        public static final int REMOVE = -1;
        public static final int SET = 0;
        public static final long serialVersionUID = -2181228658756563166L;

        public int getStatus();

        public Task prepare();

        public void setPackage(Identifier var1) throws SourceException;

        public Identifier getPackage();

        public Import[] getImports();

        public void changeImports(Import[] var1, int var2) throws SourceException;

        public void changeClasses(ClassElement[] var1, int var2) throws SourceException;

        public ClassElement[] getClasses();

        public ClassElement getClass(Identifier var1);

        public ClassElement[] getAllClasses();

        public void runAtomic(Runnable var1);

        public void runAtomicAsUser(Runnable var1) throws SourceException;
    }
}

