/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.ui.nodes.MethodCustomizer;
import org.openide.util.NbBundle;

public class MethodCollectorFactory {
    private MethodCollectorFactory() {
    }

    private static MethodCustomizer commonCollector(Method method, boolean remote, boolean local, boolean checkRemote, boolean checkLocal) {
        MethodCustomizer mc = new MethodCustomizer(method);
        mc.setAvailableInterface(local, remote);
        mc.setSelectedInterface(checkLocal, checkRemote);
        mc.hideEJBQL();
        mc.hideFinderReturn();
        return mc;
    }

    public static MethodCustomizer businessCollector(Method method, boolean remote, boolean local, Method[] mes, boolean checkRemote, boolean checkLocal) {
        MethodCustomizer mc = MethodCollectorFactory.commonCollector(method, remote, local, checkRemote, checkLocal);
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodExists_Error"));
        mc.enablePrefixForName("", NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodName_Empty_Error"));
        return mc;
    }

    public static MethodCustomizer homeCollector(Method method, boolean remote, boolean local, Method[] mes, boolean checkRemote, boolean checkLocal) {
        MethodCustomizer mc = MethodCollectorFactory.commonCollector(method, remote, local, checkRemote, checkLocal);
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodExists_Error"));
        mc.enablePrefixForName("", NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodName_Empty_Error"));
        return mc;
    }

    public static MethodCustomizer createCollector(Method method, boolean remote, boolean local, Method[] mes, boolean checkRemote, boolean checkLocal) {
        MethodCustomizer mc = MethodCollectorFactory.commonCollector(method, remote, local, checkRemote, checkLocal);
        mc.hideReturn();
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodExists_Error"));
        mc.enablePrefixForName("create", NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodName_Create_Error"));
        return mc;
    }

    public static MethodCustomizer finderCollector(Method method, boolean remote, boolean local, boolean ql, Method[] mes, boolean checkRemote, boolean checkLocal) {
        final MethodCustomizer mc = new MethodCustomizer(method);
        mc.setAvailableInterface(local, remote);
        mc.setSelectedInterface(checkLocal, checkRemote);
        mc.hideReturn();
        mc.hideExceptions();
        if (!ql) {
            mc.hideEJBQL();
        }
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodExists_Error"));
        mc.enablePrefixForName("find", NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodName_Find_Error"));
        final JCheckBox localCheckbox = mc.getLocalCheckbox();
        final JCheckBox remoteCheckbox = mc.getRemoteCheckbox();
        final ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isValid = localCheckbox.isSelected() || remoteCheckbox.isSelected();
                mc.firePropertyChange("ok_enabled", !isValid, isValid);
            }
        };
        localCheckbox.addActionListener(actionListener);
        remoteCheckbox.addActionListener(actionListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                actionListener.actionPerformed(null);
            }
        });
        return mc;
    }

    public static MethodCustomizer operationCollector(Method method) {
        MethodCustomizer mc = new MethodCustomizer(method);
        mc.hideInterfaceSelection();
        mc.hideEJBQL();
        mc.hideFinderReturn();
        mc.enablePrefixForName("", NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodName_Select_Error"));
        return mc;
    }

    public static MethodCustomizer selectCollector(Method method, Method[] mes) {
        MethodCustomizer mc = new MethodCustomizer(method);
        mc.hideInterfaceSelection();
        mc.hideFinderReturn();
        mc.hideExceptions();
        mc.enableCheckForSignature(mes, NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodExists_Error"));
        mc.enablePrefixForName("ejbSelect", NbBundle.getMessage(MethodCollectorFactory.class, (String)"LBL_MethodName_Operation_Error"));
        return mc;
    }
}

