/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;

final class FileSearchUtility {
    private FileSearchUtility() {
    }

    static Enumeration getChildrenToDepth(FileObject root, final int depth, final boolean onlyWritables) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WithChildren
        implements Enumerations.Processor {
            private int rootDepth;

            public WithChildren(int rootDepth) {
                this.rootDepth = rootDepth;
            }

            public Object process(Object obj, Collection toAdd) {
                FileObject fo = (FileObject)obj;
                if ((!onlyWritables || onlyWritables && fo.canWrite()) && fo.isFolder() && FileSearchUtility.getDepth(fo) - this.rootDepth < depth) {
                    toAdd.addAll(Arrays.asList(fo.getChildren()));
                }
                return fo;
            }
        }
        return Enumerations.queue((Enumeration)Enumerations.array((Object[])root.getChildren()), (Enumerations.Processor)new WithChildren(FileSearchUtility.getDepth(root)));
    }

    static FileObject[] guessJavaRoots(FileObject dir) {
        ArrayList<FileObject> foundRoots = new ArrayList<FileObject>();
        if (null == dir) {
            return null;
        }
        Enumeration ch = FileSearchUtility.getChildrenToDepth(dir, 10, true);
        try {
            while (ch.hasMoreElements() && foundRoots.isEmpty()) {
                FileObject f = (FileObject)ch.nextElement();
                if (!f.getExt().equals("java") || f.isFolder()) continue;
                String pckg = FileSearchUtility.guessPackageName(f);
                String pkgPath = f.getParent().getPath();
                if (pckg == null || !pkgPath.endsWith(pckg.replace('.', '/'))) continue;
                String rootName = pkgPath.substring(0, pkgPath.length() - pckg.length());
                FileObject fr = f.getFileSystem().findResource(rootName);
                if (foundRoots.contains(fr)) continue;
                foundRoots.add(fr);
            }
        }
        catch (FileStateInvalidException fsie) {
            ErrorManager.getDefault().notify(1, (Throwable)fsie);
        }
        if (foundRoots.size() == 0) {
            return null;
        }
        FileObject[] resultArr = new FileObject[foundRoots.size()];
        for (int i = 0; i < foundRoots.size(); ++i) {
            resultArr[i] = (FileObject)foundRoots.get(i);
        }
        return resultArr;
    }

    static FileObject guessConfigFilesPath(FileObject dir) {
        if (null == dir) {
            return null;
        }
        Enumeration ch = FileSearchUtility.getChildrenToDepth(dir, 3, true);
        try {
            while (ch.hasMoreElements()) {
                FileObject f = (FileObject)ch.nextElement();
                if (!f.getNameExt().equals("ejb-jar.xml")) continue;
                String rootName = f.getParent().getPath();
                return f.getFileSystem().findResource(rootName);
            }
        }
        catch (FileStateInvalidException fsie) {
            ErrorManager.getDefault().notify(1, (Throwable)fsie);
        }
        return null;
    }

    static File[] guessJavaRootsAsFiles(FileObject dir) {
        FileObject[] rootsFOs = FileSearchUtility.guessJavaRoots(dir);
        if (rootsFOs == null) {
            return new File[0];
        }
        File[] resultArr = new File[rootsFOs.length];
        for (int i = 0; i < resultArr.length; ++i) {
            resultArr[i] = FileUtil.toFile((FileObject)rootsFOs[i]);
        }
        return resultArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String guessPackageName(FileObject f) {
        Reader r = null;
        try {
            int idx2;
            int len;
            r = new BufferedReader(new InputStreamReader(f.getInputStream(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                sb.append(buffer, 0, len);
            }
            int idx = sb.indexOf("package");
            if (idx >= 0 && (idx2 = sb.indexOf(";", idx)) >= 0) {
                String string = sb.substring(idx + "package".length(), idx2).trim();
                return string;
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    static FileObject guessLibrariesFolder(FileObject dir) {
        FileObject lib;
        if (dir != null && (lib = dir.getFileObject("lib")) != null) {
            return lib;
        }
        Enumeration ch = FileSearchUtility.getChildrenToDepth(dir, 3, true);
        while (ch.hasMoreElements()) {
            FileObject f = (FileObject)ch.nextElement();
            if (!f.getExt().equals("jar")) continue;
            return f.getParent();
        }
        return null;
    }

    private static int getDepth(FileObject fo) {
        String path = FileUtil.toFile((FileObject)fo).getAbsolutePath();
        StringTokenizer toker = new StringTokenizer(path, File.separator);
        return toker.countTokens();
    }
}

