/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import org.netbeans.api.editor.fold.Fold;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;

public final class FoldChildren
extends GapList {
    private static final int INITIAL_INDEX_GAP_LENGTH = 0x3FFFFFFF;
    Fold parent;
    private int indexGapIndex;
    private int indexGapLength;

    public FoldChildren(Fold parent) {
        this.parent = parent;
        this.indexGapLength = 0x3FFFFFFF;
    }

    public int getFoldCount() {
        return this.size();
    }

    public Fold getFold(int index) {
        return (Fold)this.get(index);
    }

    public int getFoldIndex(Fold child) {
        int index = this.getTranslatedFoldIndex(ApiPackageAccessor.get().foldGetRawIndex(child));
        if (index < 0 || index >= this.getFoldCount() || this.getFold(index) != child) {
            index = -1;
        }
        return index;
    }

    public Fold[] foldsToArray(int index, int length) {
        Object[] folds = new Fold[length];
        this.copyItems(index, index + length, folds, 0);
        return folds;
    }

    public void insert(int index, Fold fold) {
        this.moveIndexGap(index);
        this.insertImpl(index, fold);
    }

    public void insert(int index, Fold[] folds) {
        this.moveIndexGap(index);
        this.insertImpl(index, folds);
    }

    public void remove(int index, int length) {
        this.moveIndexGap(index + length);
        for (int i = index + length - 1; i >= index; --i) {
            ApiPackageAccessor.get().foldSetParent(this.getFold(i), null);
        }
        super.remove(index, length);
        this.indexGapLength += length;
        this.indexGapIndex -= length;
    }

    public FoldChildren extractToChildren(int index, int length, Fold fold) {
        FoldChildren foldChildren = new FoldChildren(fold);
        if (length == 1) {
            Fold insertFold = this.getFold(index);
            this.remove(index, length);
            foldChildren.insert(0, insertFold);
        } else {
            Fold[] insertFolds = this.foldsToArray(index, length);
            this.remove(index, length);
            foldChildren.insert(0, insertFolds);
        }
        this.insertImpl(index, fold);
        return foldChildren;
    }

    public void replaceByChildren(int index, FoldChildren children) {
        this.remove(index, 1);
        if (children != null) {
            int childCount = children.getFoldCount();
            this.insertImpl(index, children, 0, childCount);
        }
    }

    private void insertImpl(int index, FoldChildren children, int childIndex, int childCount) {
        switch (childCount) {
            case 0: {
                break;
            }
            case 1: {
                this.insertImpl(index, children.getFold(childIndex));
                break;
            }
            default: {
                Fold[] folds = children.foldsToArray(childIndex, childCount);
                this.insertImpl(index, folds);
            }
        }
    }

    private void insertImpl(int index, Fold fold) {
        --this.indexGapLength;
        ++this.indexGapIndex;
        ApiPackageAccessor api = ApiPackageAccessor.get();
        api.foldSetRawIndex(fold, index);
        api.foldSetParent(fold, this.parent);
        this.add(index, fold);
    }

    private void insertImpl(int index, Fold[] folds) {
        ApiPackageAccessor api = ApiPackageAccessor.get();
        int foldsLength = folds.length;
        this.indexGapLength -= foldsLength;
        this.indexGapIndex += foldsLength;
        for (int i = foldsLength - 1; i >= 0; --i) {
            Fold fold = folds[i];
            api.foldSetRawIndex(fold, index + i);
            api.foldSetParent(fold, this.parent);
        }
        this.addArray(index, folds);
    }

    private int getTranslatedFoldIndex(int rawIndex) {
        if (rawIndex >= this.indexGapLength) {
            rawIndex -= this.indexGapLength;
        }
        return rawIndex;
    }

    private void moveIndexGap(int index) {
        if (index != this.indexGapIndex) {
            ApiPackageAccessor api = ApiPackageAccessor.get();
            int gapLen = this.indexGapLength;
            if (index < this.indexGapIndex) {
                for (int i = this.indexGapIndex - 1; i >= index; --i) {
                    api.foldUpdateRawIndex(this.getFold(i), gapLen);
                }
            } else {
                for (int i = this.indexGapIndex; i < index; ++i) {
                    api.foldUpdateRawIndex(this.getFold(i), -gapLen);
                }
            }
            this.indexGapIndex = index;
        }
    }
}

