/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.IDESettings;
import org.netbeans.core.windows.actions.RecentViewListAction;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.openide.awt.StatusDisplayer;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class KeyboardPopupSwitcher {
    private static final int TIME_TO_SHOW = 200;
    private static KeyboardPopupSwitcher instance;
    private static Popup popup;
    private static boolean shown;
    private static Timer invokerTimer;
    private static boolean invokerTimerRunning;
    private static int hits;
    private static SwitcherTableItem[] items;
    private SwitcherTable pTable = new SwitcherTable(items);
    private static int triggerKey;
    private static int reverseKey;
    private static int releaseKey;
    private int x;
    private int y;
    private boolean fwd = true;
    private static IDESettings settings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean processShortcut(KeyEvent kev) {
        boolean isCtrlShiftTab;
        if (settings.getUIMode() == 2 && !WindowManager.getDefault().getMainWindow().isFocused()) {
            return false;
        }
        boolean isCtrlTab = kev.getKeyCode() == 9 && kev.getModifiers() == 2;
        boolean bl = isCtrlShiftTab = kev.getKeyCode() == 9 && kev.getModifiers() == 3;
        if (KeyboardPopupSwitcher.isShown()) {
            if (!$assertionsDisabled && instance == null) {
                throw new AssertionError();
            }
            instance.processKeyEvent(kev);
            kev.consume();
            return true;
        }
        if (isCtrlTab || isCtrlShiftTab) {
            if (!KeyboardPopupSwitcher.isAlive()) {
                RecentViewListAction rva = new RecentViewListAction();
                rva.actionPerformed(new ActionEvent(kev.getSource(), 1001, "C-TAB"));
                return true;
            }
            KeyboardPopupSwitcher.processInterruption(kev);
            kev.consume();
            return true;
        }
        if (kev.getKeyCode() == 17 && KeyboardPopupSwitcher.isAlive()) {
            KeyboardPopupSwitcher.processInterruption(kev);
            return true;
        }
        return false;
    }

    public static void selectItem(SwitcherTableItem[] items, int releaseKey, int triggerKey) {
        if (invokerTimerRunning) {
            return;
        }
        KeyboardPopupSwitcher.items = items;
        KeyboardPopupSwitcher.releaseKey = releaseKey;
        KeyboardPopupSwitcher.triggerKey = triggerKey;
        invokerTimer = new Timer(200, new PopupInvoker());
        invokerTimer.setRepeats(false);
        invokerTimer.start();
        invokerTimerRunning = true;
    }

    private static void cleanupInterrupter() {
        invokerTimerRunning = false;
        if (invokerTimer != null) {
            invokerTimer.stop();
        }
    }

    public static boolean isShown() {
        return shown;
    }

    private static boolean isAlive() {
        return invokerTimerRunning || shown;
    }

    private KeyboardPopupSwitcher(int initialSelection) {
        Dimension popupDim = this.pTable.getPreferredSize();
        Rectangle screen = Utilities.getUsableScreenBounds();
        this.x = screen.x + (screen.width / 2 - popupDim.width / 2);
        this.y = screen.y + (screen.height / 2 - popupDim.height / 2);
        int cols = this.pTable.getColumnCount();
        int rows = this.pTable.getRowCount();
        if (!$assertionsDisabled && cols <= 0) {
            throw new AssertionError((Object)"There aren't any columns in the KeyboardPopupSwitcher's table");
        }
        if (!$assertionsDisabled && rows <= 0) {
            throw new AssertionError((Object)"There aren't any rows in the KeyboardPopupSwitcher's table");
        }
        this.changeTableSelection(rows > initialSelection ? initialSelection : initialSelection, 0);
    }

    private void showPopup() {
        if (!KeyboardPopupSwitcher.isShown()) {
            popup = PopupFactory.getSharedInstance().getPopup(WindowManager.getDefault().getMainWindow(), (Component)this.pTable, this.x, this.y);
            popup.show();
            shown = true;
        }
    }

    private static void processInterruption(KeyEvent kev) {
        if (kev.getID() != 402 && invokerTimerRunning) {
            return;
        }
        int keyCode = kev.getKeyCode();
        if (keyCode == releaseKey) {
            KeyboardPopupSwitcher.cleanupInterrupter();
            hits = 0;
            RecentViewListAction rva = new RecentViewListAction();
            rva.actionPerformed(new ActionEvent(kev.getSource(), 1001, "immediately"));
            kev.consume();
        } else if (keyCode == triggerKey && kev.getModifiers() == 2) {
            kev.consume();
            if (++hits > 1) {
                KeyboardPopupSwitcher.cleanupInterrupter();
                instance = new KeyboardPopupSwitcher(hits);
                instance.showPopup();
            }
        }
    }

    private void processKeyEvent(KeyEvent kev) {
        switch (kev.getID()) {
            case 402: {
                int code = kev.getKeyCode();
                if (code == reverseKey) {
                    this.fwd = true;
                } else if (code == triggerKey) {
                    int lastRowIdx = this.pTable.getRowCount() - 1;
                    int lastColIdx = this.pTable.getColumnCount() - 1;
                    int selRow = this.pTable.getSelectedRow();
                    int selCol = this.pTable.getSelectedColumn();
                    int row = selRow;
                    int col = selCol;
                    if (this.fwd) {
                        if (selRow >= lastRowIdx) {
                            row = 0;
                            col = selCol >= lastColIdx ? 0 : ++col;
                        } else if (this.pTable.getValueAt(++row, col) == null) {
                            row = 0;
                            col = 0;
                        }
                    } else if (selRow == 0) {
                        if (selCol == 0) {
                            col = lastColIdx;
                            row = this.pTable.getLastValidRow();
                        } else {
                            --col;
                            row = lastRowIdx;
                        }
                    } else {
                        --row;
                    }
                    if (row >= 0 && col >= 0) {
                        this.changeTableSelection(row, col);
                    }
                } else if (code == 27) {
                    this.cancelSwiching();
                } else if (code == releaseKey) {
                    this.performSwitching();
                }
                kev.consume();
                break;
            }
            case 401: {
                if (kev.getKeyCode() != reverseKey) break;
                this.fwd = false;
                kev.consume();
            }
        }
    }

    private void changeTableSelection(int row, int col) {
        this.pTable.changeSelection(row, col, false, false);
        String statusText = this.pTable.getSelectedItem().getDescription();
        StatusDisplayer.getDefault().setStatusText(statusText != null ? statusText : "");
    }

    private void cancelSwiching() {
        this.hideCurrentPopup();
        StatusDisplayer.getDefault().setStatusText("");
    }

    private void performSwitching() {
        if (popup != null) {
            this.pTable.getSelectedItem().activate();
        }
        this.cancelSwiching();
    }

    private synchronized void hideCurrentPopup() {
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
        }
    }

    static {
        $assertionsDisabled = !KeyboardPopupSwitcher.class.desiredAssertionStatus();
        reverseKey = 16;
        settings = (IDESettings)SharedClassObject.findObject((Class)IDESettings.class, (boolean)true);
    }

    private class PopupHider
    implements Runnable {
        private Popup toHide;

        public PopupHider(Popup popup) {
            this.toHide = popup;
        }

        public void run() {
            this.toHide.hide();
            shown = false;
            hits = 0;
        }
    }

    private static class PopupInvoker
    implements ActionListener {
        private PopupInvoker() {
        }

        public void actionPerformed(ActionEvent e) {
            if (invokerTimerRunning) {
                KeyboardPopupSwitcher.cleanupInterrupter();
                instance = new KeyboardPopupSwitcher(hits);
                instance.showPopup();
            }
        }
    }
}

