/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.persistence.GroupConfig;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.ModuleChangeHandler;
import org.netbeans.core.windows.persistence.TCGroupConfig;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.netbeans.core.windows.persistence.WindowManagerConfig;
import org.netbeans.core.windows.persistence.WindowManagerParser;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceDataObject;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PersistenceManager
implements PropertyChangeListener {
    static final String ROOT_MODULE_FOLDER = "Windows2";
    static final String ROOT_LOCAL_FOLDER = "Windows2Local";
    static final String WINDOWMANAGER_FOLDER = "WindowManager";
    static final String GROUPS_FOLDER = "Groups";
    static final String MODES_FOLDER = "Modes";
    private static final String COMPS_FOLDER = "Components";
    public static final String WINDOWMANAGER_EXT = "wswmgr";
    public static final String WORKSPACE_EXT = "wswksp";
    public static final String MODE_EXT = "wsmode";
    public static final String TCREF_EXT = "wstcref";
    public static final String GROUP_EXT = "wsgrp";
    public static final String TCGROUP_EXT = "wstcgrp";
    public static final String COMPONENT_EXT = "settings";
    private static final String DEFAULT_TC_NAME = "untitled_tc";
    private static final boolean DEBUG = Debug.isLoggable(PersistenceManager.class);
    private FileObject rootModuleFolder;
    private FileObject rootLocalFolder;
    private FileObject compsModuleFolder;
    private FileObject groupsModuleFolder;
    private FileObject groupsLocalFolder;
    private FileObject modesModuleFolder;
    private FileObject modesLocalFolder;
    private WindowManagerParser windowManagerParser;
    private ModuleChangeHandler changeHandler;
    private final Map topComponent2IDMap = new WeakHashMap(30);
    private final Map topComponentNonPersistent2IDMap = new WeakHashMap(30);
    private Set globalIDSet = new HashSet(30);
    private final Map id2TopComponentMap = Collections.synchronizedMap(new HashMap(30));
    private final Map id2TopComponentNonPersistentMap = Collections.synchronizedMap(new HashMap(30));
    private final Map dataobjectToTopComponentMap = new WeakHashMap(30);
    private Set invalidIds = new HashSet(10);
    private final Set usedTcIds = new HashSet(10);
    private final Object LOCK_IDS = new Object();
    private XMLReader parser;
    private static PersistenceManager defaultInstance;
    private Map failedCompsMap;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    private PersistenceManager() {
    }

    public static synchronized PersistenceManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new PersistenceManager();
        }
        return defaultInstance;
    }

    FileObject getRootModuleFolder() {
        try {
            if (this.rootModuleFolder == null) {
                this.rootModuleFolder = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)ROOT_MODULE_FOLDER);
            }
            return this.rootModuleFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_RootFolder", (Object)ROOT_MODULE_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    FileObject getRootLocalFolder() {
        try {
            if (this.rootLocalFolder == null) {
                this.rootLocalFolder = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)ROOT_LOCAL_FOLDER);
            }
            return this.rootLocalFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_RootFolder", (Object)ROOT_LOCAL_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    void setRootModuleFolder(FileObject rootModuleFolder) {
        this.rootModuleFolder = rootModuleFolder;
    }

    void setRootLocalFolder(FileObject rootLocalFolder) {
        this.rootLocalFolder = rootLocalFolder;
    }

    public FileObject getComponentsModuleFolder() {
        try {
            if (this.compsModuleFolder == null) {
                this.compsModuleFolder = FileUtil.createFolder((FileObject)this.getRootModuleFolder(), (String)COMPS_FOLDER);
            }
            return this.compsModuleFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_CompsFolder", (Object)COMPS_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    public FileObject getComponentsLocalFolder() {
        try {
            FileObject compsLocalFolder = FileUtil.createFolder((FileObject)this.getRootLocalFolder(), (String)COMPS_FOLDER);
            return compsLocalFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_CompsFolder", (Object)COMPS_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    public FileObject getGroupsModuleFolder() {
        try {
            if (this.groupsModuleFolder == null) {
                this.groupsModuleFolder = FileUtil.createFolder((FileObject)this.getRootModuleFolder(), (String)GROUPS_FOLDER);
            }
            return this.groupsModuleFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_GroupsFolder", (Object)GROUPS_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    public FileObject getGroupsLocalFolder() {
        try {
            if (this.groupsLocalFolder == null) {
                this.groupsLocalFolder = FileUtil.createFolder((FileObject)this.getRootLocalFolder(), (String)GROUPS_FOLDER);
            }
            return this.groupsLocalFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_GroupsFolder", (Object)GROUPS_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    public FileObject getModesModuleFolder() {
        try {
            if (this.modesModuleFolder == null) {
                this.modesModuleFolder = FileUtil.createFolder((FileObject)this.getRootModuleFolder(), (String)MODES_FOLDER);
            }
            return this.modesModuleFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_ModesFolder", (Object)MODES_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    public FileObject getModesLocalFolder() {
        try {
            if (this.modesLocalFolder == null) {
                this.modesLocalFolder = FileUtil.createFolder((FileObject)this.getRootLocalFolder(), (String)MODES_FOLDER);
            }
            return this.modesLocalFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_ModesFolder", (Object)MODES_FOLDER);
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("cookie".equals(evt.getPropertyName())) {
            Object obj = evt.getSource();
            this.removeTopComponentForDataObject((DataObject)obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTopComponentForDataObject(DataObject dob) {
        InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
        if (ic == null) {
            Object object = this.LOCK_IDS;
            synchronized (object) {
                TopComponent tc;
                WeakReference result;
                String tc_id = (String)this.dataobjectToTopComponentMap.remove(dob);
                if (tc_id != null && (result = (WeakReference)this.id2TopComponentMap.remove(tc_id)) != null && (tc = (TopComponent)result.get()) != null) {
                    this.topComponent2IDMap.remove(tc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGlobalTopComponentID(TopComponent tc, String preferredID) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            String result = (String)this.topComponent2IDMap.get(tc);
            if (result != null) {
                if (this.isInvalidId(result)) {
                    this.restorePair(tc, result);
                }
                return result;
            }
            result = (String)this.topComponentNonPersistent2IDMap.get(tc);
            if (result != null) {
                return result;
            }
        }
        if (this.isTopComponentProbablyPersistent(tc)) {
            return this.createTopComponentPersistentID(tc, preferredID);
        }
        return this.createTopComponentNonPersistentID(tc, preferredID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGlobalTopComponentID(String id) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            TopComponent tc;
            this.globalIDSet.remove(id.toUpperCase(Locale.ENGLISH));
            WeakReference result = (WeakReference)this.id2TopComponentMap.remove(id);
            if (result != null && (tc = (TopComponent)result.get()) != null) {
                this.topComponent2IDMap.remove(tc);
            }
            if ((result = (WeakReference)this.id2TopComponentNonPersistentMap.remove(id)) != null && (tc = (TopComponent)result.get()) != null) {
                this.topComponentNonPersistent2IDMap.remove(tc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopComponent getTopComponentPersistentForID(String stringId) {
        block17: {
            Object object = this.LOCK_IDS;
            synchronized (object) {
                WeakReference result = (WeakReference)this.id2TopComponentMap.get(stringId);
                if (result != null) {
                    TopComponent tc = (TopComponent)result.get();
                    if (tc != null) {
                        return tc;
                    }
                    this.id2TopComponentMap.remove(stringId);
                }
            }
            FileNotFoundException resultExc = null;
            try {
                DataObject dob = PersistenceManager.findTopComponentDataObject(this.getComponentsLocalFolder(), stringId);
                if (dob != null) {
                    InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                    if (ic != null) {
                        TopComponent tc = (TopComponent)ic.instanceCreate();
                        Object object2 = this.LOCK_IDS;
                        synchronized (object2) {
                            this.topComponent2IDMap.put(tc, stringId);
                            this.id2TopComponentMap.put(stringId, new WeakReference<TopComponent>(tc));
                            this.dataobjectToTopComponentMap.put(dob, stringId);
                        }
                        dob.addPropertyChangeListener((PropertyChangeListener)this);
                        return tc;
                    }
                    String excAnnotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_BrokenTCSetting", (Object)stringId);
                    resultExc = new SafeException((Exception)new IOException(excAnnotation));
                    ErrorManager.getDefault().log(16, "[WinSys.PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + stringId + "'. Reason: " + excAnnotation);
                    ErrorManager.getDefault().notify(1, (Throwable)resultExc);
                    break block17;
                }
                String excAnnotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_FailedLocateTC", (Object)stringId);
                resultExc = new FileNotFoundException(excAnnotation);
                ErrorManager.getDefault().log(16, "[WinSys.PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + stringId + "'. Reason: " + excAnnotation);
            }
            catch (NoClassDefFoundError ndfe) {
                ErrorManager.getDefault().log(16, "[WinSys.PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + stringId + "'. Reason: " + ndfe.getMessage());
                ErrorManager.getDefault().notify(1, (Throwable)ndfe);
            }
            catch (InvalidObjectException ioe) {
                ErrorManager.getDefault().log(16, "[WinSys.PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + stringId + "'. Reason: " + ioe.getMessage());
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
            catch (DataObjectNotFoundException dnfe) {
                ErrorManager.getDefault().log(16, "[WinSys.PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + stringId + "'. Reason: " + " Object not found: " + dnfe.getMessage() + ". It was probably deleted.");
                ErrorManager.getDefault().notify(1, (Throwable)dnfe);
            }
            catch (ClassNotFoundException exc) {
                ErrorManager.getDefault().log(16, "[WinSys.PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + stringId + "'. Reason: " + exc.getMessage());
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
            catch (ClassCastException exc) {
                ErrorManager.getDefault().log(16, "[WinSys.PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + stringId + "'. Reason: " + exc.getMessage());
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(16, "[WinSys.PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + stringId + "'. Reason: " + ioe.getMessage());
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopComponent getTopComponentNonPersistentForID(String stringId) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            WeakReference result = (WeakReference)this.id2TopComponentNonPersistentMap.get(stringId);
            if (result != null) {
                TopComponent tc = (TopComponent)result.get();
                if (tc != null) {
                    return tc;
                }
                this.id2TopComponentNonPersistentMap.remove(stringId);
            }
            return null;
        }
    }

    public TopComponent getTopComponentForID(String stringId) {
        TopComponent tc = this.getTopComponentNonPersistentForID(stringId);
        if (tc == null) {
            return this.getTopComponentPersistentForID(stringId);
        }
        return tc;
    }

    private static DataObject findTopComponentDataObject(FileObject folder, String name) throws IOException {
        FileObject fo = folder.getFileObject(name, COMPONENT_EXT);
        if (fo == null) {
            fo = folder.getFileObject(name, "ser");
        }
        if (fo == null) {
            fo = folder.getFileObject(name, "xml");
        }
        if (fo != null) {
            return DataObject.find((FileObject)fo);
        }
        Enumeration e = folder.getChildren(false);
        while (e.hasMoreElements()) {
            fo = (FileObject)e.nextElement();
            DataObject dob = DataObject.find((FileObject)fo);
            if (!dob.getName().equals(name)) continue;
            return dob;
        }
        DataFolder dfolder = DataFolder.findFolder((FileObject)folder);
        e = dfolder.children();
        while (e.hasMoreElements()) {
            DataObject dob = (DataObject)e.nextElement();
            if (!dob.getName().equals(name)) continue;
            return dob;
        }
        return null;
    }

    private boolean isTopComponentProbablyPersistent(TopComponent tc) {
        int persistenceType = tc.getPersistenceType();
        return 2 != persistenceType;
    }

    public boolean isTopComponentPersistent(TopComponent tc) {
        int persistenceType = tc.getPersistenceType();
        return 2 != persistenceType && (1 != persistenceType || tc.isOpened());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTopComponents(WindowManagerConfig wmc) {
        HashMap copyIdToTopComponentMap;
        DataFolder compsFolder = DataFolder.findFolder((FileObject)this.getComponentsLocalFolder());
        Object object = this.LOCK_IDS;
        synchronized (object) {
            copyIdToTopComponentMap = new HashMap(this.id2TopComponentMap);
        }
        Iterator iter = copyIdToTopComponentMap.entrySet().iterator();
        while (iter.hasNext()) {
            String id;
            String annotation;
            String id2;
            Map.Entry curEntry = iter.next();
            TopComponent curTC = (TopComponent)((WeakReference)curEntry.getValue()).get();
            if (curTC == null) continue;
            try {
                FileObject fo = compsFolder.getPrimaryFile().getFileObject((String)curEntry.getKey(), COMPONENT_EXT);
                DataObject ido = null;
                if (fo != null) {
                    ido = DataObject.find((FileObject)fo);
                }
                if (ido == null) {
                    InstanceDataObject.create((DataFolder)compsFolder, (String)PersistenceManager.unescape((String)curEntry.getKey()), (Object)curTC, null);
                    continue;
                }
                SaveCookie sc = (SaveCookie)ido.getCookie(class$org$openide$cookies$SaveCookie == null ? PersistenceManager.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (sc != null) {
                    sc.save();
                    continue;
                }
                ido.delete();
                InstanceDataObject.create((DataFolder)compsFolder, (String)PersistenceManager.unescape((String)curEntry.getKey()), (Object)curTC, null);
            }
            catch (NotSerializableException nse) {
                id2 = (String)this.topComponent2IDMap.get(curTC);
                this.removeTCFromConfig(wmc, id2);
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify(16, (Throwable)exc);
                id2 = (String)this.topComponent2IDMap.get(curTC);
                this.removeTCFromConfig(wmc, id2);
            }
            catch (RuntimeException exc) {
                annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$persistence$PersistenceManager == null ? PersistenceManager.class$("org.netbeans.core.windows.persistence.PersistenceManager") : class$org$netbeans$core$windows$persistence$PersistenceManager), (String)"EXC_CannotSaveTCSettings", (Object)curTC.getName());
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(1, (Throwable)exc);
                id = (String)this.topComponent2IDMap.get(curTC);
                this.removeTCFromConfig(wmc, id);
            }
            catch (LinkageError le) {
                annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$persistence$PersistenceManager == null ? PersistenceManager.class$("org.netbeans.core.windows.persistence.PersistenceManager") : class$org$netbeans$core$windows$persistence$PersistenceManager), (String)"EXC_CannotSaveTCSettings", (Object)curTC.getName());
                ErrorManager.getDefault().annotate((Throwable)le, annotation);
                ErrorManager.getDefault().notify(1, (Throwable)le);
                id = (String)this.topComponent2IDMap.get(curTC);
                this.removeTCFromConfig(wmc, id);
            }
        }
    }

    private static FileObject findTopComponentRefFile(FileObject folder, String tcId) {
        FileObject result = folder.getFileObject(tcId, TCREF_EXT);
        if (result != null) {
            return result;
        }
        FileObject[] childrenArray = folder.getChildren();
        for (int i = 0; i < childrenArray.length; ++i) {
            if (!childrenArray[i].isFolder() || (result = PersistenceManager.findTopComponentRefFile(childrenArray[i], tcId)) == null) continue;
            return result;
        }
        return null;
    }

    private static String escape(String name) {
        try {
            Method escape = InstanceDataObject.class.getDeclaredMethod("escapeAndCut", String.class);
            escape.setAccessible(true);
            return (String)escape.invoke(null, (Object[])new String[]{name});
        }
        catch (Exception ex) {
            ErrorManager.getDefault().log(16, "Escape support failed");
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return name;
        }
    }

    private static String unescape(String name) {
        try {
            Method unescape = InstanceDataObject.class.getDeclaredMethod("unescape", String.class);
            unescape.setAccessible(true);
            return (String)unescape.invoke(null, (Object[])new String[]{name});
        }
        catch (Exception ex) {
            ErrorManager.getDefault().log(16, "Escape support failed");
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTopComponentNonPersistentID(TopComponent tc, String preferredID) {
        String compName;
        String string = compName = preferredID != null ? preferredID : null;
        if (compName == null || compName.length() == 0) {
            compName = DEFAULT_TC_NAME;
        }
        boolean isUsed = true;
        String srcName = compName = PersistenceManager.escape(compName);
        int i = 1;
        Object object = this.LOCK_IDS;
        synchronized (object) {
            while (isUsed) {
                isUsed = false;
                if (!this.globalIDSet.contains(srcName.toUpperCase(Locale.ENGLISH))) continue;
                isUsed = true;
                srcName = compName + "_" + i;
                ++i;
            }
            this.topComponentNonPersistent2IDMap.put(tc, srcName);
            this.id2TopComponentNonPersistentMap.put(srcName, new WeakReference<TopComponent>(tc));
            this.globalIDSet.add(srcName.toUpperCase(Locale.ENGLISH));
        }
        return srcName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTopComponentPersistentID(TopComponent tc, String preferredID) {
        String compName;
        String string = compName = preferredID != null ? preferredID : null;
        if (compName == null || compName.length() == 0) {
            compName = DEFAULT_TC_NAME;
        }
        boolean isUsed = true;
        String origName = compName;
        String srcName = compName = PersistenceManager.escape(compName);
        int i = 1;
        Object object = this.LOCK_IDS;
        synchronized (object) {
            while (isUsed) {
                isUsed = false;
                String uniqueName = FileUtil.findFreeFileName((FileObject)this.getComponentsLocalFolder(), (String)srcName, (String)COMPONENT_EXT);
                if (srcName.equals(uniqueName) && !this.globalIDSet.contains(uniqueName.toUpperCase(Locale.ENGLISH))) continue;
                isUsed = true;
                srcName = PersistenceManager.escape(origName + "_" + i);
                ++i;
            }
            this.topComponent2IDMap.put(tc, srcName);
            this.id2TopComponentMap.put(srcName, new WeakReference<TopComponent>(tc));
            this.globalIDSet.add(srcName.toUpperCase(Locale.ENGLISH));
        }
        return srcName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String restorePair(TopComponent tc, String id) {
        FileObject fo = this.getComponentsLocalFolder().getFileObject(id, COMPONENT_EXT);
        if (fo != null) {
            Object object = this.LOCK_IDS;
            synchronized (object) {
                this.id2TopComponentMap.put(id, new WeakReference<TopComponent>(tc));
                this.validateId(id);
            }
            return id;
        }
        return null;
    }

    private boolean isInvalidId(String id) {
        return this.invalidIds.contains(id);
    }

    private void validateId(String id) {
        if (this.invalidIds != null) {
            this.invalidIds.remove(id);
        }
    }

    public void annotatePersistenceError(Exception exc, String tcName) {
        if (this.failedCompsMap == null) {
            this.failedCompsMap = new HashMap();
        }
        this.failedCompsMap.put(exc, tcName);
    }

    public void checkPersistenceErrors(boolean reading) {
        if (this.failedCompsMap == null || this.failedCompsMap.isEmpty()) {
            return;
        }
        Iterator it = this.failedCompsMap.keySet().iterator();
        while (it.hasNext()) {
            Exception e = (Exception)it.next();
            Object name = this.failedCompsMap.get(e);
            String message = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$persistence$PersistenceManager == null ? PersistenceManager.class$("org.netbeans.core.windows.persistence.PersistenceManager") : class$org$netbeans$core$windows$persistence$PersistenceManager), (String)(reading ? "FMT_TCReadError" : "FMT_TCWriteError"), (Object[])new Object[]{name});
            ErrorManager.getDefault().annotate((Throwable)e, message);
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        this.failedCompsMap = null;
    }

    public WindowManagerParser getWindowManagerParser() {
        if (this.windowManagerParser == null) {
            this.windowManagerParser = new WindowManagerParser(this, WINDOWMANAGER_FOLDER);
        }
        return this.windowManagerParser;
    }

    public XMLReader getXMLParser(DefaultHandler h) throws SAXException {
        if (this.parser == null) {
            this.parser = XMLUtil.createXMLReader();
            this.parser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    if ("-//NetBeans//DTD Mode Properties 1.0//EN".equals(publicId) || "-//NetBeans//DTD Mode Properties 1.1//EN".equals(publicId) || "-//NetBeans//DTD Mode Properties 1.2//EN".equals(publicId) || "-//NetBeans//DTD Mode Properties 2.0//EN".equals(publicId) || "-//NetBeans//DTD Mode Properties 2.1//EN".equals(publicId) || "-//NetBeans//DTD Group Properties 2.0//EN".equals(publicId) || "-//NetBeans//DTD Top Component in Group Properties 2.0//EN".equals(publicId) || "-//NetBeans//DTD Top Component in Mode Properties 1.0//EN".equals(publicId) || "-//NetBeans//DTD Top Component in Mode Properties 2.0//EN".equals(publicId) || "-//NetBeans//DTD Top Component in Mode Properties 2.1//EN".equals(publicId) || "-//NetBeans//DTD Window Manager Properties 1.0//EN".equals(publicId) || "-//NetBeans//DTD Window Manager Properties 1.1//EN".equals(publicId) || "-//NetBeans//DTD Window Manager Properties 2.0//EN".equals(publicId) || "-//NetBeans//DTD Window Manager Properties 2.1//EN".equals(publicId)) {
                        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
                        return new InputSource(is);
                    }
                    return null;
                }
            });
        }
        this.parser.setContentHandler(h);
        this.parser.setErrorHandler(h);
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUsedTCId(String tc_id) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            this.usedTcIds.add(tc_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUsedTCId(String tc_id) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            this.usedTcIds.remove(tc_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsedTCId(String tc_id) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            return this.usedTcIds.contains(tc_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUsedTCId() {
        String tc_id;
        int i;
        FileObject[] files = this.getComponentsLocalFolder().getChildren();
        for (i = 0; i < files.length; ++i) {
            boolean contains;
            if (files[i].isFolder() || !COMPONENT_EXT.equals(files[i].getExt())) continue;
            tc_id = files[i].getName();
            Object object = this.LOCK_IDS;
            synchronized (object) {
                contains = this.usedTcIds.contains(tc_id);
            }
            if (contains) continue;
            PersistenceManager.deleteOneFO(files[i]);
        }
        files = this.getComponentsLocalFolder().getChildren();
        for (i = 0; i < files.length; ++i) {
            if (files[i].isFolder() || !COMPONENT_EXT.equals(files[i].getExt())) continue;
            tc_id = files[i].getName();
            Object object = this.LOCK_IDS;
            synchronized (object) {
                this.globalIDSet.add(tc_id.toUpperCase(Locale.ENGLISH));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowManagerConfig loadWindowSystem() {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            this.usedTcIds.clear();
        }
        this.copySettingsFiles();
        WindowManagerParser wmParser = this.getWindowManagerParser();
        WindowManagerConfig wmc = null;
        try {
            wmc = wmParser.load();
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify(16, (Throwable)exc);
        }
        this.checkUsedTCId();
        if (this.changeHandler == null) {
            this.changeHandler = new ModuleChangeHandler();
            this.changeHandler.startHandling();
        }
        this.parser = null;
        return wmc;
    }

    public void saveWindowSystem(WindowManagerConfig wmc) {
        WindowManagerParser wmParser = this.getWindowManagerParser();
        try {
            this.saveTopComponents(wmc);
            wmParser.save(wmc);
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify(16, (Throwable)exc);
        }
    }

    private void removeTCFromConfig(WindowManagerConfig wmc, String id) {
        int j;
        int i;
        boolean removeFromRecent = false;
        for (i = 0; i < wmc.tcIdViewList.length; ++i) {
            if (!id.equals(wmc.tcIdViewList[i])) continue;
            removeFromRecent = true;
            break;
        }
        if (removeFromRecent) {
            ArrayList<String> l = new ArrayList<String>(wmc.tcIdViewList.length);
            for (int i2 = 0; i2 < wmc.tcIdViewList.length; ++i2) {
                if (id.equals(wmc.tcIdViewList[i2])) continue;
                l.add(wmc.tcIdViewList[i2]);
            }
            wmc.tcIdViewList = l.toArray(new String[l.size()]);
        }
        for (i = 0; i < wmc.modes.length; ++i) {
            ModeConfig mc = wmc.modes[i];
            if (id.equals(mc.selectedTopComponentID)) {
                mc.selectedTopComponentID = "";
            }
            boolean removeFromMode = false;
            for (int j2 = 0; j2 < mc.tcRefConfigs.length; ++j2) {
                if (!id.equals(mc.tcRefConfigs[j2].tc_id)) continue;
                removeFromMode = true;
                break;
            }
            if (!removeFromMode) continue;
            ArrayList<TCRefConfig> l = new ArrayList<TCRefConfig>(mc.tcRefConfigs.length);
            for (j = 0; j < mc.tcRefConfigs.length; ++j) {
                if (id.equals(mc.tcRefConfigs[j].tc_id)) continue;
                l.add(mc.tcRefConfigs[j]);
            }
            mc.tcRefConfigs = l.toArray(new TCRefConfig[l.size()]);
        }
        for (i = 0; i < wmc.groups.length; ++i) {
            GroupConfig gc = wmc.groups[i];
            boolean removeFromGroup = false;
            for (int j3 = 0; j3 < gc.tcGroupConfigs.length; ++j3) {
                if (!id.equals(gc.tcGroupConfigs[j3].tc_id)) continue;
                removeFromGroup = true;
                break;
            }
            if (!removeFromGroup) continue;
            ArrayList<TCGroupConfig> l = new ArrayList<TCGroupConfig>(gc.tcGroupConfigs.length);
            for (j = 0; j < gc.tcGroupConfigs.length; ++j) {
                if (id.equals(gc.tcGroupConfigs[j].tc_id)) continue;
                l.add(gc.tcGroupConfigs[j]);
            }
            gc.tcGroupConfigs = l.toArray(new TCGroupConfig[l.size()]);
        }
    }

    private void copySettingsFiles() {
        if (DEBUG) {
            Debug.log(PersistenceManager.class, "copySettingsFiles ENTER");
        }
        HashSet<String> localSet = new HashSet<String>(100);
        FileObject[] filesLocal = this.getComponentsLocalFolder().getChildren();
        for (int i = 0; i < filesLocal.length; ++i) {
            if (filesLocal[i].isFolder() || !COMPONENT_EXT.equals(filesLocal[i].getExt())) continue;
            localSet.add(filesLocal[i].getName());
        }
        FileObject[] filesModule = this.getComponentsModuleFolder().getChildren();
        for (int i = 0; i < filesModule.length; ++i) {
            if (filesModule[i].isFolder() || !COMPONENT_EXT.equals(filesModule[i].getExt()) || localSet.contains(filesModule[i].getName())) continue;
            this.copySettingsFile(filesModule[i]);
        }
        if (DEBUG) {
            Debug.log(PersistenceManager.class, "copySettingsFiles LEAVE");
        }
    }

    private void copySettingsFile(FileObject fo) {
        if (DEBUG) {
            Debug.log(PersistenceManager.class, "copySettingsFile fo:" + fo);
        }
        FileObject destFolder = this.getComponentsLocalFolder();
        try {
            fo.copy(destFolder, fo.getName(), fo.getExt());
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)PersistenceManager.class, (String)"EXC_CopyFails", (Object)destFolder);
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(1, (Throwable)exc);
        }
    }

    void copySettingsFileIfNeeded(FileObject fo) {
        FileObject localSettingsFO = this.getComponentsLocalFolder().getFileObject(fo.getNameExt());
        if (localSettingsFO == null) {
            this.copySettingsFile(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOneFO(FileObject fo) {
        FileLock lock = null;
        if (fo.isValid()) {
            try {
                lock = fo.lock();
                fo.delete(lock);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    static final ModuleInfo findModule(String codeNameBase, String strRelease, String strSpec) {
        SpecificationVersion spec = null;
        int release = -1;
        if (strRelease != null) {
            try {
                release = Integer.parseInt(strRelease);
            }
            catch (NumberFormatException nfe) {
                ErrorManager.getDefault().notify(16, (Throwable)nfe);
            }
        }
        if (strSpec != null) {
            spec = new SpecificationVersion(strSpec);
        }
        Lookup.Result modulesResult = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        Collection infos = modulesResult.allInstances();
        ModuleInfo curInfo = null;
        Iterator iter = infos.iterator();
        while (iter.hasNext()) {
            curInfo = (ModuleInfo)iter.next();
            if (!curInfo.getCodeNameBase().equals(codeNameBase)) continue;
            if (release < 0 && spec == null || curInfo.getCodeNameRelease() > release) {
                return curInfo;
            }
            if (release >= 0 && curInfo.getCodeNameRelease() != release || spec != null && curInfo.getSpecificationVersion().compareTo((Object)spec) < 0) continue;
            return curInfo;
        }
        return null;
    }

    public static String escapeTcId4XmlContent(String tcName) {
        if (tcName.indexOf(38) != -1 || tcName.indexOf(39) != -1) {
            tcName = tcName.replaceAll("&", "&amp;");
            tcName = tcName.replaceAll("'", "&apos;");
        }
        return tcName;
    }
}

