/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.util;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.FlatFolder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Utils {
    private static Node[] contextNodesCached;
    private static Context contextCached;
    static /* synthetic */ Class class$org$netbeans$modules$versioning$system$cvss$CvsFileNode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Context getCurrentContext(Node[] nodes) {
        if (nodes == null) {
            nodes = TopComponent.getRegistry().getActivatedNodes();
        }
        if (Arrays.equals(contextNodesCached, nodes)) {
            return contextCached;
        }
        ArrayList<File> files = new ArrayList<File>(nodes.length);
        ArrayList<File> rootFiles = new ArrayList<File>(nodes.length);
        ArrayList rootFileExclusions = new ArrayList(5);
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            CvsFileNode cvsNode = (CvsFileNode)node.getLookup().lookup(class$org$netbeans$modules$versioning$system$cvss$CvsFileNode == null ? Utils.class$("org.netbeans.modules.versioning.system.cvss.CvsFileNode") : class$org$netbeans$modules$versioning$system$cvss$CvsFileNode);
            if (cvsNode != null) {
                files.add(cvsNode.getFile());
                rootFiles.add(cvsNode.getFile());
                continue;
            }
            Project project = (Project)node.getLookup().lookup(class$org$netbeans$api$project$Project == null ? Utils.class$("org.netbeans.api.project.Project") : class$org$netbeans$api$project$Project);
            if (project != null) {
                Utils.addProjectFiles(files, rootFiles, rootFileExclusions, project);
                continue;
            }
            Utils.addFileObjects(node, files, rootFiles);
        }
        contextCached = new Context(files, rootFiles, rootFileExclusions);
        contextNodesCached = nodes;
        return contextCached;
    }

    public static Context getCurrentContext(Node[] nodes, int includingFileStatus, int includingFolderStatus) {
        Context context = Utils.getCurrentContext(nodes);
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        File[] files = context.getRootFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            FileInformation fi = cache.getStatus(file);
            if (!(file.isDirectory() ? (fi.getStatus() & includingFolderStatus) == 0 : (fi.getStatus() & includingFileStatus) == 0)) continue;
            return Context.Empty;
        }
        return context;
    }

    public static boolean isVersionedProject(Node node) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return Utils.isVersionedProject(project);
    }

    public static boolean isVersionedProject(Project project) {
        if (project != null) {
            FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            for (int j = 0; j < sourceGroups.length; ++j) {
                SourceGroup sourceGroup = sourceGroups[j];
                File f = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
                if (f == null || (cache.getStatus(f).getStatus() & 0xFFFFFFFE) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static void addFileObjects(Node node, List files, List rootFiles) {
        Collection folders = node.getLookup().lookup(new Lookup.Template(NonRecursiveFolder.class)).allInstances();
        ArrayList<FlatFolder> nodeFiles = new ArrayList<FlatFolder>();
        if (folders.size() > 0) {
            Iterator j = folders.iterator();
            while (j.hasNext()) {
                NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)j.next();
                nodeFiles.add(new FlatFolder(FileUtil.toFile((FileObject)nonRecursiveFolder.getFolder()).getAbsolutePath()));
            }
        } else {
            Collection fileObjects = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (fileObjects.size() > 0) {
                nodeFiles.addAll(Utils.toFileCollection(fileObjects));
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    Collection doFiles = Utils.toFileCollection(dataObject.files());
                    nodeFiles.addAll(doFiles);
                }
            }
        }
        files.addAll(nodeFiles);
        rootFiles.addAll(nodeFiles);
    }

    public static void addProjectFiles(Collection filteredFiles, Collection rootFiles, Collection rootFilesExclusions, Project project) {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        for (int j = 0; j < sourceGroups.length; ++j) {
            SourceGroup sourceGroup = sourceGroups[j];
            FileObject srcRootFo = sourceGroup.getRootFolder();
            File rootFile = FileUtil.toFile((FileObject)srcRootFo);
            try {
                Utils.getCVSRootFor(rootFile);
            }
            catch (IOException e) {
                continue;
            }
            rootFiles.add(rootFile);
            boolean containsSubprojects = false;
            FileObject[] rootChildren = srcRootFo.getChildren();
            HashSet<File> projectFiles = new HashSet<File>(rootChildren.length);
            for (int i = 0; i < rootChildren.length; ++i) {
                FileObject rootChildFo = rootChildren[i];
                if ("CVS".equals(rootChildFo.getNameExt())) continue;
                File child = FileUtil.toFile((FileObject)rootChildFo);
                if (sourceGroup.contains(rootChildFo) || ".cvsignore".equals(rootChildFo.getNameExt())) {
                    projectFiles.add(child);
                    continue;
                }
                int status = cache.getStatus(child).getStatus();
                if (status == 2) continue;
                rootFilesExclusions.add(child);
                containsSubprojects = true;
            }
            if (containsSubprojects) {
                filteredFiles.addAll(projectFiles);
                continue;
            }
            filteredFiles.add(rootFile);
        }
    }

    public static Context getProjectsContext(Project[] projects) {
        ArrayList filtered = new ArrayList();
        ArrayList roots = new ArrayList();
        ArrayList exclusions = new ArrayList();
        for (int i = 0; i < projects.length; ++i) {
            Utils.addProjectFiles(filtered, roots, exclusions, projects[i]);
        }
        return new Context(filtered, roots, exclusions);
    }

    private static Collection toFileCollection(Collection fileObjects) {
        HashSet<File> files = new HashSet<File>(fileObjects.size() * 4 / 3 + 1);
        Iterator i = fileObjects.iterator();
        while (i.hasNext()) {
            files.add(FileUtil.toFile((FileObject)((FileObject)i.next())));
        }
        files.remove(null);
        return files;
    }

    public static File[] toFileArray(Collection fileObjects) {
        HashSet<File> files = new HashSet<File>(fileObjects.size() * 4 / 3 + 1);
        Iterator i = fileObjects.iterator();
        while (i.hasNext()) {
            files.add(FileUtil.toFile((FileObject)((FileObject)i.next())));
        }
        files.remove(null);
        return files.toArray(new File[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCVSRootFor(File file) throws IOException {
        if (file.isFile()) {
            file = file.getParentFile();
        }
        while (true) {
            block10: {
                Object var5_5;
                String string;
                if (file == null) {
                    throw new IOException("CVS/Root not found");
                }
                File rootFile = new File(file, "CVS/Root");
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new FileReader(rootFile));
                        string = br.readLine();
                        var5_5 = null;
                        if (br == null) return string;
                    }
                    catch (FileNotFoundException e) {
                        var5_5 = null;
                        if (br != null) {
                            br.close();
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = null;
                    if (br != null) {
                        br.close();
                    }
                    throw throwable;
                }
                br.close();
                return string;
            }
            file = file.getParentFile();
        }
    }

    public static Window getCurrentWindow() {
        Window wnd = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (wnd instanceof Dialog || wnd instanceof Frame) {
            return wnd;
        }
        return WindowManager.getDefault().getMainWindow();
    }

    public static String getStackTrace() {
        Exception e = new Exception();
        e.fillInStackTrace();
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static boolean isParentOrEqual(File parent, File file) {
        while (file != null) {
            if (file.equals(parent)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static String getRelativePath(File file) {
        try {
            return CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParent(), "").substring(1);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getSticky(File file) {
        if (file == null) {
            return null;
        }
        FileInformation info = CvsVersioningSystem.getInstance().getStatusCache().getStatus(file);
        Entry entry = info.getEntry(file);
        if (entry != null) {
            if (file.isDirectory()) {
                return CvsVersioningSystem.getInstance().getAdminHandler().getStickyTagForDirectory(file);
            }
            String stickyInfo = null;
            if (entry.getTag() != null) {
                stickyInfo = "T" + entry.getTag();
            } else if (entry.getDate() != null) {
                stickyInfo = "D" + entry.getDateFormatted();
            }
            return stickyInfo;
        }
        if (info.getStatus() == 4) {
            if ((file = file.getParentFile()) == null) {
                return null;
            }
            int status = CvsVersioningSystem.getInstance().getStatusCache().getStatus(file).getStatus();
            if (status == 8) {
                String stickyTag = CvsVersioningSystem.getInstance().getAdminHandler().getStickyTagForDirectory(file);
                return stickyTag == null ? null : stickyTag;
            }
            if (status == 2) {
                return null;
            }
            return Utils.getSticky(file);
        }
        return null;
    }

    public static String previousRevision(String revision) {
        int lastIndex;
        if (revision == null) {
            return null;
        }
        String[] nums = revision.split("\\.");
        if (!$assertionsDisabled && nums.length % 2 != 0) {
            throw new AssertionError((Object)("File revisions must consist from even tokens: " + revision));
        }
        boolean cutoff = false;
        for (lastIndex = nums.length - 1; lastIndex > 1 && "1".equals(nums[lastIndex]); lastIndex -= 2) {
            cutoff = true;
        }
        if (lastIndex <= 0) {
            return null;
        }
        if (lastIndex == 1 && "1".equals(nums[lastIndex])) {
            return null;
        }
        int rev = Integer.parseInt(nums[lastIndex]);
        if (!cutoff) {
            --rev;
        }
        StringBuffer sb = new StringBuffer(nums[0]);
        for (int i = 1; i < lastIndex; ++i) {
            sb.append('.').append(nums[i]);
        }
        sb.append('.').append(rev);
        return sb.toString();
    }

    public static Project getProject(File file) {
        if (file == null) {
            return null;
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return Utils.getProject(file.getParentFile());
        }
        return FileOwnerQuery.getOwner((FileObject)fo);
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Utils.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static File getCommonParent(File a, File b) {
        do {
            if (!a.equals(b)) continue;
            return a;
        } while (!(a.getAbsolutePath().length() > b.getAbsolutePath().length() ? (a = a.getParentFile()) == null : (b = b.getParentFile()) == null));
        return null;
    }

    public static File[][] splitFlatOthers(File[] files) {
        HashSet<File> flat = new HashSet<File>(1);
        for (int i = 0; i < files.length; ++i) {
            if (!(files[i] instanceof FlatFolder)) continue;
            flat.add(files[i]);
        }
        if (flat.size() == 0) {
            return new File[][]{new File[0], files};
        }
        HashSet<File> allFiles = new HashSet<File>(Arrays.asList(files));
        allFiles.removeAll(flat);
        return new File[][]{flat.toArray(new File[flat.size()]), allFiles.toArray(new File[allFiles.size()])};
    }

    public static int getComparableStatus(int status) {
        switch (status) {
            case 64: {
                return 0;
            }
            case 128: {
                return 1;
            }
            case 2048: {
                return 10;
            }
            case 256: {
                return 11;
            }
            case 4: {
                return 12;
            }
            case 4096: {
                return 13;
            }
            case 16: {
                return 14;
            }
            case 1024: {
                return 30;
            }
            case 512: {
                return 31;
            }
            case 32: {
                return 32;
            }
            case 8: {
                return 50;
            }
            case 2: {
                return 100;
            }
            case 1: {
                return 101;
            }
            case 0: {
                return 102;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    public static FileObject mkfolders(File file) throws IOException {
        if (file.isDirectory()) {
            return FileUtil.toFileObject((File)file);
        }
        File parent = file.getParentFile();
        String path = file.getName();
        while (!parent.isDirectory()) {
            path = parent.getName() + "/" + path;
            parent = parent.getParentFile();
        }
        FileObject fo = FileUtil.toFileObject((File)parent);
        return FileUtil.createFolder((FileObject)fo, (String)path);
    }

    static {
        $assertionsDisabled = !Utils.class.desiredAssertionStatus();
    }

    public static class ByImportanceComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            FileInformation i1 = (FileInformation)o1;
            FileInformation i2 = (FileInformation)o2;
            return Utils.getComparableStatus(i1.getStatus()) - Utils.getComparableStatus(i2.getStatus());
        }
    }
}

