/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class FileChangeSupport {
    public static FileChangeSupport DEFAULT;
    private final Map holders = new WeakHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    private FileChangeSupport() {
    }

    public void addListener(FileChangeSupportListener listener, File path) {
        if (!$assertionsDisabled && !path.equals(FileUtil.normalizeFile((File)path))) {
            throw new AssertionError((Object)("Need to normalize " + path + " before passing to FCS!"));
        }
        HashMap<File, Holder> f2H = (HashMap<File, Holder>)this.holders.get(listener);
        if (f2H == null) {
            f2H = new HashMap<File, Holder>();
            this.holders.put(listener, f2H);
        }
        if (f2H.containsKey(path)) {
            throw new IllegalArgumentException("Already listening to " + path);
        }
        f2H.put(path, new Holder(listener, path));
    }

    public void removeListener(FileChangeSupportListener listener, File path) {
        if (!$assertionsDisabled && !path.equals(FileUtil.normalizeFile((File)path))) {
            throw new AssertionError((Object)("Need to normalize " + path + " before passing to FCS!"));
        }
        Map f2H = (Map)this.holders.get(listener);
        if (f2H == null) {
            throw new IllegalArgumentException("Was not listening to " + path);
        }
        if (!f2H.containsKey(path)) {
            throw new IllegalArgumentException("Was not listening to " + path);
        }
        f2H.remove(path);
    }

    static {
        $assertionsDisabled = !FileChangeSupport.class.desiredAssertionStatus();
        DEFAULT = new FileChangeSupport();
    }

    private static final class Holder
    extends WeakReference
    implements FileChangeListener,
    Runnable {
        private final File path;
        private FileObject current;
        private File currentF;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Holder(FileChangeSupportListener listener, File path) {
            super(listener, Utilities.activeReferenceQueue());
            if (!$assertionsDisabled && path == null) {
                throw new AssertionError();
            }
            this.path = path;
            this.locateCurrent();
        }

        private void locateCurrent() {
            FileObject oldCurrent;
            block4: {
                oldCurrent = this.current;
                this.currentF = this.path;
                do {
                    this.current = FileUtil.toFileObject((File)this.currentF);
                    if (this.current != null) break block4;
                    this.currentF = this.currentF.getParentFile();
                } while (this.currentF != null);
                return;
            }
            if (!$assertionsDisabled && this.current == null) {
                throw new AssertionError();
            }
            if (this.current != oldCurrent) {
                if (oldCurrent != null) {
                    oldCurrent.removeFileChangeListener((FileChangeListener)this);
                }
                this.current.addFileChangeListener((FileChangeListener)this);
                this.current.getChildren();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void someChange(FileObject modified) {
            File nueCurrentF;
            FileObject nueCurrent;
            File oldCurrentF;
            FileChangeSupportListener listener;
            Holder holder = this;
            synchronized (holder) {
                if (this.current == null) {
                    return;
                }
                listener = (FileChangeSupportListener)this.get();
                if (listener == null) {
                    return;
                }
                FileObject oldCurrent = this.current;
                oldCurrentF = this.currentF;
                this.locateCurrent();
                nueCurrent = this.current;
                nueCurrentF = this.currentF;
            }
            if (modified != null && modified == nueCurrent) {
                FileChangeSupportEvent event = new FileChangeSupportEvent(DEFAULT, 2, this.path);
                listener.fileModified(event);
            } else {
                boolean oldWasCorrect = this.path.equals(oldCurrentF);
                boolean nueIsCorrect = this.path.equals(nueCurrentF);
                if (oldWasCorrect && !nueIsCorrect) {
                    FileChangeSupportEvent event = new FileChangeSupportEvent(DEFAULT, 1, this.path);
                    listener.fileDeleted(event);
                } else if (nueIsCorrect && !oldWasCorrect) {
                    FileChangeSupportEvent event = new FileChangeSupportEvent(DEFAULT, 0, this.path);
                    listener.fileCreated(event);
                }
            }
        }

        public void fileChanged(FileEvent fe) {
            this.someChange(fe.getFile());
        }

        public void fileDeleted(FileEvent fe) {
            this.someChange(null);
        }

        public void fileDataCreated(FileEvent fe) {
            this.someChange(null);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.someChange(null);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.someChange(null);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public synchronized void run() {
            if (this.current != null) {
                this.current.removeFileChangeListener((FileChangeListener)this);
                this.current = null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$project$ant$FileChangeSupport == null ? (class$org$netbeans$modules$project$ant$FileChangeSupport = FileChangeSupport.class$("org.netbeans.modules.project.ant.FileChangeSupport")) : class$org$netbeans$modules$project$ant$FileChangeSupport).desiredAssertionStatus();
        }
    }
}

