/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.hyperlink;

import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public final class JavaHyperlinkProvider
implements HyperlinkProvider {
    private static final int TOKEN_LIMIT = 100;
    private static MessageFormat mf = null;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

    private String findName(BaseDocument doc, int offset) {
        String name = "";
        SyntaxSupport sup = doc.getSyntaxSupport();
        NbJavaJMISyntaxSupport nbJavaSup = (NbJavaJMISyntaxSupport)sup.get(NbJavaJMISyntaxSupport.class);
        boolean wasIdentifier = false;
        int tokenLimitCounter = 0;
        try {
            while (tokenLimitCounter < 100) {
                TokenID token = nbJavaSup.getTokenID(offset);
                ++tokenLimitCounter;
                if (token == JavaTokenContext.IDENTIFIER && !wasIdentifier) {
                    int[] span = Utilities.getIdentifierBlock((BaseDocument)doc, (int)offset);
                    name = doc.getText(span) + name;
                    offset = span[0] - 1;
                    wasIdentifier = true;
                    continue;
                }
                if (token == JavaTokenContext.DOT) {
                    --offset;
                    name = "." + name;
                    wasIdentifier = false;
                    continue;
                }
                if (token == JavaTokenContext.WHITESPACE || token == JavaTokenContext.BLOCK_COMMENT || token == JavaTokenContext.LINE_COMMENT) {
                    --offset;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return "<unknown>";
        }
        return name;
    }

    public void performClickAction(Document originalDoc, final int offset) {
        if (!(originalDoc instanceof BaseDocument)) {
            return;
        }
        final BaseDocument doc = (BaseDocument)originalDoc;
        final JTextComponent target = Utilities.getFocusedComponent();
        if (target == null || target.getDocument() != doc) {
            return;
        }
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SyntaxSupport sup = doc.getSyntaxSupport();
                NbJavaJMISyntaxSupport nbJavaSup = (NbJavaJMISyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaHyperlinkProvider.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
                JMIUtils jmiUtils = JMIUtils.get(doc);
                Object item = null;
                String itemDesc = null;
                jmiUtils.beginTrans(false);
                try {
                    item = JMIUtils.findItemAtCaretPos(target);
                    if (item instanceof NbJMIResultItem.VarResultItem) {
                        int pos = nbJavaSup.findLocalDeclarationPosition(((NbJMIResultItem.VarResultItem)item).getItemText(), target.getCaretPosition());
                        if (pos != -1) {
                            target.setCaretPosition(pos);
                        }
                    } else {
                        if (item instanceof ClassDefinition) {
                            item = JMIUtils.getSourceElementIfExists((ClassDefinition)item);
                        }
                        if (item == null || item instanceof JavaPackage || (itemDesc = nbJavaSup.openSource(item, true)) != null) {
                            String name;
                            String key;
                            Toolkit.getDefaultToolkit().beep();
                            if (itemDesc != null) {
                                key = "goto_source_source_not_found";
                                name = itemDesc;
                            } else {
                                key = "cannot-open-element";
                                name = JavaHyperlinkProvider.this.findName(doc, offset);
                            }
                            String msg = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaHyperlinkProvider.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(key);
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(msg, name));
                        }
                    }
                }
                finally {
                    jmiUtils.endTrans(false);
                }
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(run, NbBundle.getMessage((Class)BaseDocument.class, (String)"goto-source"));
    }

    public boolean isHyperlinkPoint(Document doc, int offset) {
        if (!(doc instanceof BaseDocument)) {
            return false;
        }
        try {
            BaseDocument bdoc = (BaseDocument)doc;
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null || target.getDocument() != bdoc) {
                return false;
            }
            SyntaxSupport sup = bdoc.getSyntaxSupport();
            NbJavaJMISyntaxSupport nbJavaSup = (NbJavaJMISyntaxSupport)sup.get(NbJavaJMISyntaxSupport.class);
            TokenID token = nbJavaSup.getTokenID(offset);
            return token == JavaTokenContext.IDENTIFIER || token == JavaTokenContext.THIS || token == JavaTokenContext.SUPER;
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        if (!(doc instanceof BaseDocument)) {
            return null;
        }
        try {
            if (this.isHyperlinkPoint(doc, offset)) {
                return Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)doc), (int)offset);
            }
            return null;
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }
}

