/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Toolkit;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JavaFastOpen;
import org.netbeans.modules.editor.java.JCFinderFactory;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.java.editor.options.JavaOptions;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class NbJavaFastOpen
extends JavaFastOpen {
    protected JCFinder getFinder() {
        return JCFinderFactory.getDefault().getGlobalFinder();
    }

    protected List findClasses(String exp, boolean caseSensitive, boolean includeInnerClasses, boolean includeLibraryClasses) {
        ArrayList<JCResultItem.ClassResultItem> ret = new ArrayList<JCResultItem.ClassResultItem>();
        JCFinder finder = this.getFinder();
        List classes = finder.findClasses(null, exp, false);
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            JCClass cls = (JCClass)it.next();
            if (cls.getName().indexOf(46) != -1) continue;
            ret.add(new JCResultItem.ClassResultItem(cls, true));
        }
        return ret;
    }

    public static void showFastOpen() {
        JEditorPane[] openedPanes;
        EditorCookie ec;
        Node[] arr = TopComponent.getRegistry().getActivatedNodes();
        String initSearchText = null;
        if (arr.length > 0 && (ec = (EditorCookie)arr[0].getCookie(EditorCookie.class)) != null && (openedPanes = ec.getOpenedPanes()) != null && (initSearchText = Utilities.getSelectionOrIdentifier((JTextComponent)openedPanes[0])) != null) {
            JCFinder finder;
            List l;
            if (BaseOptions.getOptions((Class)JavaKit.class) instanceof JavaOptions) {
                JavaOptions jo = (JavaOptions)BaseOptions.getOptions((Class)JavaKit.class);
            }
            if ((l = (finder = JCFinderFactory.getDefault().getGlobalFinder()).findClasses(null, initSearchText, false)).size() < 1) {
                initSearchText = null;
            }
        }
        if (fastOpen == null) {
            RequestProcessor.getDefault().post((Runnable)new ShowDialogRunnable(initSearchText));
        } else {
            new ShowDialogRunnable(initSearchText).run();
        }
    }

    private void openSourceFO(FileObject fo) {
        DataObject dob;
        try {
            dob = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            dob = null;
        }
        if (dob != null) {
            EditCookie ec = (EditCookie)dob.getCookie(EditCookie.class);
            if (ec != null) {
                ec.edit();
            } else {
                OpenCookie oc = (OpenCookie)dob.getCookie(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    protected void openSource(Object item, int order) {
        JCClass cls = null;
        if (item instanceof JCClass) {
            cls = (JCClass)item;
        } else if (item instanceof JCResultItem.ClassResultItem) {
            cls = (JCClass)((JCResultItem.ClassResultItem)item).getAssociatedObject();
        }
        if (cls != null) {
            FileObject fo = this.findResource(cls, order);
            if (fo != null) {
                this.openSourceFO(fo);
            } else {
                String msg = NbBundle.getBundle((Class)JavaKit.class).getString("goto_source_source_not_found");
                msg = MessageFormat.format(msg, cls.getFullName());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            }
        }
    }

    private FileObject findResource(JCClass cls, int order) {
        HashMap<Object, Object> alreadyTested = new HashMap<Object, Object>();
        String name = cls.getPackageName().replace('.', '/') + "/" + cls.getName() + ".java";
        Set set = GlobalPathRegistry.getDefault().getPaths("classpath/source");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            if (alreadyTested.get(cp) != null) continue;
            alreadyTested.put(cp, cp);
            FileObject fo = cp.findResource(name);
            if (fo == null) continue;
            if (order == 0) {
                return fo;
            }
            --order;
        }
        ArrayList list = new ArrayList(GlobalPathRegistry.getDefault().getPaths("classpath/compile"));
        list.addAll(GlobalPathRegistry.getDefault().getPaths("classpath/boot"));
        it = list.iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            if (alreadyTested.get(cp) != null) continue;
            alreadyTested.put(cp, cp);
            Iterator it2 = cp.entries().iterator();
            while (it2.hasNext()) {
                ClassPath sources;
                FileObject fo;
                ClassPath.Entry entry = (ClassPath.Entry)it2.next();
                FileObject[] sroots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots();
                List<FileObject> ll = Arrays.asList(sroots);
                if (alreadyTested.get(ll) != null) continue;
                alreadyTested.put(ll, ll);
                if (sroots.length <= 0 || (fo = (sources = ClassPathSupport.createClassPath((FileObject[])sroots)).findResource(name)) == null) continue;
                if (order == 0) {
                    return fo;
                }
                --order;
            }
            FileObject fo = cp.findResource(name);
            if (fo == null) continue;
            if (order == 0) {
                return fo;
            }
            --order;
        }
        return null;
    }

    protected Class getKitClass() {
        return JavaKit.class;
    }

    protected void setCaseSensitive(boolean caseSensitive) {
        BaseOptions bop;
        Class kitClass = this.getKitClass();
        if (kitClass != null && (bop = BaseOptions.getOptions((Class)kitClass)) instanceof JavaOptions) {
            ((JavaOptions)bop).setGotoClassCaseSensitive(caseSensitive);
        }
    }

    protected void setIncludeInnerClasses(boolean includeInnerClasses) {
        BaseOptions bop;
        Class kitClass = this.getKitClass();
        if (kitClass != null && (bop = BaseOptions.getOptions((Class)kitClass)) instanceof JavaOptions) {
            ((JavaOptions)bop).setGotoClassShowInnerClasses(includeInnerClasses);
        }
    }

    protected void setIncludeLibraryClasses(boolean includeLibraryClasses) {
        BaseOptions bop;
        Class kitClass = this.getKitClass();
        if (kitClass != null && (bop = BaseOptions.getOptions((Class)kitClass)) instanceof JavaOptions) {
            ((JavaOptions)bop).setGotoClassShowLibraryClasses(includeLibraryClasses);
        }
    }

    private static class ShowDialogRunnable
    implements Runnable {
        private final String searchText;
        private boolean postToEDT;

        ShowDialogRunnable(String searchText) {
            this.searchText = searchText;
            this.postToEDT = true;
        }

        public void run() {
            if (this.postToEDT) {
                this.postToEDT = false;
                Utilities.runInEventDispatchThread((Runnable)this);
            } else {
                if (fastOpen == null) {
                    fastOpen = new NbJavaFastOpen();
                }
                if (this.searchText != null) {
                    fastOpen.setSearchText(this.searchText);
                }
                fastOpen.setDialogVisible(true);
            }
        }
    }
}

