/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JavaCompletionJavaDoc;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.HTMLJavadocParser;
import org.netbeans.modules.editor.java.JCExtension;
import org.netbeans.modules.editor.java.JCFinderFactory;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.modules.editor.java.NbScrollJavaDocPane;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocTag;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NbCompletionJavaDoc
extends JavaCompletionJavaDoc {
    ParsingThread task = null;
    public static final String CONTENT_NOT_FOUND;
    private String lastBase = "";
    private boolean goToSourceEnabled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NbCompletionJavaDoc(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    protected JCFinder getFinder() {
        BaseDocument doc = Utilities.getDocument((JTextComponent)this.extEditorUI.getComponent());
        if (!$assertionsDisabled && doc == null) {
            throw new AssertionError();
        }
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        if (!$assertionsDisabled && dobj == null) {
            throw new AssertionError();
        }
        FileObject fo = dobj.getPrimaryFile();
        return JCFinderFactory.getDefault().getFinder(fo);
    }

    protected CompletionJavaDoc.JavaDocTagItem[] getJavaDocTags(JavaDocTag[] jdt) {
        CompletionJavaDoc.JavaDocTagItem[] ret = new CompletionJavaDoc.JavaDocTagItem[jdt.length];
        for (int i = 0; i < jdt.length; ++i) {
            ret[i] = new JavaDocTagItemImpl(jdt[i].name(), jdt[i].text());
        }
        return ret;
    }

    protected boolean isGoToSourceEnabled() {
        return this.goToSourceEnabled;
    }

    protected void setGoToSourceEnabled(boolean enabled) {
        JavaDocPane jdp = this.getJavaDocPane();
        if (jdp instanceof NbScrollJavaDocPane) {
            ((NbScrollJavaDocPane)jdp).setGoToSourceEnabled(enabled);
        }
    }

    protected ClassElement getClassElement(String clsFullName) {
        ClassElement ce = null;
        if (clsFullName == null) {
            return null;
        }
        try {
            BaseDocument bDoc = this.extEditorUI.getDocument();
            if (bDoc == null) {
                return null;
            }
            DataObject dobj = NbEditorUtilities.getDataObject((Document)bDoc);
            if (dobj == null) {
                return null;
            }
            FileObject fo = dobj.getPrimaryFile();
            ce = ClassElement.forName((String)clsFullName, (FileObject)fo);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            System.err.println("Error occurred during name resolving");
            t.printStackTrace();
        }
        return ce;
    }

    protected ParsingThread setInRequestProcessorThread(Object content) {
        ParsingThread pt = new ParsingThread(content);
        RequestProcessor.getDefault().post((Runnable)pt);
        return pt;
    }

    public void cancelPerformingThread() {
        super.cancelPerformingThread();
        if (this.task != null) {
            this.task.stopTask();
        }
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (this.task != null) {
            this.task.stopTask();
        }
        this.task = this.setInRequestProcessorThread(this.getCurrentContent());
    }

    public void goToSource() {
        SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)this.extEditorUI.getComponent());
        NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(NbJavaSyntaxSupport.class);
        if (nbJavaSup.openSource(this.getCurrentContent(), false) == null) {
            this.extEditorUI.getCompletion().setPaneVisible(false);
        }
    }

    public void openInExternalBrowser() {
        URL url;
        SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)this.extEditorUI.getComponent());
        NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(NbJavaSyntaxSupport.class);
        Object currentContent = this.getCurrentContent();
        if (currentContent instanceof URL) {
            HtmlBrowser.URLDisplayer.getDefault().showURL((URL)currentContent);
        } else if (currentContent instanceof String && (url = this.mergeRelLink(this.lastBase, (String)currentContent)) != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        URL[] urls = nbJavaSup.getJavaDocURLs(currentContent);
        if (urls != null && urls.length > 0) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(urls[0]);
        }
    }

    protected String findProperClass(String name, String pkgName) {
        List classes;
        if (name == null) {
            return null;
        }
        String ret = null;
        if (pkgName != null && pkgName.length() > 0) {
            if (this.getClassElement(pkgName + "." + name) != null) {
                return pkgName + "." + name;
            }
        } else if (this.getClassElement(name) != null) {
            return name;
        }
        if ((classes = this.getFinder().findClasses(null, name, true)).size() > 0 && this.getClassElement(ret = ((JCClass)classes.get(0)).getFullName()) == null) {
            ret = null;
        }
        return ret;
    }

    protected boolean isNotFullyQualifiedInnerClass(String inner, String pkgName) {
        if (inner.indexOf(".") != inner.lastIndexOf(".")) {
            return false;
        }
        return this.getClassElement(pkgName.length() > 0 ? pkgName + "." + inner : inner) != null;
    }

    protected List parseMethodTypes(String parameters) {
        ArrayList<String> ret = new ArrayList<String>();
        if (parameters == null) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(parameters, ",");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            param.trim();
            if (param.indexOf(".") < 0) {
                ClassElement ce;
                String testParam = "java.lang." + param;
                if (testParam.indexOf("[") > 0) {
                    testParam = testParam.substring(0, testParam.indexOf("["));
                }
                if ((ce = this.getClassElement(testParam)) != null) {
                    param = "java.lang." + param;
                }
            }
            ret.add(param);
        }
        return ret;
    }

    public boolean isExternalJavaDocMounted() {
        URL[] urls;
        SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)this.extEditorUI.getComponent());
        NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(NbJavaSyntaxSupport.class);
        Object currentContent = this.getCurrentContent();
        if (currentContent instanceof URL || currentContent instanceof String) {
            try {
                if (this.lastBase == null || this.lastBase.length() == 0) {
                    return false;
                }
                FileObject fo = URLMapper.findFileObject((URL)new URL(this.lastBase));
                if (fo != null) {
                    return true;
                }
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                return false;
            }
        }
        return (urls = nbJavaSup.getJavaDocURLs(currentContent)) != null && urls.length >= 1;
    }

    public Object parseLink(String link, String clsFQN, String pkgName) {
        ClassElement linkClsElem;
        String refCls;
        if (pkgName == null) {
            pkgName = "";
        }
        link = link.trim();
        JCFinder finder = this.getFinder();
        if (link.indexOf("#") > -1) {
            MethodElement me;
            String memberLink;
            JCClass linkClass;
            ClassElement linkClsElem2;
            if (link.startsWith("#")) {
                linkClsElem2 = this.getClassElement(clsFQN);
                if (linkClsElem2 == null) {
                    return null;
                }
                linkClass = finder.getExactClass(clsFQN);
                if (linkClass == null) {
                    return null;
                }
            } else {
                String refCls2 = link.substring(0, link.indexOf("#"));
                if (refCls2.indexOf(".") < 0) {
                    String curPkgCls;
                    String string = curPkgCls = pkgName.length() > 0 ? pkgName + "." + refCls2 : refCls2;
                    if (this.getClassElement(curPkgCls) == null) {
                        List outCls = finder.findClasses(null, refCls2, true);
                        if (outCls.size() > 0) {
                            refCls2 = ((JCClass)outCls.get(0)).getFullName();
                        }
                    } else {
                        refCls2 = curPkgCls;
                    }
                }
                if ((linkClsElem2 = this.getClassElement(refCls2)) == null) {
                    return null;
                }
                linkClass = finder.getExactClass(linkClsElem2.getName().getFullName());
                if (linkClass == null) {
                    return null;
                }
            }
            if (link.indexOf("(") > 0) {
                memberLink = link.substring(link.indexOf("#") + 1);
                String memberFullName = memberLink.indexOf(" ") > 0 ? memberLink.substring(0, memberLink.indexOf(" ")) : memberLink;
                String memberName = memberLink.substring(0, memberLink.indexOf("("));
                String memberParams = null;
                if (link.indexOf(")") > 0) {
                    memberParams = link.substring(link.indexOf("(") + 1, link.indexOf(")"));
                }
                List params = this.parseMethodTypes(memberParams);
                Type[] types = new Type[params.size()];
                try {
                    for (int i = 0; i < types.length; ++i) {
                        types[i] = Type.parse((String)((String)params.get(i)));
                    }
                }
                catch (IllegalArgumentException iae) {
                    types = new Type[]{};
                }
                MethodElement me2 = linkClsElem2.getMethod(Identifier.create((String)memberName), types);
                if (me2 != null) {
                    JCMethod[] mtds = linkClass.getMethods();
                    for (int i = 0; i < mtds.length; ++i) {
                        if (!JCExtension.equals(mtds[i], me2)) continue;
                        return mtds[i];
                    }
                }
                return null;
            }
            memberLink = link.substring(link.indexOf("#") + 1);
            String memberName = memberLink.indexOf(" ") > 0 ? memberLink.substring(0, memberLink.indexOf(" ")) : memberLink;
            FieldElement fieldElement = linkClsElem2.getField(Identifier.create((String)memberName));
            if (fieldElement != null) {
                JCField[] flds = linkClass.getFields();
                for (int i = 0; i < flds.length; ++i) {
                    if (!JCExtension.equals(flds[i], fieldElement)) continue;
                    return flds[i];
                }
                return null;
            }
            ClassElement processedCE = linkClsElem2;
            FileObject contextFo = NbEditorUtilities.getDataObject((Document)this.extEditorUI.getDocument()).getPrimaryFile();
            do {
                me = processedCE.getMethod(Identifier.create((String)memberName), new Type[0]);
                Identifier superCls = processedCE.getSuperclass();
                ClassElement classElement = processedCE = superCls == null ? null : ClassElement.forName((String)superCls.getFullName(), (FileObject)contextFo);
            } while (processedCE != null && me == null);
            if (me == null) {
                Identifier superCls;
                processedCE = linkClsElem2;
                do {
                    MethodElement[] mes = processedCE.getMethods();
                    for (int i = 0; i < mes.length; ++i) {
                        JCClass linkClassLoop;
                        if (!Identifier.create((String)memberName).equals((Object)mes[i].getName()) || (linkClassLoop = finder.getExactClass(processedCE.getName().getFullName())) == null) continue;
                        JCMethod[] mtds = linkClassLoop.getMethods();
                        for (int j = 0; j < mtds.length; ++j) {
                            if (!JCExtension.equals(mtds[j], mes[i])) continue;
                            return mtds[j];
                        }
                    }
                } while ((processedCE = (superCls = processedCE.getSuperclass()) == null ? null : ClassElement.forName((String)superCls.getFullName(), (FileObject)contextFo)) != null);
            } else {
                do {
                    JCMethod[] mtds = linkClass.getMethods();
                    for (int i = 0; i < mtds.length; ++i) {
                        if (!JCExtension.equals(mtds[i], me)) continue;
                        return mtds[i];
                    }
                } while ((linkClass = linkClass.getSuperclass()) != null);
            }
            return null;
        }
        String string = refCls = link.indexOf(" ") > 0 ? link.substring(0, link.indexOf(" ")) : link;
        if (refCls.indexOf(".") > 0) {
            linkClsElem = this.getClassElement(refCls);
            if (linkClsElem == null) {
                refCls = this.findProperClass(refCls, pkgName);
            }
        } else {
            refCls = this.findProperClass(refCls, pkgName);
        }
        if ((linkClsElem = this.getClassElement(refCls)) == null) {
            return null;
        }
        JCClass linkClass = finder.getExactClass(linkClsElem.getName().getFullName());
        return linkClass;
    }

    protected URL mergeRelLink(String base, String rel) {
        if (base == null || base.length() == 0) {
            return null;
        }
        try {
            return new URL(new URL(base), rel);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
    }

    static {
        $assertionsDisabled = !NbCompletionJavaDoc.class.desiredAssertionStatus();
        CONTENT_NOT_FOUND = NbBundle.getMessage((Class)NbCompletionJavaDoc.class, (String)"javadoc_content_not_found");
    }

    class JavaDocTagItemImpl
    implements CompletionJavaDoc.JavaDocTagItem {
        String name;
        String text;

        public JavaDocTagItemImpl(String name, String text) {
            this.name = name;
            this.text = text;
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JavaDocTagItemImpl p = (JavaDocTagItemImpl)o;
            return this.name.compareTo(p.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JavaDocTagItemImpl) {
                return this.name.equals(((JavaDocTagItemImpl)o).getName());
            }
            if (o instanceof String) {
                return this.name.equals((String)o);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    class ParsingThread
    implements Runnable {
        Object content;
        boolean running = true;

        public ParsingThread(Object content) {
            this.content = content;
        }

        void stopTask() {
            this.running = false;
        }

        protected String getBoldName(String description, String name) {
            if (description.indexOf(name) > -1) {
                StringBuffer sb = new StringBuffer();
                sb.append(description.substring(0, description.indexOf(name)));
                sb.append("<b>" + name + "</b>");
                sb.append(description.substring(description.indexOf(name) + name.length()));
                return sb.toString().replace('$', '.');
            }
            return description;
        }

        private MethodElement findOverridenMethod(MethodElement me) {
            MethodElement m;
            ClassElement parentClass;
            if (me == null) {
                return null;
            }
            ClassElement declaringClass = me.getDeclaringClass();
            if (declaringClass == null) {
                return null;
            }
            MethodParameter[] params = me.getParameters();
            Type[] types = new Type[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i].getType();
            }
            FileObject contextFo = NbEditorUtilities.getDataObject((Document)NbCompletionJavaDoc.this.extEditorUI.getDocument()).getPrimaryFile();
            Identifier parentIdent = declaringClass.getSuperclass();
            if (parentIdent != null && (parentClass = ClassElement.forName((String)parentIdent.getFullName(), (FileObject)contextFo)) != null && (m = parentClass.getMethod(me.getName(), types)) != null) {
                return m;
            }
            Identifier[] interfaceIdent = declaringClass.getInterfaces();
            for (int i = 0; i < interfaceIdent.length; ++i) {
                MethodElement m2;
                ClassElement interfaceElem = ClassElement.forName((String)interfaceIdent[i].getFullName(), (FileObject)contextFo);
                if (interfaceElem == null || (m2 = interfaceElem.getMethod(me.getName(), types)) == null) continue;
                return m2;
            }
            return null;
        }

        private String wrapClass(JCClass clazz) {
            if (clazz == null || clazz.toString().length() == 0) {
                return "";
            }
            String ret = clazz.toString();
            SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)NbCompletionJavaDoc.this.extEditorUI.getComponent());
            NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = NbCompletionJavaDoc.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (nbJavaSup == null) {
                return ret;
            }
            URL[] urls = nbJavaSup.getJavaDocURLs(clazz);
            if (urls.length > 0 && urls[0] != null) {
                ret = "<font size='+0'><b><A href='" + urls[0].toString() + "'>" + clazz.toString() + "</A></b></font>";
            }
            return ret;
        }

        private String wrapClass(String url) {
            StringBuffer sb;
            int htmlIndex;
            if (url == null) {
                return "";
            }
            String parent = url;
            int hashIndex = parent.lastIndexOf("#");
            if (hashIndex > 0) {
                parent = parent.substring(0, hashIndex);
            }
            if ((htmlIndex = (sb = new StringBuffer(url)).indexOf(".html")) > 0) {
                sb.delete(htmlIndex, sb.length());
            }
            for (int i = 0; i < sb.length() - 1; ++i) {
                if (sb.charAt(i) != '/') continue;
                String subStr = sb.substring(i + 1);
                subStr = subStr.replace('/', '.');
                if (NbCompletionJavaDoc.this.getFinder().getExactClass(subStr) == null) continue;
                String ret = "<font size='+0'><b><A href='" + parent + "'>" + subStr + "</A></b></font>";
                return ret;
            }
            return "";
        }

        private boolean tryMountedJavaDoc(URL url) {
            String textFromURL;
            JCClass clazz;
            if (url != null && !"nbfs".equals(url.getProtocol())) {
                return false;
            }
            String clazzInfo = "";
            if (this.content instanceof JCMethod) {
                clazz = ((JCMethod)this.content).getClazz();
                if (clazz != null) {
                    clazzInfo = this.wrapClass(clazz);
                }
            } else if (this.content instanceof JCField) {
                clazz = ((JCField)this.content).getClazz();
                if (clazz != null) {
                    clazzInfo = this.wrapClass(clazz);
                }
            } else if (this.content instanceof JCConstructor && (clazz = ((JCConstructor)this.content).getClazz()) != null) {
                clazzInfo = this.wrapClass(clazz);
            }
            SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)NbCompletionJavaDoc.this.extEditorUI.getComponent());
            NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = NbCompletionJavaDoc.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (url == null) {
                URL[] urls = nbJavaSup.getJavaDocURLs(this.content);
                if (urls.length > 0 && urls[0] != null) {
                    url = urls[0];
                } else {
                    return false;
                }
            }
            String urlStr = url.toString();
            if (clazzInfo.length() == 0) {
                clazzInfo = this.wrapClass(urlStr);
            }
            if ((textFromURL = HTMLJavadocParser.getJavadocText(url, this.content instanceof JCPackage)) != null && textFromURL.length() > 0) {
                if (!textFromURL.toUpperCase().startsWith("<DL>") && !textFromURL.toUpperCase().startsWith("<PRE>")) {
                    clazzInfo = clazzInfo + "<BR>";
                }
                String retrievedText = clazzInfo + textFromURL;
                NbCompletionJavaDoc.this.lastBase = this.getLastBase(urlStr);
                NbCompletionJavaDoc.this.goToSourceEnabled = false;
                this.showJavaDoc(retrievedText);
                return true;
            }
            return false;
        }

        protected String getLastBase(String urlStr) {
            if (urlStr == null) {
                return null;
            }
            return urlStr.substring(0, urlStr.lastIndexOf(47) + 1);
        }

        protected void javaDocNotFound() {
            if (NbCompletionJavaDoc.this.alwaysDisplayPopup()) {
                this.showJavaDoc(CONTENT_NOT_FOUND);
            }
        }

        protected void showJavaDoc(final String preparedText) {
            if (this.running) {
                Runnable r = new Runnable(){

                    public void run() {
                        NbCompletionJavaDoc.this.getJavaDocView().setContent(preparedText);
                        NbCompletionJavaDoc.this.setGoToSourceEnabled(NbCompletionJavaDoc.this.isGoToSourceEnabled());
                        if (ParsingThread.this.running) {
                            NbCompletionJavaDoc.this.setJavaDocVisible(true);
                        }
                    }
                };
                Utilities.runInEventDispatchThread((Runnable)r);
            }
        }

        private void setMethod(MethodElement me, JCMethod jcMethod) {
            if (me == null || jcMethod == null) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                NbCompletionJavaDoc.this.goToSourceEnabled = false;
                this.javaDocNotFound();
                return;
            }
            JavaDoc.Method jdMethod = me.getJavaDoc();
            String jdText = "";
            JavaDocTag[] jdTags = new JavaDocTag[]{};
            if (jdMethod != null) {
                jdTags = jdMethod.getTags();
                jdText = jdMethod.getText();
            }
            MethodElement parentMethod = this.findOverridenMethod(me);
            while (parentMethod != null && (jdTags.length == 0 || jdText.length() == 0)) {
                JavaDoc.Method parentJD = parentMethod.getJavaDoc();
                if (parentJD != null) {
                    if (jdText.length() == 0) {
                        jdText = parentJD.getText();
                    }
                    if (jdTags.length == 0) {
                        jdTags = parentJD.getTags();
                    }
                }
                parentMethod = this.findOverridenMethod(parentMethod);
            }
            boolean notFound = jdText.length() == 0 && jdTags.length == 0;
            String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(jcMethod.getClazz(), this.getBoldName(jcMethod.toString(), jcMethod.getName()), notFound ? CONTENT_NOT_FOUND : jdText, jdMethod == null ? null : NbCompletionJavaDoc.this.getJavaDocTags(jdTags));
            if (notFound) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                this.javaDocNotFound();
                return;
            }
            this.showJavaDoc(preparedText);
        }

        private void setClass(ClassElement ce, JCClass cls) {
            if (ce == null) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                NbCompletionJavaDoc.this.goToSourceEnabled = false;
                this.javaDocNotFound();
                return;
            }
            JavaDoc.Class jdClass = ce.getJavaDoc();
            boolean notFound = jdClass == null || jdClass.getText().length() == 0 && jdClass.getTags().length == 0;
            String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(cls, "", notFound ? CONTENT_NOT_FOUND : jdClass.getText(), jdClass == null ? null : NbCompletionJavaDoc.this.getJavaDocTags(jdClass.getTags()));
            if (notFound) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                this.javaDocNotFound();
                return;
            }
            this.showJavaDoc(preparedText);
        }

        private void setField(FieldElement fe, JCField jcField) {
            if (fe == null || jcField == null) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                NbCompletionJavaDoc.this.goToSourceEnabled = false;
                this.javaDocNotFound();
                return;
            }
            JavaDoc.Field jdField = fe.getJavaDoc();
            boolean notFound = jdField == null || jdField.getText().length() == 0 && jdField.getTags().length == 0;
            String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(jcField.getClazz(), this.getBoldName(jcField.toString(), jcField.getName()), notFound ? CONTENT_NOT_FOUND : jdField.getText(), jdField == null ? null : NbCompletionJavaDoc.this.getJavaDocTags(jdField.getTags()));
            if (notFound) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                this.javaDocNotFound();
                return;
            }
            this.showJavaDoc(preparedText);
        }

        private void setConstructor(ConstructorElement conElem, JCConstructor jcConstuctor) {
            if (conElem == null || jcConstuctor == null) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                NbCompletionJavaDoc.this.goToSourceEnabled = false;
                this.javaDocNotFound();
                return;
            }
            JavaDoc.Method jdMethod = conElem.getJavaDoc();
            boolean notFound = jdMethod == null || jdMethod.getText().length() == 0 && jdMethod.getTags().length == 0;
            String preparedText = NbCompletionJavaDoc.this.prepareJavaDocContent(jcConstuctor.getClazz(), this.getBoldName(jcConstuctor.toString(), jcConstuctor.getClazz().getName()), notFound ? CONTENT_NOT_FOUND : jdMethod.getText(), jdMethod == null ? null : NbCompletionJavaDoc.this.getJavaDocTags(jdMethod.getTags()));
            if (notFound) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                this.javaDocNotFound();
                return;
            }
            this.showJavaDoc(preparedText);
        }

        public void run() {
            NbCompletionJavaDoc.this.goToSourceEnabled = true;
            if (this.content instanceof JCClass) {
                this.setClass(NbCompletionJavaDoc.this.getClassElement(((JCClass)this.content).getFullName()), (JCClass)this.content);
            } else if (this.content instanceof JCField) {
                JCField fld = (JCField)this.content;
                ClassElement ce = NbCompletionJavaDoc.this.getClassElement(fld.getClazz().getFullName());
                if (ce == null) {
                    NbCompletionJavaDoc.this.goToSourceEnabled = false;
                    if (!this.tryMountedJavaDoc(null)) {
                        this.javaDocNotFound();
                    }
                    return;
                }
                this.setField(ce.getField(Identifier.create((String)((JCField)this.content).getName())), fld);
            } else if (this.content instanceof JCMethod) {
                JCMethod mtd = (JCMethod)this.content;
                ClassElement ce = NbCompletionJavaDoc.this.getClassElement(mtd.getClazz().getFullName());
                if (ce == null) {
                    NbCompletionJavaDoc.this.goToSourceEnabled = false;
                    if (!this.tryMountedJavaDoc(null)) {
                        this.javaDocNotFound();
                    }
                    return;
                }
                JCParameter[] jcp = mtd.getParameters();
                try {
                    Type[] types = new Type[jcp.length];
                    for (int i = 0; i < jcp.length; ++i) {
                        String array = "";
                        for (int j = 0; j < jcp[i].getType().getArrayDepth(); ++j) {
                            array = array + "[]";
                        }
                        types[i] = Type.parse((String)(jcp[i].getType().getClazz().getFullName() + array));
                    }
                    this.setMethod(ce.getMethod(Identifier.create((String)((JCMethod)this.content).getName()), types), mtd);
                }
                catch (IllegalArgumentException iae) {
                    iae.printStackTrace();
                }
            } else if (this.content instanceof JCConstructor) {
                JCConstructor con = (JCConstructor)this.content;
                ClassElement ce = NbCompletionJavaDoc.this.getClassElement(con.getClazz().getFullName());
                if (ce == null) {
                    NbCompletionJavaDoc.this.goToSourceEnabled = false;
                    if (!this.tryMountedJavaDoc(null)) {
                        this.javaDocNotFound();
                    }
                    return;
                }
                JCParameter[] jcp = con.getParameters();
                try {
                    Type[] types = new Type[jcp.length];
                    for (int i = 0; i < jcp.length; ++i) {
                        String array = "";
                        for (int j = 0; j < jcp[i].getType().getArrayDepth(); ++j) {
                            array = array + "[]";
                        }
                        types[i] = Type.parse((String)(jcp[i].getType().getClazz().getFullName() + array));
                    }
                    this.setConstructor(ce.getConstructor(types), con);
                }
                catch (IllegalArgumentException iae) {
                    iae.printStackTrace();
                }
            } else if (this.content instanceof URL) {
                URL u = (URL)this.content;
                if ("http".equals(u.getProtocol())) {
                    return;
                }
                if (!this.tryMountedJavaDoc((URL)this.content)) {
                    NbCompletionJavaDoc.this.goToSourceEnabled = false;
                    this.javaDocNotFound();
                }
                if (NbCompletionJavaDoc.this.addToHistory) {
                    NbCompletionJavaDoc.this.addToHistory(this.content);
                }
            } else if (this.content instanceof String) {
                NbCompletionJavaDoc.this.goToSourceEnabled = false;
                String strCon = (String)this.content;
                URL url = NbCompletionJavaDoc.this.mergeRelLink(NbCompletionJavaDoc.this.lastBase, strCon);
                if (url == null) {
                    return;
                }
                if ("http".equals(url.getProtocol())) {
                    return;
                }
                if (NbCompletionJavaDoc.this.addToHistory) {
                    NbCompletionJavaDoc.this.addToHistory(url);
                }
                if (!this.tryMountedJavaDoc(url)) {
                    this.javaDocNotFound();
                }
            } else {
                NbCompletionJavaDoc.this.goToSourceEnabled = false;
                if (!this.tryMountedJavaDoc(null)) {
                    this.javaDocNotFound();
                }
            }
        }
    }
}

