/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.jmi.reflect.RefFeatured;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TagValue;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.java.FixDuplicateImportStmts;
import org.netbeans.modules.editor.java.FixImportsProgressPanel;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JavaFixAllImports
extends BaseAction {
    static final long serialVersionUID = 6020950800832542269L;
    private static final int HAS_SYNTAX_ERROR = 16;
    private JMIUtils jmiUtils;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaFixAllImports$MainMenuWrapper;

    public JavaFixAllImports() {
        super("fix-imports");
        this.putValue("ShortDescription", NbBundle.getBundle((Class)JavaKit.class).getString("fix-imports"));
        this.putValue("helpID", JavaFixAllImports.class.getName());
    }

    private Dialog createProgressDialog(FixImportsProgressPanel progressPanel) {
        String title = NbBundle.getMessage((Class)FixImportsProgressPanel.class, (String)"FixImportsProgressTitle_Lbl");
        DialogDescriptor desc = new DialogDescriptor((Object)progressPanel, title, true, new Object[0], null, 0, null, null);
        desc.setClosingOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        ((JDialog)dialog).setDefaultCloseOperation(0);
        dialog.validate();
        return dialog;
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent t) {
        Runnable run = new Runnable(){

            public void run() {
                if (t == null) {
                    return;
                }
                final JTextComponent target = t;
                final FixDuplicateImportStmts duplImportsPanel = new FixDuplicateImportStmts();
                final DialogDescriptor descr = new DialogDescriptor((Object)duplImportsPanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$java$JavaFixAllImports == null ? (class$org$netbeans$modules$editor$java$JavaFixAllImports = JavaFixAllImports.class$("org.netbeans.modules.editor.java.JavaFixAllImports")) : class$org$netbeans$modules$editor$java$JavaFixAllImports), (String)"FixDuplicateImports_dlgTitle"));
                descr.setOptionType(2);
                final Dialog duplImportsDialog = DialogDisplayer.getDefault().createDialog(descr);
                final FixImportsProgressPanel progress = new FixImportsProgressPanel();
                final Dialog progressDialog = JavaFixAllImports.this.createProgressDialog(progress);
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JavaFixAllImports.this.addAllNeededImports(target.getText(), (BaseDocument)target.getDocument(), target, progress, progressDialog, duplImportsPanel, duplImportsDialog, descr);
                    }
                });
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(run, NbBundle.getMessage((Class)JavaFixAllImports.class, (String)"fix-imports"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllNeededImports(String txt, BaseDocument doc, JTextComponent target, FixImportsProgressPanel progress, Dialog progressDialog, FixDuplicateImportStmts duplImportsPanel, Dialog duplImportsDialog, DialogDescriptor descr) {
        String msg;
        boolean hasSyntaxError;
        boolean diagPassed;
        boolean failed;
        Resource resource;
        HashSet<Import> usedImports;
        HashMap ambigs;
        HashSet<String> unresolved;
        ArrayList importsToRemove;
        ArrayList<String> importsToAdd;
        block44: {
            block43: {
                Object sdp = doc.getProperty((Object)"stream");
                FileObject fo = null;
                if (sdp instanceof FileObject) {
                    fo = (FileObject)sdp;
                } else if (sdp instanceof DataObject) {
                    fo = ((DataObject)sdp).getPrimaryFile();
                } else {
                    return;
                }
                importsToAdd = null;
                importsToRemove = null;
                unresolved = null;
                ambigs = new HashMap();
                usedImports = new HashSet<Import>();
                resource = null;
                failed = true;
                diagPassed = true;
                hasSyntaxError = false;
                this.jmiUtils = JMIUtils.get(doc);
                this.jmiUtils.beginTrans(true);
                resource = JavaModel.getResource((FileObject)fo);
                if (resource != null) break block43;
                Utilities.annotateLoggable((Throwable)new NullPointerException("Resource is null for FileObject:" + fo));
                failed = false;
                SwingUtilities.invokeLater(new Runnable(progress, progressDialog){
                    private final /* synthetic */ FixImportsProgressPanel val$progress;
                    private final /* synthetic */ Dialog val$progressDialog;
                    {
                        this.val$progress = fixImportsProgressPanel;
                        this.val$progressDialog = dialog;
                    }

                    public void run() {
                        this.val$progress.stop();
                        try {
                            Thread.currentThread();
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.val$progressDialog.setVisible(false);
                        this.val$progressDialog.dispose();
                    }
                });
                this.jmiUtils.endTrans(failed);
                return;
            }
            try {
                boolean bl = hasSyntaxError = (resource.getStatus() & 0x10) > 0;
                if (!hasSyntaxError) {
                    Import imp;
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)JavaFixAllImports.class, (String)"FixingImports_Lbl"));
                    HashSet clsNames = new HashSet();
                    HashSet resolvedClsNames = new HashSet();
                    HashSet javadocTags = new HashSet();
                    this.findPotentialClassNames(resource, clsNames, resolvedClsNames, javadocTags, progress, progressDialog);
                    HashMap<String, Import> importedPackages = new HashMap<String, Import>();
                    HashMap<String, Import> importedClasses = new HashMap<String, Import>();
                    Iterator iter = resource.getImports().iterator();
                    while (iter.hasNext()) {
                        Import imp2 = (Import)iter.next();
                        if (imp2.isStatic()) continue;
                        String id = JavaFixAllImports.idToName(imp2.getIdentifier());
                        if (imp2.getImportedNamespace() instanceof JavaPackage) {
                            importedPackages.put(id, imp2);
                            continue;
                        }
                        if (imp2.isOnDemand()) {
                            id = id + ".*";
                        }
                        importedClasses.put(id, imp2);
                    }
                    importsToAdd = new ArrayList<String>();
                    importsToRemove = new ArrayList();
                    unresolved = new HashSet<String>();
                    FileObject[] cpRoots = JavaMetamodel.getManager().getClassPath().getRoots();
                    ClassIndex[] cis = new ClassIndex[cpRoots.length];
                    for (int i = 0; i < cpRoots.length; ++i) {
                        cis[i] = ClassIndex.getIndex((JavaModelPackage)JavaModel.getJavaExtent((FileObject)cpRoots[i]));
                    }
                    Iterator iter2 = resolvedClsNames.iterator();
                    while (iter2.hasNext()) {
                        JavaClass jc = (JavaClass)iter2.next();
                        imp = (Import)importedClasses.get(jc.getName());
                        if (imp != null) {
                            usedImports.add(imp);
                            continue;
                        }
                        RefFeatured comp = jc.refImmediateComposite();
                        if (comp instanceof Resource) {
                            imp = (Import)importedPackages.get(((Resource)comp).getPackageName());
                            if (imp == null) continue;
                            usedImports.add(imp);
                            continue;
                        }
                        if (!(comp instanceof JavaClass) || (imp = (Import)importedClasses.get(((JavaClass)comp).getName() + ".*")) == null) continue;
                        usedImports.add(imp);
                    }
                    Iterator classifiers = resource.getClassifiers().iterator();
                    JavaClass from = classifiers.hasNext() ? (JavaClass)classifiers.next() : null;
                    boolean finished = false;
                    boolean processingJavadocTags = false;
                    Iterator iter3 = clsNames.iterator();
                    block9: while (!finished) {
                        if (!iter3.hasNext()) {
                            if (processingJavadocTags) {
                                finished = true;
                                break;
                            }
                            iter3 = javadocTags.iterator();
                            processingJavadocTags = true;
                            continue;
                        }
                        String simpleName = (String)iter3.next();
                        ArrayList<JavaClass> ret = new ArrayList<JavaClass>();
                        HashSet<String> fullNames = new HashSet<String>();
                        for (int i = 0; i < cis.length; ++i) {
                            Collection res;
                            if (cis[i] == null || (res = cis[i].getClassesBySimpleName(simpleName)) == null) continue;
                            Iterator tmpIt = res.iterator();
                            while (tmpIt.hasNext()) {
                                JavaClass javaClass = (JavaClass)tmpIt.next();
                                String fqn = javaClass.getName();
                                if (fullNames.contains(fqn) || !this.jmiUtils.isAccessible((ClassDefinition)javaClass, from)) continue;
                                ret.add(javaClass);
                                fullNames.add(fqn);
                            }
                        }
                        if (ret.size() == 0) {
                            if (processingJavadocTags) continue;
                            unresolved.add(simpleName);
                            continue;
                        }
                        Iterator iter22 = ret.iterator();
                        while (iter22.hasNext()) {
                            JavaClass cls = (JavaClass)iter22.next();
                            RefFeatured comp = cls.refImmediateComposite();
                            String pkg = null;
                            if (comp instanceof Resource) {
                                pkg = ((Resource)comp).getPackageName();
                            }
                            if (pkg != null) {
                                if (pkg.equals("java.lang")) continue block9;
                                imp = (Import)importedPackages.get(pkg);
                                if (imp != null) {
                                    usedImports.add(imp);
                                    continue block9;
                                }
                            }
                            if ((imp = (Import)importedClasses.get(cls.getName())) != null) {
                                usedImports.add(imp);
                                continue block9;
                            }
                            if (!(comp instanceof JavaClass) || (imp = (Import)importedClasses.get(((JavaClass)comp).getName() + ".*")) == null) continue;
                            usedImports.add(imp);
                            continue block9;
                        }
                        if (processingJavadocTags) continue;
                        int sz = ret.size();
                        if (sz > 1) {
                            ambigs.put(simpleName, ret);
                            continue;
                        }
                        if (sz <= 0) continue;
                        importsToAdd.add(((JavaClass)ret.iterator().next()).getName());
                    }
                    failed = false;
                    break block44;
                }
                failed = false;
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                this.jmiUtils.endTrans(failed);
                throw throwable;
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        this.jmiUtils.endTrans(failed);
        String[] selections = null;
        boolean ambigsWasCalled = false;
        if (ambigs != null && ambigs.size() > 0) {
            selections = JavaFixAllImports.userResolvesAmbiguities(ambigs, duplImportsPanel, duplImportsDialog, descr);
            ambigsWasCalled = true;
        }
        if (!hasSyntaxError) {
            this.jmiUtils.beginTrans(true);
            try {
                failed = true;
                if (ambigsWasCalled) {
                    if (selections != null) {
                        for (int i = 0; i < selections.length; ++i) {
                            importsToAdd.add(selections[i]);
                        }
                    } else {
                        diagPassed = false;
                    }
                }
                if (diagPassed) {
                    JavaFixAllImports.changeImports(importsToAdd, importsToRemove, usedImports, resource);
                }
                failed = false;
            }
            finally {
                this.jmiUtils.endTrans(failed);
            }
        }
        if (hasSyntaxError) {
            msg = NbBundle.getMessage((Class)JavaFixAllImports.class, (String)"SourceContainsSyntaxErrors_Lbl");
            StatusDisplayer.getDefault().setStatusText(msg);
        } else if (diagPassed && unresolved.size() > 0) {
            JavaFixAllImports.showInformational(unresolved);
            StatusDisplayer.getDefault().setStatusText("");
        } else if (diagPassed) {
            msg = null;
            msg = importsToAdd.size() > 0 || importsToRemove.size() > 0 ? NbBundle.getMessage((Class)JavaFixAllImports.class, (String)"AllImportsWereFixed_Lbl") : NbBundle.getMessage((Class)JavaFixAllImports.class, (String)"NoImportsToFix_Lbl");
            StatusDisplayer.getDefault().setStatusText(msg);
        } else {
            StatusDisplayer.getDefault().setStatusText("");
        }
    }

    private static String[] userResolvesAmbiguities(HashMap ambigs, final FixDuplicateImportStmts duplImportsPanel, final Dialog duplImportsDialog, final DialogDescriptor descr) {
        int numberOfAmbigs = ambigs.size();
        int cnt = 0;
        final String[] simpleNames = new String[numberOfAmbigs];
        final String[][] choices = new String[numberOfAmbigs][];
        final String[] defaults = new String[numberOfAmbigs];
        int[] defaultWeights = new int[numberOfAmbigs];
        Iterator ambigIter = ambigs.keySet().iterator();
        while (ambigIter.hasNext()) {
            String simpleName = (String)ambigIter.next();
            List l = (List)ambigs.get(simpleName);
            simpleNames[cnt] = simpleName;
            choices[cnt] = new String[l.size()];
            Object[] curChoice = choices[cnt];
            defaultWeights[cnt] = -1;
            for (int k = 0; k < l.size(); ++k) {
                JavaClass cls = (JavaClass)l.get(k);
                String fullName = cls.getName();
                curChoice[k] = fullName;
                int weight = JMIUtils.getDefaultSelectionWeight(cls);
                if (weight <= defaultWeights[cnt]) continue;
                defaults[cnt] = fullName;
                defaultWeights[cnt] = weight;
            }
            Arrays.sort(curChoice);
            ++cnt;
        }
        final Object[] result = new Object[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    duplImportsPanel.initPanel(simpleNames, choices, defaults);
                    duplImportsDialog.pack();
                    duplImportsDialog.setVisible(true);
                    Object o = descr.getValue();
                    result[0] = o == DialogDescriptor.OK_OPTION ? duplImportsPanel.getSelections() : null;
                    duplImportsDialog.setVisible(false);
                    duplImportsDialog.dispose();
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return (String[])result[0];
    }

    private static void showInformational(HashSet unresolved) {
        StringBuffer sb = new StringBuffer(NbBundle.getMessage((Class)JavaFixAllImports.class, (String)"NoImportsFound_Lbl"));
        sb.append('\n');
        Iterator iter = unresolved.iterator();
        while (iter.hasNext()) {
            sb.append("     - ");
            sb.append((String)iter.next());
            sb.append('\n');
        }
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)sb.toString());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
    }

    private static void changeImports(ArrayList importsToAdd, List importsToRemove, Set usedImports, Resource resource) {
        Object[] importsArray = importsToAdd.toArray();
        Arrays.sort(importsArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
        String thisPkgName = resource.getPackageName();
        List imports = resource.getImports();
        ListIterator<Import> iter = imports.listIterator();
        while (iter.hasNext()) {
            NamedElement impNs;
            Import imp = (Import)iter.next();
            if (imp.isStatic() || (impNs = imp.getImportedNamespace()) instanceof UnresolvedClass) continue;
            if (!usedImports.contains(imp)) {
                importsToRemove.add(imp);
                iter.remove();
                imp.refDelete();
                continue;
            }
            String pkgName = null;
            if (!imp.isOnDemand()) {
                Resource res;
                JavaClass jc = (JavaClass)impNs;
                if (!jc.isInner() && (res = jc.getResource()) != null) {
                    pkgName = res.getPackageName();
                }
            } else {
                NamedElement obj = impNs;
                if (obj instanceof JavaPackage) {
                    pkgName = ((JavaPackage)obj).getName();
                }
            }
            if (pkgName == null || !pkgName.equals("java.lang") && !pkgName.equals(thisPkgName)) continue;
            importsToRemove.add(imp);
            iter.remove();
            imp.refDelete();
        }
        if (importsArray.length == 0) {
            return;
        }
        ImportClass proxy = ((JavaModelPackage)resource.refOutermostPackage()).getImport();
        Import imp = null;
        iter = imports.listIterator(imports.size());
        String currName = null;
        if (iter.hasPrevious()) {
            currName = ((Import)iter.previous()).getName();
            iter.next();
        }
        for (int i = importsArray.length - 1; i >= 0; --i) {
            String impName = (String)importsArray[i];
            imp = proxy.createImport(impName, null, false, false);
            while (currName != null && currName.compareTo(impName) > 0) {
                iter.previous();
                if (iter.hasPrevious()) {
                    currName = ((Import)iter.previous()).getName();
                    iter.next();
                    continue;
                }
                currName = null;
            }
            iter.add(imp);
            iter.previous();
        }
    }

    private static void idToName(StringBuffer buffer, MultipartId id) {
        MultipartId parent = id.getParent();
        if (parent != null) {
            JavaFixAllImports.idToName(buffer, parent);
            buffer.append('.');
        }
        buffer.append(id.getName());
    }

    private static String idToName(MultipartId id) {
        StringBuffer buffer = new StringBuffer();
        JavaFixAllImports.idToName(buffer, id);
        return buffer.toString();
    }

    private void findPotentialClassNames(Set set, Set resolved, Set javadocTags, Element elem, Set checkedElements, int level, final FixImportsProgressPanel progress) {
        JavaDoc javaDoc;
        Iterator iterator;
        ++level;
        if (elem instanceof ArrayReference) {
            elem = ((ArrayReference)elem).getParent();
        }
        if (elem instanceof MultipartId) {
            ArrayList typeArgs = new ArrayList();
            MultipartId id = (MultipartId)elem;
            typeArgs.addAll(id.getTypeArguments());
            while (id.getParent() != null) {
                id = id.getParent();
                typeArgs.addAll(id.getTypeArguments());
            }
            NamedElement namedElem = id.getElement();
            if (namedElem instanceof UnresolvedClass) {
                set.add(JavaFixAllImports.idToName(id));
            } else if (namedElem instanceof JavaClass) {
                resolved.add(namedElem);
            }
            iterator = typeArgs.iterator();
        } else {
            iterator = elem.getChildren().iterator();
        }
        if (elem instanceof ClassMember && (javaDoc = ((ClassMember)elem).getJavadoc()) != null) {
            ArrayList<String> values = new ArrayList<String>();
            String javaDocText = javaDoc.getText();
            if (javaDocText != null) {
                this.addTagValues(values, javaDocText);
            }
            Iterator iter = javaDoc.getTags().iterator();
            while (iter.hasNext()) {
                TagValue tag = (TagValue)iter.next();
                String tagName = tag.getDefinition().getName();
                String tagValue = tag.getValue();
                this.addTagValues(values, tagValue);
                if (!"@see".equals(tagName) && !"@link".equals(tagName) && !"@linkplane".equals(tagName) && !"@exception".equals(tagName) && !"@throws".equals(tagName) && !"@value".equals(tagName) || tagValue == null) continue;
                values.add(tagValue);
            }
            iter = values.iterator();
            while (iter.hasNext()) {
                String tagValue = (String)iter.next();
                tagValue = tagValue.trim();
                int length = tagValue.length();
                for (int x = 0; x < length; ++x) {
                    if (!Character.isWhitespace(tagValue.charAt(x))) continue;
                    tagValue = tagValue.substring(0, x);
                    break;
                }
                if (tagValue.length() == 0) continue;
                int index = tagValue.indexOf(35);
                int end = index > -1 ? index : tagValue.length();
                index = tagValue.indexOf(46);
                if (index > -1 && index < end) {
                    end = index;
                }
                if (end <= 0 || !org.openide.util.Utilities.isJavaIdentifier((String)(tagValue = tagValue.substring(0, end)))) continue;
                javadocTags.add(tagValue);
            }
        }
        while (iterator.hasNext()) {
            Element usedElem = (Element)iterator.next();
            if (checkedElements.contains(usedElem)) continue;
            checkedElements.add(usedElem);
            this.findPotentialClassNames(set, resolved, javadocTags, usedElem, checkedElements, level, progress);
        }
        if (level == 2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    progress.step();
                }
            });
        }
    }

    private void addTagValues(List values, String text) {
        int length = text.length();
        int index = 0;
        while (index >= 0 && index < length) {
            int i;
            if ((index = text.indexOf("@link", index)) <= -1) continue;
            if ((index += 5) >= length || !Character.isWhitespace(text.charAt(index))) {
                if (index + 5 >= length || !"plane".equals(text.substring(index, index + 5)) || !Character.isWhitespace(text.charAt(index + 5))) continue;
                index += 5;
            }
            if ((i = text.indexOf(125, index)) <= -1) continue;
            values.add(text.substring(index, i));
        }
    }

    private void findPotentialClassNames(Resource resource, Set unresolved, Set resolved, Set javadocTags, final FixImportsProgressPanel progress, final Dialog progressDialog) {
        HashSet checkedElements = new HashSet();
        Iterator iter = resource.getClassifiers().iterator();
        int count = 0;
        while (iter.hasNext()) {
            Element elem = (Element)iter.next();
            count += elem.getChildren().size();
        }
        final int num = count + 1;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progress.start(num);
                progressDialog.setVisible(true);
            }
        });
        iter = resource.getClassifiers().iterator();
        while (iter.hasNext()) {
            this.findPotentialClassNames(unresolved, resolved, javadocTags, (Element)iter.next(), checkedElements, 0, progress);
        }
    }

    public static final class MainMenuWrapper
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public MainMenuWrapper() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaFixAllImports$MainMenuWrapper == null ? (class$org$netbeans$modules$editor$java$JavaFixAllImports$MainMenuWrapper = JavaFixAllImports.class$("org.netbeans.modules.editor.java.JavaFixAllImports$MainMenuWrapper")) : class$org$netbeans$modules$editor$java$JavaFixAllImports$MainMenuWrapper)).getString("fix_imports_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "fix-imports";
        }
    }
}

