/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl.wizard;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.websvc.wsdl.wizard.SelectSchemaPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class Utilities {
    private static File lastDirectory;
    private static Object[] closingOptionsWithoutOK;
    private static Object[] closingOptionsWithOK;

    public static String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public static void replaceInDocument(Document document, String replaceFrom, String replaceTo) {
        AbstractDocument doc = (AbstractDocument)document;
        int len = replaceFrom.length();
        try {
            String content = doc.getText(0, doc.getLength());
            int index = content.lastIndexOf(replaceFrom);
            while (index >= 0) {
                doc.replace(index, len, replaceTo, null);
                content = content.substring(0, index);
                index = content.lastIndexOf(replaceFrom);
            }
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
    }

    public static File[] selectFiles(String extensions, String dialogTitle, String maskTitle, Project project) {
        ArrayList<File> fileList = new ArrayList<File>();
        SelectSchemaPanel explorerPanel = new SelectSchemaPanel(project);
        DialogDescriptor descriptor = new DialogDescriptor((Object)explorerPanel, NbBundle.getMessage(Utilities.class, (String)"TTL_SelectSchemas"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor).equals(NotifyDescriptor.OK_OPTION)) {
            boolean accepted = true;
            Object errMsg = null;
            Node[] selectedNodes = explorerPanel.getSelectedNodes();
            for (int i = 0; i < selectedNodes.length; ++i) {
                File file;
                FileObject fo;
                Node node = selectedNodes[i];
                DataObject dobj = (DataObject)node.getCookie(DataObject.class);
                if (dobj == null || (fo = dobj.getPrimaryFile()) == null || (file = FileUtil.toFile((FileObject)fo)) == null || !file.isFile()) continue;
                StringTokenizer token = new StringTokenizer(extensions, " ");
                boolean validFile = false;
                while (token.hasMoreElements()) {
                    if (!file.getName().endsWith(token.nextToken())) continue;
                    fileList.add(file);
                    validFile = true;
                }
                if (validFile) continue;
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Utilities.class, (String)"MSG_inValidFile", (Object)file.getName()), 2));
            }
            if (!accepted) {
                NotifyDescriptor.Message notifyDescr = new NotifyDescriptor.Message(errMsg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescr);
                descriptor.setClosingOptions(closingOptionsWithoutOK);
            } else {
                descriptor.setClosingOptions(closingOptionsWithOK);
            }
        }
        File[] selectedFiles = new File[fileList.size()];
        return fileList.toArray(selectedFiles);
    }

    public static File selectFile(final String extensions, String dialogTitle, final String maskTitle) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                StringTokenizer token = new StringTokenizer(extensions, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return maskTitle;
            }
        });
        if (lastDirectory != null) {
            chooser.setCurrentDirectory(lastDirectory);
        }
        chooser.setDialogTitle(dialogTitle);
        while (chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(Utilities.class, (String)"PROP_select_button")) == 0) {
            File f = chooser.getSelectedFile();
            lastDirectory = chooser.getCurrentDirectory();
            if (f != null && f.isFile()) {
                StringTokenizer token = new StringTokenizer(extensions, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return f;
                }
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Utilities.class, (String)"MSG_inValidFile"), 2));
        }
        return null;
    }

    public static JTextComponent findTextFieldForLabel(JComponent component, String text) {
        Component comp;
        JLabel label = Util.findLabel((JComponent)component, (String)text);
        if (label != null && (comp = label.getLabelFor()) != null && comp instanceof JTextComponent) {
            return (JTextComponent)comp;
        }
        return null;
    }

    static {
        closingOptionsWithoutOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION};
        closingOptionsWithOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION, DialogDescriptor.OK_OPTION};
    }
}

