/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.wseditor.support;

import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditor;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditorProvider;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditorProviderRegistry;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesTopComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class EditWSAttributesCookieImpl
implements EditWSAttributesCookie {
    private Set<WSEditorProvider> providers;
    private Set<WSEditor> editors;
    private static Map cachedTopComponents = new WeakHashMap();
    private EditWSAttributesTopComponent tc;
    private Node node;
    private JaxWsModel jaxWsModel;
    private DialogWindowListener windowListener;

    public EditWSAttributesCookieImpl(Node node, JaxWsModel jaxWsModel) {
        this.node = node;
        this.jaxWsModel = jaxWsModel;
    }

    public void openWSAttributesEditor() {
        this.tc = (EditWSAttributesTopComponent)((Object)cachedTopComponents.get(this.node));
        if (this.tc == null) {
            this.populateWSEditorProviderRegistry();
            this.providers = WSEditorProviderRegistry.getDefault().getEditorProviders();
            this.tc = new EditWSAttributesTopComponent();
            cachedTopComponents.put(this, this.tc);
        }
        this.populatePanels();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditWSAttributesCookieImpl.this.tc.addTabs(EditWSAttributesCookieImpl.this.editors, EditWSAttributesCookieImpl.this.node, EditWSAttributesCookieImpl.this.jaxWsModel);
                DialogDescriptor dialogDesc = new DialogDescriptor((Object)EditWSAttributesCookieImpl.this.tc, EditWSAttributesCookieImpl.this.node.getName());
                dialogDesc.setHelpCtx(new HelpCtx(EditWSAttributesCookieImpl.class));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
                dialog.setVisible(true);
                if (dialogDesc.getValue() == NotifyDescriptor.OK_OPTION) {
                    for (WSEditor editor : EditWSAttributesCookieImpl.this.editors) {
                        editor.save(EditWSAttributesCookieImpl.this.node, EditWSAttributesCookieImpl.this.jaxWsModel);
                    }
                } else {
                    for (WSEditor editor : EditWSAttributesCookieImpl.this.editors) {
                        editor.cancel(EditWSAttributesCookieImpl.this.node, EditWSAttributesCookieImpl.this.jaxWsModel);
                    }
                }
            }
        });
    }

    public Set getWSEditorProviders() {
        return this.providers;
    }

    private void populatePanels() {
        this.editors = new HashSet<WSEditor>();
        for (WSEditorProvider provider : this.providers) {
            if (!provider.enable(this.node)) continue;
            WSEditor editor = provider.createWSEditor();
            this.editors.add(editor);
        }
    }

    private void populateWSEditorProviderRegistry() {
        WSEditorProviderRegistry registry = WSEditorProviderRegistry.getDefault();
        if (registry.getEditorProviders().isEmpty()) {
            Lookup.Result results = Lookup.getDefault().lookup(new Lookup.Template(WSEditorProvider.class));
            Collection services = results.allInstances();
            for (WSEditorProvider provider : services) {
                registry.register(provider);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DialogWindowListener
    extends WindowAdapter {
        Set<WSEditor> editors;

        public DialogWindowListener(Set<WSEditor> editors) {
            this.editors = editors;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            for (WSEditor editor : this.editors) {
                editor.cancel(EditWSAttributesCookieImpl.this.node, EditWSAttributesCookieImpl.this.jaxWsModel);
            }
        }
    }
}

