/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.websvc.core.webservices.ui.WebServicesChildren;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class WebServicesRootNode
extends AbstractNode {
    private static Image WEB_SERVICES_BADGE = Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/webservicegroup.png", (boolean)true);
    private static Icon folderIconCache;
    private static Icon openedFolderIconCache;
    private DataFolder srcFolder;

    public WebServicesRootNode(FileObject srcRoot) {
        super((Children)(srcRoot != null ? new WebServicesChildren(srcRoot) : Children.LEAF), WebServicesRootNode.createLookup(srcRoot));
        this.setDisplayName(NbBundle.getBundle(WebServicesRootNode.class).getString("LBL_WebServices"));
        this.srcFolder = srcRoot.isFolder() ? DataFolder.findFolder((FileObject)srcRoot) : null;
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = WebServicesRootNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = Utilities.mergeImages((Image)image, (Image)WEB_SERVICES_BADGE, (int)7, (int)7);
        return image;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class)};
    }

    private static Lookup createLookup(FileObject srcFolder) {
        if (srcFolder != null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)srcFolder);
            return Lookups.fixed((Object[])new Object[]{dataFolder});
        }
        return Lookups.fixed((Object[])new Object[0]);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

